/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.adapter;

import org.xmlobjects.gml.model.base.AggregationAttributes;
import org.xmlobjects.gml.model.base.AssociationAttributes;
import org.xmlobjects.gml.model.base.OwnershipAttributes;
import org.xmlobjects.gml.model.geometry.SRSInformation;
import org.xmlobjects.gml.model.geometry.SRSReference;
import org.xmlobjects.gml.model.valueobjects.ReferenceSystem;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public class GMLSerializerHelper {
    public static String getGMLBaseNamespace(Namespaces namespaces) {
        return namespaces.contains("http://www.opengis.net/gml") ? "http://www.opengis.net/gml" : "http://www.opengis.net/gml/3.2";
    }

    public static void serializeAssociationAttributes(Element element, AssociationAttributes object, Namespaces namespaces) {
        String baseNamespace = GMLSerializerHelper.getGMLBaseNamespace(namespaces);
        element.addAttribute("http://www.w3.org/1999/xlink", "href", object.getHref());
        element.addAttribute("http://www.w3.org/1999/xlink", "role", object.getRole());
        element.addAttribute("http://www.w3.org/1999/xlink", "arcrole", object.getArcRole());
        element.addAttribute("http://www.w3.org/1999/xlink", "title", object.getTitle());
        element.addAttribute(baseNamespace, "remoteSchema", object.getRemoteSchema());
        if (object.getShow() != null) {
            element.addAttribute("http://www.w3.org/1999/xlink", "show", object.getShow().toValue());
        }
        if (object.getActuate() != null) {
            element.addAttribute("http://www.w3.org/1999/xlink", "actuate", object.getActuate().toValue());
        }
        if (object.getNilReason() != null && "http://www.opengis.net/gml/3.2".equals(baseNamespace)) {
            element.addAttribute("nilReason", object.getNilReason().getValue());
        }
    }

    public static void serializeOwnershipAttributes(Element element, OwnershipAttributes object, Namespaces namespaces) {
        if ("http://www.opengis.net/gml/3.2".equals(GMLSerializerHelper.getGMLBaseNamespace(namespaces))) {
            element.addAttribute("owns", TextContent.ofBoolean((Boolean)object.getOwns()));
        }
    }

    public static void serializeAggregationAttributes(Element element, AggregationAttributes object, Namespaces namespaces) {
        if (object.getAggregationType() != null && "http://www.opengis.net/gml/3.2".equals(GMLSerializerHelper.getGMLBaseNamespace(namespaces))) {
            element.addAttribute("aggregationType", object.getAggregationType().toValue());
        }
    }

    public static void serializeSRSReference(Element element, SRSReference object, Namespaces namespaces) {
        element.addAttribute("srsName", object.getSrsName());
        element.addAttribute("srsDimension", TextContent.ofInteger((Integer)object.getSrsDimension()));
        GMLSerializerHelper.serializeSRSInformation(element, object, namespaces);
    }

    public static void serializeSRSInformation(Element element, SRSInformation object, Namespaces namespaces) {
        if (object.isSetAxisLabels()) {
            element.addAttribute("axisLabels", TextContent.ofList(object.getAxisLabels()));
        }
        if (object.isSetUomLabels()) {
            element.addAttribute("uomLabels", TextContent.ofList(object.getUomLabels()));
        }
    }

    public static void serializeReferenceSystem(Element element, ReferenceSystem object, Namespaces namespaces) {
        element.addAttribute("codeSpace", object.getCodeSpace());
        element.addAttribute("uom", object.getUom());
    }
}

