/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.adapter.temporal;

import java.time.LocalDate;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.gml.model.temporal.CalendarDate;
import org.xmlobjects.gml.model.temporal.ClockTime;
import org.xmlobjects.gml.model.temporal.DateAndTime;
import org.xmlobjects.gml.model.temporal.OrdinalPosition;
import org.xmlobjects.gml.model.temporal.TimeCoordinate;
import org.xmlobjects.gml.model.temporal.TimeIndeterminateValue;
import org.xmlobjects.gml.model.temporal.TimePosition;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

public class TimePositionAdapter
implements ObjectBuilder<TimePosition>,
ObjectSerializer<TimePosition> {
    public TimePosition createObject(QName name, Object parent) throws ObjectBuildException {
        return new TimePosition();
    }

    public void initializeObject(TimePosition object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        reader.getTextContent().ifPresent(object::setValue);
        attributes.getValue("frame").ifPresent(object::setFrame);
        attributes.getValue("calendarEraName").ifPresent(object::setCalendarEraName);
        attributes.getValue("indeterminatePosition").ifPresent(v -> object.setIndeterminatePosition(TimeIndeterminateValue.fromValue(v)));
    }

    public void initializeElement(Element element, TimePosition object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        if (object.isDateAndTime()) {
            DateAndTime dateAndTime = object.asDateAndTime();
            element.addTextContent(TextContent.ofDateTime((OffsetDateTime)dateAndTime.getValue()));
        } else if (object.isClockTime()) {
            ClockTime clockTime = object.asClockTime();
            OffsetTime time = clockTime.getValue();
            element.addTextContent(TextContent.ofTime((OffsetDateTime)OffsetDateTime.of(LocalDate.now(), time.toLocalTime(), time.getOffset())));
        } else if (object.isCalendarDate()) {
            CalendarDate date = object.asCalendarDate();
            switch (date.getType()) {
                case YEAR: {
                    element.addTextContent(TextContent.ofGYear((OffsetDateTime)date.getValue()));
                    break;
                }
                case YEAR_MONTH: {
                    element.addTextContent(TextContent.ofGYearMonth((OffsetDateTime)date.getValue()));
                    break;
                }
                default: {
                    element.addTextContent(TextContent.ofDate((OffsetDateTime)date.getValue()));
                    break;
                }
            }
        } else if (object.isTimeCoordinate()) {
            TimeCoordinate timeCoordinate = object.asTimeCoordinate();
            element.addTextContent(TextContent.ofDouble((Double)timeCoordinate.getValue()));
        } else if (object.isOrdinalPosition()) {
            OrdinalPosition ordinalPosition = object.asOrdinalPosition();
            element.addTextContent(ordinalPosition.getValue());
        }
        element.addAttribute("calendarEraName", object.getCalendarEraName());
        if (object.isSetFrame()) {
            element.addAttribute("frame", object.getFrame());
        }
        if (object.getIndeterminatePosition() != null) {
            element.addAttribute("indeterminatePosition", object.getIndeterminatePosition().toValue());
        }
    }
}

