/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.basictypes;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.xmlobjects.gml.model.GMLObject;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.geometry.DirectPosition;

public class Coordinates
extends GMLObject
implements CoordinateListProvider {
    public static final String DEFAULT_DECIMAL = ".";
    public static final String DEFAULT_COORDINATE_SEPARATOR = ",";
    public static final String DEFAULT_TUPLE_SEPARATOR = " ";
    private String value;
    private String decimal;
    private String cs;
    private String ts;

    public Coordinates() {
    }

    public Coordinates(String value) {
        this.setValue(value);
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value != null ? value.trim().replaceAll("\\R+", this.getTupleSeparator()) : null;
    }

    public String getDecimal() {
        return this.decimal != null ? this.decimal : DEFAULT_DECIMAL;
    }

    public void setDecimal(String decimal) {
        this.decimal = decimal;
    }

    public String getCoordinateSeparator() {
        return this.cs != null ? this.cs : DEFAULT_COORDINATE_SEPARATOR;
    }

    public void setCoordinateSeparator(String cs) {
        this.cs = cs;
    }

    public String getTupleSeparator() {
        return this.ts != null ? this.ts : DEFAULT_TUPLE_SEPARATOR;
    }

    public void setTupleSeparator(String ts) {
        this.ts = ts;
    }

    public DirectPosition toDirectPosition() {
        List<List<Double>> coordinates = this.toCoordinateList(false);
        return new DirectPosition(!coordinates.isEmpty() ? coordinates.get(0) : new ArrayList());
    }

    public List<DirectPosition> toDirectPositions() {
        List<List<Double>> coordinates = this.toCoordinateList(false);
        ArrayList<DirectPosition> positions = new ArrayList<DirectPosition>(coordinates.size());
        coordinates.stream().map(DirectPosition::new).forEach(positions::add);
        return positions;
    }

    @Override
    public List<Double> toCoordinateList3D() {
        List<List<Double>> coordinates = this.toCoordinateList(true);
        ArrayList<Double> flatList = new ArrayList<Double>(coordinates.size() * 3);
        coordinates.forEach(flatList::addAll);
        return flatList;
    }

    private List<List<Double>> toCoordinateList(boolean force3D) {
        ArrayList coordinates = null;
        boolean isValid = true;
        if (this.value != null) {
            String decimalPattern = Pattern.quote(this.getDecimal()) + "+";
            String csPattern = Pattern.quote(this.getCoordinateSeparator()) + "+";
            String tsPattern = Pattern.quote(this.getTupleSeparator()) + "+";
            String[] tuples = this.value.split(tsPattern);
            coordinates = new ArrayList(tuples.length);
            for (int i = 0; i < tuples.length && isValid; ++i) {
                String[] coords = tuples[i].split(csPattern);
                int size = force3D ? 3 : coords.length;
                ArrayList<Double> pos = new ArrayList<Double>(size);
                for (int j = 0; j < size && isValid; ++j) {
                    if (j < coords.length) {
                        try {
                            pos.add(Double.parseDouble(coords[j].replaceAll(decimalPattern, DEFAULT_DECIMAL)));
                        }
                        catch (Throwable e) {
                            isValid = false;
                        }
                        continue;
                    }
                    pos.add(0.0);
                }
                coordinates.add(pos);
            }
        }
        return coordinates != null && isValid ? coordinates : Collections.emptyList();
    }
}

