/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlobjects.gml.model.GMLObject;
import org.xmlobjects.gml.model.common.CoordinateListProvider;
import org.xmlobjects.gml.model.geometry.SRSReference;

public class DirectPosition
extends GMLObject
implements SRSReference,
CoordinateListProvider {
    private List<Double> value;
    private String srsName;
    private Integer srsDimension;
    private List<String> axisLabels;
    private List<String> uomLabels;

    public DirectPosition() {
    }

    public DirectPosition(List<Double> value) {
        this.value = value;
    }

    public DirectPosition(double ... ordinates) {
        if (ordinates != null && ordinates.length > 0) {
            this.value = new ArrayList<Double>(ordinates.length);
            for (double ordinate : ordinates) {
                this.value.add(ordinate);
            }
        }
    }

    public List<Double> getValue() {
        if (this.value == null) {
            this.value = new ArrayList<Double>();
        }
        return this.value;
    }

    public boolean isSetValue() {
        return this.value != null && !this.value.isEmpty();
    }

    public void setValue(List<Double> value) {
        this.value = value;
    }

    @Override
    public String getSrsName() {
        return this.srsName;
    }

    @Override
    public void setSrsName(String srsName) {
        this.srsName = srsName;
    }

    @Override
    public Integer getSrsDimension() {
        return this.srsDimension;
    }

    @Override
    public void setSrsDimension(Integer srsDimension) {
        if (srsDimension == null || srsDimension > 0) {
            this.srsDimension = srsDimension;
        }
    }

    @Override
    public List<String> getAxisLabels() {
        return this.axisLabels;
    }

    @Override
    public boolean isSetAxisLabels() {
        return this.axisLabels != null && !this.axisLabels.isEmpty();
    }

    @Override
    public void setAxisLabels(List<String> axisLabels) {
        if (axisLabels == null) {
            axisLabels = new ArrayList<String>();
        }
        this.axisLabels = axisLabels;
    }

    @Override
    public List<String> getUomLabels() {
        if (this.uomLabels == null) {
            this.uomLabels = new ArrayList<String>();
        }
        return this.uomLabels;
    }

    @Override
    public boolean isSetUomLabels() {
        return this.uomLabels != null && !this.uomLabels.isEmpty();
    }

    @Override
    public void setUomLabels(List<String> uomLabels) {
        this.uomLabels = uomLabels;
    }

    @Override
    public List<Double> toCoordinateList3D() {
        List<Double> coordinates = null;
        if (this.value != null && !this.value.isEmpty()) {
            coordinates = new ArrayList<Double>(3);
            for (int i = 0; i < 3; ++i) {
                coordinates.add(i < this.value.size() ? this.value.get(i) : 0.0);
            }
        }
        return coordinates != null ? coordinates : Collections.emptyList();
    }
}

