/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry.primitives;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlobjects.gml.model.geometry.primitives.AbstractCurve;
import org.xmlobjects.gml.model.geometry.primitives.AbstractCurveSegment;
import org.xmlobjects.gml.model.geometry.primitives.CurveSegmentArrayProperty;
import org.xmlobjects.gml.visitor.GeometryVisitor;
import org.xmlobjects.gml.visitor.ObjectVisitor;

public class Curve
extends AbstractCurve {
    private CurveSegmentArrayProperty segments;

    public Curve() {
    }

    public Curve(CurveSegmentArrayProperty segments) {
        this.setSegments(segments);
    }

    public CurveSegmentArrayProperty getSegments() {
        return this.segments;
    }

    public void setSegments(CurveSegmentArrayProperty segments) {
        this.segments = this.asChild(segments);
    }

    @Override
    public List<Double> toCoordinateList3D() {
        if (this.segments != null && this.segments.isSetObjects()) {
            ArrayList<Double> coordinates = new ArrayList<Double>();
            for (AbstractCurveSegment segment : this.segments.getObjects()) {
                List candidates;
                if (segment == null || (candidates = segment.toCoordinateList3D()).isEmpty()) continue;
                int size = coordinates.size();
                if (size == 0) {
                    coordinates.addAll(candidates);
                    continue;
                }
                if (((Double)candidates.get(0)).doubleValue() == ((Double)coordinates.get(size - 3)).doubleValue() && ((Double)candidates.get(1)).doubleValue() == ((Double)coordinates.get(size - 2)).doubleValue() && ((Double)candidates.get(2)).doubleValue() == ((Double)coordinates.get(size - 1)).doubleValue()) {
                    coordinates.addAll(candidates.subList(3, candidates.size()));
                    continue;
                }
                coordinates.addAll(candidates);
            }
            return coordinates;
        }
        return Collections.emptyList();
    }

    @Override
    public void accept(ObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

