/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.geometry.primitives;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlobjects.gml.model.base.AggregationAttributes;
import org.xmlobjects.gml.model.base.AggregationType;
import org.xmlobjects.gml.model.geometry.primitives.AbstractCurve;
import org.xmlobjects.gml.model.geometry.primitives.AbstractRing;
import org.xmlobjects.gml.model.geometry.primitives.CurveProperty;
import org.xmlobjects.gml.visitor.GeometryVisitor;
import org.xmlobjects.gml.visitor.ObjectVisitor;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;

public class Ring
extends AbstractRing
implements AggregationAttributes {
    private List<CurveProperty> curveMembers;
    private AggregationType aggregationType;

    public Ring() {
    }

    public Ring(List<CurveProperty> curveMembers) {
        this.setCurveMembers(curveMembers);
    }

    public List<CurveProperty> getCurveMembers() {
        if (this.curveMembers == null) {
            this.curveMembers = new ChildList((Child)this);
        }
        return this.curveMembers;
    }

    public boolean isSetCurveMembers() {
        return this.curveMembers != null && !this.curveMembers.isEmpty();
    }

    public void setCurveMembers(List<CurveProperty> curveMembers) {
        this.curveMembers = this.asChild(curveMembers);
    }

    @Override
    public AggregationType getAggregationType() {
        return this.aggregationType;
    }

    @Override
    public void setAggregationType(AggregationType aggregationType) {
        this.aggregationType = aggregationType;
    }

    @Override
    public List<Double> toCoordinateList3D() {
        if (this.curveMembers != null && !this.curveMembers.isEmpty()) {
            ArrayList<Double> coordinates = new ArrayList<Double>();
            for (CurveProperty property : this.curveMembers) {
                List candidates;
                if (property == null || property.getObject() == null || (candidates = ((AbstractCurve)property.getObject()).toCoordinateList3D()).isEmpty()) continue;
                int size = coordinates.size();
                if (size == 0) {
                    coordinates.addAll(candidates);
                    continue;
                }
                if (((Double)candidates.get(0)).doubleValue() == ((Double)coordinates.get(size - 3)).doubleValue() && ((Double)candidates.get(1)).doubleValue() == ((Double)coordinates.get(size - 2)).doubleValue() && ((Double)candidates.get(2)).doubleValue() == ((Double)coordinates.get(size - 1)).doubleValue()) {
                    coordinates.addAll(candidates.subList(3, candidates.size()));
                    continue;
                }
                coordinates.addAll(candidates);
            }
            return coordinates;
        }
        return Collections.emptyList();
    }

    @Override
    public void accept(ObjectVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void accept(GeometryVisitor visitor) {
        visitor.visit(this);
    }
}

