/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.gml.model.temporal;

import java.time.LocalDate;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import org.xmlobjects.gml.model.temporal.CalenderDateType;
import org.xmlobjects.gml.model.temporal.TimePositionValue;

public class CalendarDate
implements TimePositionValue<OffsetDateTime> {
    private final OffsetDateTime date;
    private final CalenderDateType type;

    public CalendarDate(OffsetDateTime date, CalenderDateType type) {
        this.date = date;
        this.type = type;
    }

    private static CalendarDate ofDate(OffsetDateTime date, CalenderDateType type) {
        return new CalendarDate(date, type);
    }

    private static CalendarDate ofDate(LocalDate date, CalenderDateType type) {
        return new CalendarDate(OffsetDateTime.of(date, LocalTime.MIN, ZoneOffset.UTC), type);
    }

    public static CalendarDate ofDate(OffsetDateTime date) {
        return CalendarDate.ofDate(date, CalenderDateType.DATE);
    }

    public static CalendarDate ofDate(LocalDate date) {
        return CalendarDate.ofDate(date, CalenderDateType.DATE);
    }

    public static CalendarDate ofYear(OffsetDateTime date) {
        return CalendarDate.ofDate(date, CalenderDateType.YEAR);
    }

    public static CalendarDate ofYear(LocalDate date) {
        return CalendarDate.ofDate(date, CalenderDateType.YEAR);
    }

    public static CalendarDate ofYearMonth(OffsetDateTime date) {
        return CalendarDate.ofDate(date, CalenderDateType.YEAR_MONTH);
    }

    public static CalendarDate ofYearMonth(LocalDate date) {
        return CalendarDate.ofDate(date, CalenderDateType.YEAR_MONTH);
    }

    @Override
    public OffsetDateTime getValue() {
        return this.date;
    }

    public CalenderDateType getType() {
        return this.type;
    }

    public boolean isDate() {
        return this.type == CalenderDateType.DATE;
    }

    public boolean isYear() {
        return this.type == CalenderDateType.YEAR;
    }

    public boolean isYearMonth() {
        return this.type == CalenderDateType.YEAR_MONTH;
    }
}

