/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter;

import java.time.OffsetDateTime;
import javax.xml.namespace.QName;
import org.xmlobjects.annotation.XMLElement;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.AdministrativeAreaAdapter;
import org.xmlobjects.xal.adapter.CountryAdapter;
import org.xmlobjects.xal.adapter.FreeTextAddressAdapter;
import org.xmlobjects.xal.adapter.GeoRSSAdapter;
import org.xmlobjects.xal.adapter.LocalityAdapter;
import org.xmlobjects.xal.adapter.LocationByCoordinatesAdapter;
import org.xmlobjects.xal.adapter.PostCodeAdapter;
import org.xmlobjects.xal.adapter.PostOfficeAdapter;
import org.xmlobjects.xal.adapter.PostalDeliveryPointAdapter;
import org.xmlobjects.xal.adapter.PremisesAdapter;
import org.xmlobjects.xal.adapter.RuralDeliveryAdapter;
import org.xmlobjects.xal.adapter.ThoroughfareAdapter;
import org.xmlobjects.xal.adapter.XALBuilderHelper;
import org.xmlobjects.xal.adapter.XALSerializerHelper;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.AdministrativeArea;
import org.xmlobjects.xal.model.Country;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.GeoRSS;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.LocationByCoordinates;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.RuralDelivery;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.types.AddressType;
import org.xmlobjects.xal.model.types.AddressUsage;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

@XMLElement(name="Address", namespaceURI="urn:oasis:names:tc:ciq:xal:3")
public class AddressAdapter
extends AddressObjectAdapter<Address> {
    public Address createObject(QName name, Object parent) throws ObjectBuildException {
        return new Address();
    }

    @Override
    public void initializeObject(Address object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "Type").ifPresent(v -> object.setType(AddressType.fromValue(v)));
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "AddressID").collapse().ifPresent(object::setAddressId);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "AddressIDType").normalize().ifPresent(object::setAddressIdType);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "ID").collapse().ifPresent(object::setAddressId);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "Usage").ifPresent(v -> object.setUsage(AddressUsage.fromValue(v)));
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "DeliveryMode").normalize().ifPresent(object::setDeliveryMode);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "Status").ifPresent(object::setStatus);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "AddressKey").collapse().ifPresent(object::setAddressKey);
        attributes.getValue("urn:oasis:names:tc:ciq:xal:3", "AddressKeyRef").collapse().ifPresent(object::setAddressKeyRef);
        attributes.getValue("urn:oasis:names:tc:ciq:ct:3", "DateValidFrom").ifDateTime(object::setDateValidFrom);
        attributes.getValue("urn:oasis:names:tc:ciq:ct:3", "DateValidTo").ifDateTime(object::setDateValidTo);
        attributes.getValue("urn:oasis:names:tc:ciq:ct:3", "LanguageCode").ifPresent(object::setLanguageCode);
        attributes.getValue("http://www.w3.org/1999/xlink", "type").ifPresent(object::setXlinkType);
        attributes.getValue("http://www.w3.org/1999/xlink", "label").ifPresent(object::setXlinkLabel);
        attributes.getValue("http://www.w3.org/1999/xlink", "href").ifPresent(object::setXlinkHRef);
        XALBuilderHelper.buildDataQualityAttributes(object, attributes);
    }

    public void buildChildObject(Address object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xal:3".equals(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "FreeTextAddress": {
                    object.setFreeTextAddress((FreeTextAddress)reader.getObjectUsingBuilder(FreeTextAddressAdapter.class));
                    break;
                }
                case "Country": {
                    object.setCountry((Country)reader.getObjectUsingBuilder(CountryAdapter.class));
                    break;
                }
                case "AdministrativeArea": {
                    object.setAdministrativeArea((AdministrativeArea)reader.getObjectUsingBuilder(AdministrativeAreaAdapter.class));
                    break;
                }
                case "Locality": {
                    object.setLocality((Locality)reader.getObjectUsingBuilder(LocalityAdapter.class));
                    break;
                }
                case "Thoroughfare": {
                    object.setThoroughfare((Thoroughfare)reader.getObjectUsingBuilder(ThoroughfareAdapter.class));
                    break;
                }
                case "Premises": {
                    object.setPremises((Premises)reader.getObjectUsingBuilder(PremisesAdapter.class));
                    break;
                }
                case "PostCode": {
                    object.setPostCode((PostCode)reader.getObjectUsingBuilder(PostCodeAdapter.class));
                    break;
                }
                case "RuralDelivery": {
                    object.setRuralDelivery((RuralDelivery)reader.getObjectUsingBuilder(RuralDeliveryAdapter.class));
                    break;
                }
                case "PostalDeliveryPoint": {
                    object.setPostalDeliveryPoint((PostalDeliveryPoint)reader.getObjectUsingBuilder(PostalDeliveryPointAdapter.class));
                    break;
                }
                case "PostOffice": {
                    object.setPostOffice((PostOffice)reader.getObjectUsingBuilder(PostOfficeAdapter.class));
                    break;
                }
                case "GeoRSS": {
                    object.setGeoRSS((GeoRSS)reader.getObjectUsingBuilder(GeoRSSAdapter.class));
                    break;
                }
                case "LocationByCoordinates": {
                    object.setLocationByCoordinates((LocationByCoordinates)reader.getObjectUsingBuilder(LocationByCoordinatesAdapter.class));
                }
            }
        }
    }

    public Element createElement(Address object, Namespaces namespaces) throws ObjectSerializeException {
        return Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"Address");
    }

    @Override
    public void initializeElement(Element element, Address object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "AddressID", TextContent.of((String)object.getAddressId()).collapse());
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "AddressIDType", TextContent.of((String)object.getAddressIdType()).normalize());
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "ID", TextContent.of((String)object.getId()).collapse());
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "DeliveryMode", TextContent.of((String)object.getDeliveryMode()).normalize());
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "Status", object.getStatus());
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "AddressKey", TextContent.of((String)object.getAddressKey()).collapse());
        element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "AddressKeyRef", TextContent.of((String)object.getAddressKeyRef()).collapse());
        element.addAttribute("urn:oasis:names:tc:ciq:ct:3", "DateValidFrom", TextContent.ofDateTime((OffsetDateTime)object.getDateValidFrom()));
        element.addAttribute("urn:oasis:names:tc:ciq:ct:3", "DateValidTo", TextContent.ofDateTime((OffsetDateTime)object.getDateValidTo()));
        element.addAttribute("urn:oasis:names:tc:ciq:ct:3", "LanguageCode", object.getLanguageCode());
        element.addAttribute("http://www.w3.org/1999/xlink", "type", object.getXlinkType());
        element.addAttribute("http://www.w3.org/1999/xlink", "label", object.getXlinkLabel());
        element.addAttribute("http://www.w3.org/1999/xlink", "href", object.getXlinkHRef());
        XALSerializerHelper.addDataQualityAttributes(element, object);
        if (object.getType() != null) {
            element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "Type", object.getType().toValue());
        }
        if (object.getUsage() != null) {
            element.addAttribute("urn:oasis:names:tc:ciq:xal:3", "Usage", object.getUsage().toValue());
        }
    }

    public void writeChildElements(Address object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        if (object.getFreeTextAddress() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"FreeTextAddress"), (Object)object.getFreeTextAddress(), FreeTextAddressAdapter.class, namespaces);
        }
        if (object.getCountry() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"Country"), (Object)object.getCountry(), CountryAdapter.class, namespaces);
        }
        if (object.getAdministrativeArea() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"AdministrativeArea"), (Object)object.getAdministrativeArea(), AdministrativeAreaAdapter.class, namespaces);
        }
        if (object.getLocality() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"Locality"), (Object)object.getLocality(), LocalityAdapter.class, namespaces);
        }
        if (object.getThoroughfare() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"Thoroughfare"), (Object)object.getThoroughfare(), ThoroughfareAdapter.class, namespaces);
        }
        if (object.getPremises() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"Premises"), (Object)object.getPremises(), PremisesAdapter.class, namespaces);
        }
        if (object.getPostCode() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"PostCode"), (Object)object.getPostCode(), PostCodeAdapter.class, namespaces);
        }
        if (object.getRuralDelivery() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"RuralDelivery"), (Object)object.getRuralDelivery(), RuralDeliveryAdapter.class, namespaces);
        }
        if (object.getPostalDeliveryPoint() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"PostalDeliveryPoint"), (Object)object.getPostalDeliveryPoint(), PostalDeliveryPointAdapter.class, namespaces);
        }
        if (object.getPostOffice() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"PostOffice"), (Object)object.getPostOffice(), PostOfficeAdapter.class, namespaces);
        }
        if (object.getGeoRSS() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"GeoRSS"), (Object)object.getGeoRSS(), GeoRSSAdapter.class, namespaces);
        }
        if (object.getLocationByCoordinates() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xal:3", (String)"LocationByCoordinates"), (Object)object.getLocationByCoordinates(), LocationByCoordinatesAdapter.class, namespaces);
        }
    }
}

