/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import java.time.OffsetDateTime;
import javax.xml.namespace.QName;
import org.xmlobjects.annotation.XMLElement;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.AddressAdapter;
import org.xmlobjects.xal.adapter.deprecated.AddressLinesAdapter;
import org.xmlobjects.xal.adapter.deprecated.AdministrativeAreaAdapter;
import org.xmlobjects.xal.adapter.deprecated.CountryAdapter;
import org.xmlobjects.xal.adapter.deprecated.LocalityAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalServiceElementsAdapter;
import org.xmlobjects.xal.adapter.deprecated.ThoroughfareAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.AddressObject;
import org.xmlobjects.xal.model.AdministrativeArea;
import org.xmlobjects.xal.model.Country;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.PostalServiceElements;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.AddressType;
import org.xmlobjects.xal.model.types.AddressUsage;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;
import org.xmlobjects.xml.TextContent;

@XMLElement(name="AddressDetails", namespaceURI="urn:oasis:names:tc:ciq:xsdschema:xAL:2.0")
public class AddressDetailsAdapter
extends AddressObjectAdapter<Address> {
    public Address createObject(QName name, Object parent) throws ObjectBuildException {
        return new Address();
    }

    @Override
    public void initializeObject(Address object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("CurrentStatus").ifPresent(object::setStatus);
        attributes.getValue("AddressDetailsKey").ifPresent(object::setAddressKey);
        attributes.getValue("Code").ifPresent(v -> object.getOtherAttributes().add("Code", v));
        attributes.getValue("AddressType").ifPresent(v -> {
            AddressType type = AddressType.fromValue(v);
            if (type != null) {
                object.setType(type);
            } else {
                object.getOtherAttributes().add("AddressType", v);
            }
        });
        attributes.getValue("Usage").ifPresent(v -> {
            AddressUsage usage = AddressUsage.fromValue(v);
            if (usage != null) {
                object.setUsage(usage);
            } else {
                object.getOtherAttributes().add("Usage", v);
            }
        });
        TextContent validFromDate = attributes.getValue("ValidFromDate");
        if (validFromDate.isDateTime()) {
            object.setDateValidFrom(validFromDate.getAsDateTime());
        } else if (validFromDate.isPresent()) {
            object.getOtherAttributes().add("ValidFromDate", validFromDate.get());
        }
        TextContent validToDate = attributes.getValue("ValidToDate");
        if (validToDate.isDateTime()) {
            object.setDateValidFrom(validToDate.getAsDateTime());
        } else if (validToDate.isPresent()) {
            object.getOtherAttributes().add("ValidToDate", validToDate.get());
        }
    }

    public void buildChildObject(Address object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "Address": {
                    object.setFreeTextAddress((FreeTextAddress)reader.getObjectUsingBuilder(AddressAdapter.class));
                    break;
                }
                case "AddressLines": {
                    object.setFreeTextAddress((FreeTextAddress)reader.getObjectUsingBuilder(AddressLinesAdapter.class));
                    break;
                }
                case "Country": {
                    object.setCountry((Country)reader.getObjectUsingBuilder(CountryAdapter.class));
                    break;
                }
                case "AdministrativeArea": {
                    object.setAdministrativeArea((AdministrativeArea)reader.getObjectUsingBuilder(AdministrativeAreaAdapter.class));
                    break;
                }
                case "Locality": {
                    object.setLocality((Locality)reader.getObjectUsingBuilder(LocalityAdapter.class));
                    break;
                }
                case "Thoroughfare": {
                    object.setThoroughfare((Thoroughfare)reader.getObjectUsingBuilder(ThoroughfareAdapter.class));
                    break;
                }
                case "PostalServiceElements": {
                    object.getDeprecatedProperties().setPostalServiceElements((PostalServiceElements)reader.getObjectUsingBuilder(PostalServiceElementsAdapter.class));
                }
            }
        }
    }

    public Element createElement(Address object, Namespaces namespaces) throws ObjectSerializeException {
        return Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"AddressDetails");
    }

    @Override
    public void initializeElement(Element element, Address object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("CurrentStatus", object.getStatus());
        element.addAttribute("AddressDetailsKey", object.getAddressKey());
        element.addAttribute("Code", object.getOtherAttributes().getValue("Code"));
        if (object.getType() != null) {
            element.addAttribute("AddressType", object.getType().toValue());
        } else {
            element.addAttribute("AddressType", object.getOtherAttributes().getValue("AddressType"));
        }
        if (object.getUsage() != null) {
            element.addAttribute("Usage", object.getUsage().toValue());
        } else {
            element.addAttribute("Usage", object.getOtherAttributes().getValue("Usage"));
        }
        if (object.getDateValidFrom() != null) {
            element.addAttribute("ValidFromDate", TextContent.ofDateTime((OffsetDateTime)object.getDateValidFrom()));
        } else {
            element.addAttribute("ValidFromDate", object.getOtherAttributes().getValue("ValidFromDate"));
        }
        if (object.getDateValidTo() != null) {
            element.addAttribute("ValidToDate", TextContent.ofDateTime((OffsetDateTime)object.getDateValidTo()));
        } else {
            element.addAttribute("ValidToDate", object.getOtherAttributes().getValue("ValidToDate"));
        }
    }

    public void writeChildElements(Address object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        if (object.hasDeprecatedProperties() && object.getDeprecatedProperties().getPostalServiceElements() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalServiceElements"), (Object)object.getDeprecatedProperties().getPostalServiceElements(), PostalServiceElementsAdapter.class, namespaces);
        }
        if (object.getCountry() != null) {
            this.writeAddressObject(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Country"), object.getCountry(), CountryAdapter.class, object, namespaces, writer);
        } else if (object.getAdministrativeArea() != null) {
            this.writeAddressObject(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"AdministrativeArea"), object.getAdministrativeArea(), AdministrativeAreaAdapter.class, object, namespaces, writer);
        } else if (object.getLocality() != null) {
            this.writeAddressObject(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Locality"), object.getLocality(), LocalityAdapter.class, object, namespaces, writer);
        } else if (object.getThoroughfare() != null) {
            this.writeAddressObject(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Thoroughfare"), object.getThoroughfare(), ThoroughfareAdapter.class, object, namespaces, writer);
        } else if (object.getFreeTextAddress() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"AddressLines"), (Object)object.getFreeTextAddress(), AddressLinesAdapter.class, namespaces);
        }
    }

    private <T extends AddressObject> void writeAddressObject(Element element, T object, Class<? extends ObjectSerializer<T>> type, Address address, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        ObjectSerializer serializer = writer.getOrCreateSerializer(type);
        serializer.initializeElement(element, object, namespaces, writer);
        writer.writeStartElement(element);
        if (address.getFreeTextAddress() != null && address.getFreeTextAddress().isSetAddressLines()) {
            for (AddressLine addressLine : address.getFreeTextAddress().getAddressLines()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"AddressLine"), (Object)addressLine, AddressLineAdapter.class, namespaces);
            }
        }
        writer.writeObjectUsingSerializer(object, serializer, namespaces);
        writer.writeEndElement();
    }
}

