/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.model.Child;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.LargeMailUserAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostBoxAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostOfficeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalCodeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalRouteAdapter;
import org.xmlobjects.xal.adapter.deprecated.PremiseAdapter;
import org.xmlobjects.xal.adapter.deprecated.ThoroughfareAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.DependentLocalityNameAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.DependentLocalityNumberAdapter;
import org.xmlobjects.xal.model.AbstractThoroughfare;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.SubLocality;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfSubLocality;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.SubLocalityName;
import org.xmlobjects.xal.model.types.SubLocalityNameType;
import org.xmlobjects.xal.model.types.SubLocalityType;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class DependentLocalityAdapter
extends AddressObjectAdapter<SubLocality> {
    public SubLocality createObject(QName name, Object parent) throws ObjectBuildException {
        SubLocality object = new SubLocality();
        if (parent instanceof Child) {
            Child child = (Child)parent;
            object.setParent(child);
        }
        return object;
    }

    @Override
    public void initializeObject(SubLocality object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("UsageType").ifPresent(v -> object.getOtherAttributes().add("UsageType", v));
        attributes.getValue("Connector").ifPresent(v -> object.getOtherAttributes().add("Connector", v));
        attributes.getValue("Indicator").ifPresent(v -> object.getOtherAttributes().add("Indicator", v));
        attributes.getValue("Type").ifPresent(v -> {
            SubLocalityType type = SubLocalityType.fromValue(v);
            if (type != null) {
                object.setType(type);
            } else {
                object.getOtherAttributes().add("Type", v);
            }
        });
    }

    public void buildChildObject(SubLocality object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            Address address = (Address)object.getParent(Address.class);
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    if (address == null) break;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "DependentLocalityName": {
                    object.getNameElements().add((SubLocalityName)reader.getObjectUsingBuilder(DependentLocalityNameAdapter.class));
                    break;
                }
                case "DependentLocalityNumber": {
                    object.getNameElements().add((SubLocalityName)reader.getObjectUsingBuilder(DependentLocalityNumberAdapter.class));
                    break;
                }
                case "PostBox": {
                    PostalDeliveryPoint postBox = (PostalDeliveryPoint)reader.getObjectUsingBuilder(PostBoxAdapter.class);
                    if (address != null && address.getPostalDeliveryPoint() == null) {
                        address.setPostalDeliveryPoint(postBox);
                        break;
                    }
                    object.getDeprecatedProperties().setPostBox(postBox);
                    break;
                }
                case "LargeMailUser": {
                    Premises largeMailUser = (Premises)reader.getObjectUsingBuilder(LargeMailUserAdapter.class);
                    if (address != null && address.getPremises() == null) {
                        address.setPremises(largeMailUser);
                        break;
                    }
                    object.getDeprecatedProperties().setLargeMailUser(largeMailUser);
                    break;
                }
                case "PostOffice": {
                    PostOffice postOffice = (PostOffice)reader.getObjectUsingBuilder(PostOfficeAdapter.class);
                    if (address != null && address.getPostOffice() == null) {
                        address.setPostOffice(postOffice);
                        break;
                    }
                    object.getDeprecatedProperties().setPostOffice(postOffice);
                    break;
                }
                case "PostalRoute": {
                    object.getDeprecatedProperties().setPostalRoute((Thoroughfare)reader.getObjectUsingBuilder(PostalRouteAdapter.class));
                    break;
                }
                case "Thoroughfare": {
                    Thoroughfare thoroughfare = (Thoroughfare)reader.getObjectUsingBuilder(ThoroughfareAdapter.class);
                    if (address != null && address.getThoroughfare() == null) {
                        address.setThoroughfare(thoroughfare);
                        break;
                    }
                    object.getDeprecatedProperties().setThoroughfare(thoroughfare);
                    break;
                }
                case "Premise": {
                    Premises premise = (Premises)reader.getObjectUsingBuilder(PremiseAdapter.class);
                    if (address != null && address.getPremises() == null) {
                        address.setPremises(premise);
                        break;
                    }
                    object.getDeprecatedProperties().setPremise(premise);
                    break;
                }
                case "DependentLocality": {
                    object.getDeprecatedProperties().setDependentLocality((SubLocality)reader.getObjectUsingBuilder(DependentLocalityAdapter.class));
                    break;
                }
                case "PostalCode": {
                    PostCode postalCode = (PostCode)reader.getObjectUsingBuilder(PostalCodeAdapter.class);
                    if (address != null && address.getPostCode() == null) {
                        address.setPostCode(postalCode);
                        break;
                    }
                    object.getDeprecatedProperties().setPostalCode(postalCode);
                }
            }
        }
    }

    @Override
    public void initializeElement(Element element, SubLocality object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("Type", object.getOtherAttributes().getValue("Type"));
        element.addAttribute("UsageType", object.getOtherAttributes().getValue("UsageType"));
        element.addAttribute("Connector", object.getOtherAttributes().getValue("Connector"));
        element.addAttribute("Indicator", object.getOtherAttributes().getValue("Indicator"));
    }

    public void writeChildElements(SubLocality object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        DeprecatedPropertiesOfSubLocality properties;
        Address address = (Address)object.getParent(Address.class);
        SubLocalityName number = null;
        DeprecatedPropertiesOfSubLocality deprecatedPropertiesOfSubLocality = properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        if (object.isSetNameElements()) {
            for (SubLocalityName nameElement : object.getNameElements()) {
                if (nameElement.getNameType() == SubLocalityNameType.NAME) {
                    writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"DependentLocalityName"), (Object)nameElement, DependentLocalityNameAdapter.class, namespaces);
                    continue;
                }
                if (number != null || nameElement.getNameType() != SubLocalityNameType.NUMBER) continue;
                number = nameElement;
            }
        }
        if (number != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"DependentLocalityNumber"), number, DependentLocalityNumberAdapter.class, namespaces);
        }
        if (properties != null) {
            if (properties.getPostBox() != null) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostBox"), (Object)properties.getPostBox(), PostBoxAdapter.class, namespaces);
            } else if (properties.getLargeMailUser() != null) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"LargeMailUser"), (Object)properties.getLargeMailUser(), LargeMailUserAdapter.class, namespaces);
            } else if (properties.getPostOffice() != null) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostOffice"), (Object)properties.getPostOffice(), PostOfficeAdapter.class, namespaces);
            } else if (properties.getPostalRoute() != null) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalRoute"), (Object)properties.getPostalRoute(), PostalRouteAdapter.class, namespaces);
            }
        }
        boolean hasDependentLocality = properties != null && properties.getDependentLocality() != null;
        boolean hasParentThoroughfare = object.getParent(AbstractThoroughfare.class) != null;
        Thoroughfare thoroughfare = null;
        if (!hasDependentLocality && !hasParentThoroughfare && address != null && address.getThoroughfare() != null) {
            thoroughfare = address.getThoroughfare();
        } else if (properties != null) {
            thoroughfare = properties.getThoroughfare();
        }
        if (thoroughfare != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Thoroughfare"), (Object)thoroughfare, ThoroughfareAdapter.class, namespaces);
        }
        Premises premise = null;
        if (!hasDependentLocality && address != null && (address.getThoroughfare() == null || hasParentThoroughfare) && address.getPremises() != null) {
            premise = address.getPremises();
        } else if (properties != null) {
            premise = properties.getPremise();
        }
        if (premise != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Premise"), (Object)premise, PremiseAdapter.class, namespaces);
        }
        if (properties != null) {
            if (properties.getDependentLocality() != null) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"DependentLocality"), (Object)properties.getDependentLocality(), DependentLocalityAdapter.class, namespaces);
            }
            if (properties.getPostalCode() != null) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalCode"), (Object)properties.getPostalCode(), PostalCodeAdapter.class, namespaces);
            }
        }
    }
}

