/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.model.Child;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.DependentLocalityAdapter;
import org.xmlobjects.xal.adapter.deprecated.LargeMailUserAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostBoxAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostOfficeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalCodeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalRouteAdapter;
import org.xmlobjects.xal.adapter.deprecated.PremiseAdapter;
import org.xmlobjects.xal.adapter.deprecated.ThoroughfareAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.LocalityNameAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.SubLocality;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfLocality;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.LocalityName;
import org.xmlobjects.xal.model.types.LocalityType;
import org.xmlobjects.xal.model.types.PostalDeliveryPointType;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class LocalityAdapter
extends AddressObjectAdapter<Locality> {
    public Locality createObject(QName name, Object parent) throws ObjectBuildException {
        Locality object = new Locality();
        if (parent instanceof Child) {
            Child child = (Child)parent;
            object.setParent(child);
        }
        return object;
    }

    @Override
    public void initializeObject(Locality object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("UsageType").ifPresent(v -> object.getOtherAttributes().add("UsageType", v));
        attributes.getValue("Indicator").ifPresent(v -> object.getOtherAttributes().add("Indicator", v));
        attributes.getValue("Type").ifPresent(v -> {
            LocalityType type = LocalityType.fromValue(v);
            if (type != null) {
                object.setType(type);
            } else {
                object.getOtherAttributes().add("Type", v);
            }
        });
    }

    public void buildChildObject(Locality object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            Address address = (Address)object.getParent(Address.class);
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    if (address == null) break;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "LocalityName": {
                    object.getNameElements().add((LocalityName)reader.getObjectUsingBuilder(LocalityNameAdapter.class));
                    break;
                }
                case "PostBox": {
                    PostalDeliveryPoint postBox = (PostalDeliveryPoint)reader.getObjectUsingBuilder(PostBoxAdapter.class);
                    if (address != null && address.getPostalDeliveryPoint() == null) {
                        address.setPostalDeliveryPoint(postBox);
                        break;
                    }
                    object.getDeprecatedProperties().setPostBox(postBox);
                    break;
                }
                case "LargeMailUser": {
                    Premises largeMailUser = (Premises)reader.getObjectUsingBuilder(LargeMailUserAdapter.class);
                    if (address != null && address.getPremises() == null) {
                        address.setPremises(largeMailUser);
                        break;
                    }
                    object.getDeprecatedProperties().setLargeMailUser(largeMailUser);
                    break;
                }
                case "PostOffice": {
                    PostOffice postOffice = (PostOffice)reader.getObjectUsingBuilder(PostOfficeAdapter.class);
                    if (address != null && address.getPostOffice() == null) {
                        address.setPostOffice(postOffice);
                        break;
                    }
                    object.getDeprecatedProperties().setPostOffice(postOffice);
                    break;
                }
                case "PostalRoute": {
                    object.getDeprecatedProperties().setPostalRoute((Thoroughfare)reader.getObjectUsingBuilder(PostalRouteAdapter.class));
                    break;
                }
                case "Thoroughfare": {
                    Thoroughfare thoroughfare = (Thoroughfare)reader.getObjectUsingBuilder(ThoroughfareAdapter.class);
                    if (address != null && address.getThoroughfare() == null) {
                        address.setThoroughfare(thoroughfare);
                        break;
                    }
                    object.getDeprecatedProperties().setThoroughfare(thoroughfare);
                    break;
                }
                case "Premise": {
                    Premises premise = (Premises)reader.getObjectUsingBuilder(PremiseAdapter.class);
                    if (address != null && address.getPremises() == null) {
                        address.setPremises(premise);
                        break;
                    }
                    object.getDeprecatedProperties().setPremise(premise);
                    break;
                }
                case "DependentLocality": {
                    object.setSubLocality((SubLocality)reader.getObjectUsingBuilder(DependentLocalityAdapter.class));
                    break;
                }
                case "PostalCode": {
                    PostCode postalCode = (PostCode)reader.getObjectUsingBuilder(PostalCodeAdapter.class);
                    if (address != null && address.getPostCode() == null) {
                        address.setPostCode(postalCode);
                        break;
                    }
                    object.getDeprecatedProperties().setPostalCode(postalCode);
                }
            }
        }
    }

    @Override
    public void initializeElement(Element element, Locality object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("UsageType", object.getOtherAttributes().getValue("UsageType"));
        element.addAttribute("Indicator", object.getOtherAttributes().getValue("Indicator"));
        if (object.getType() != null) {
            element.addAttribute("Type", object.getType().toValue());
        } else {
            element.addAttribute("Type", object.getOtherAttributes().getValue("Type"));
        }
    }

    public void writeChildElements(Locality object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        DeprecatedPropertiesOfLocality properties;
        Address address = (Address)object.getParent(Address.class);
        DeprecatedPropertiesOfLocality deprecatedPropertiesOfLocality = properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        if (object.isSetNameElements()) {
            for (LocalityName nameElement : object.getNameElements()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"LocalityName"), (Object)nameElement, LocalityNameAdapter.class, namespaces);
            }
        }
        PostalDeliveryPoint postBox = null;
        if (address != null && address.getPostalDeliveryPoint() != null && address.getPostalDeliveryPoint().getType() == PostalDeliveryPointType.PO_BOX) {
            postBox = address.getPostalDeliveryPoint();
        } else if (properties != null) {
            postBox = properties.getPostBox();
        }
        PostOffice postOffice = null;
        if (address != null && address.getPostOffice() != null) {
            postOffice = address.getPostOffice();
        } else if (properties != null) {
            postOffice = properties.getPostOffice();
        }
        if (postBox != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostBox"), (Object)postBox, PostBoxAdapter.class, namespaces);
        } else if (postOffice != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostOffice"), (Object)postOffice, PostOfficeAdapter.class, namespaces);
        } else if (properties != null && properties.getLargeMailUser() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"LargeMailUser"), (Object)properties.getLargeMailUser(), LargeMailUserAdapter.class, namespaces);
        } else if (properties != null && properties.getPostalRoute() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalRoute"), (Object)properties.getPostalRoute(), PostalRouteAdapter.class, namespaces);
        }
        boolean hasDependentLocality = object.getSubLocality() != null;
        Thoroughfare thoroughfare = null;
        if (!hasDependentLocality && address != null && address.getThoroughfare() != null) {
            thoroughfare = address.getThoroughfare();
        } else if (properties != null) {
            thoroughfare = properties.getThoroughfare();
        }
        if (thoroughfare != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Thoroughfare"), (Object)thoroughfare, ThoroughfareAdapter.class, namespaces);
        }
        Premises premise = null;
        if (!hasDependentLocality && address != null && address.getThoroughfare() == null && address.getPremises() != null) {
            premise = address.getPremises();
        } else if (properties != null) {
            premise = properties.getPremise();
        }
        if (premise != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Premise"), (Object)premise, PremiseAdapter.class, namespaces);
        }
        if (hasDependentLocality) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"DependentLocality"), (Object)object.getSubLocality(), DependentLocalityAdapter.class, namespaces);
        }
        PostCode postalCode = null;
        if (address != null && address.getPostCode() != null) {
            postalCode = address.getPostCode();
        } else if (properties != null) {
            postalCode = properties.getPostalCode();
        }
        if (postalCode != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalCode"), (Object)postalCode, PostalCodeAdapter.class, namespaces);
        }
    }
}

