/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.model.Child;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostBoxAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalCodeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalRouteAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PostOfficeNameAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PostOfficeNumberAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfPostOffice;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.IdentifierElementType;
import org.xmlobjects.xal.model.types.PostalDeliveryPointType;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class PostOfficeAdapter
extends AddressObjectAdapter<PostOffice> {
    public PostOffice createObject(QName name, Object parent) throws ObjectBuildException {
        PostOffice object = new PostOffice();
        if (parent instanceof Child) {
            Child child = (Child)parent;
            object.setParent(child);
        }
        return object;
    }

    @Override
    public void initializeObject(PostOffice object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("Type").ifPresent(object::setType);
        attributes.getValue("Indicator").ifPresent(v -> object.getOtherAttributes().add("Indicator", v));
    }

    public void buildChildObject(PostOffice object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            Address address = (Address)object.getParent(Address.class);
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    if (address == null) break;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "PostOfficeName": {
                    object.getIdentifiers().add((Identifier)reader.getObjectUsingBuilder(PostOfficeNameAdapter.class));
                    break;
                }
                case "PostOfficeNumber": {
                    object.getIdentifiers().add((Identifier)reader.getObjectUsingBuilder(PostOfficeNumberAdapter.class));
                    break;
                }
                case "PostalRoute": {
                    object.getDeprecatedProperties().setPostalRoute((Thoroughfare)reader.getObjectUsingBuilder(PostalRouteAdapter.class));
                    break;
                }
                case "PostBox": {
                    PostalDeliveryPoint postBox = (PostalDeliveryPoint)reader.getObjectUsingBuilder(PostBoxAdapter.class);
                    if (address != null && address.getPostalDeliveryPoint() == null) {
                        address.setPostalDeliveryPoint(postBox);
                        break;
                    }
                    object.getDeprecatedProperties().setPostBox(postBox);
                    break;
                }
                case "PostalCode": {
                    PostCode postalCode = (PostCode)reader.getObjectUsingBuilder(PostalCodeAdapter.class);
                    if (address != null && address.getPostCode() == null) {
                        address.setPostCode(postalCode);
                        break;
                    }
                    object.getDeprecatedProperties().setPostalCode(postalCode);
                }
            }
        }
    }

    @Override
    public void initializeElement(Element element, PostOffice object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("Type", object.getType());
        element.addAttribute("Indicator", object.getOtherAttributes().getValue("Indicator"));
    }

    public void writeChildElements(PostOffice object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        DeprecatedPropertiesOfPostOffice properties;
        Address address = (Address)object.getParent(Address.class);
        Identifier number = null;
        boolean hasNames = false;
        DeprecatedPropertiesOfPostOffice deprecatedPropertiesOfPostOffice = properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        if (object.isSetIdentifiers()) {
            for (Identifier identifier : object.getIdentifiers()) {
                if (identifier.getType() != IdentifierElementType.NUMBER) {
                    writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostOfficeName"), (Object)identifier, PostOfficeNameAdapter.class, namespaces);
                    hasNames = true;
                    continue;
                }
                if (number != null || identifier.getType() != IdentifierElementType.NUMBER) continue;
                number = identifier;
            }
        }
        if (!hasNames && number != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostOfficeNumber"), number, PostOfficeNumberAdapter.class, namespaces);
        }
        if (properties != null && properties.getPostalRoute() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalRoute"), (Object)properties.getPostalRoute(), PostalRouteAdapter.class, namespaces);
        }
        PostalDeliveryPoint postBox = null;
        if (address != null && address.getLocality() == null && address.getPostalDeliveryPoint() != null && address.getPostalDeliveryPoint().getType() == PostalDeliveryPointType.PO_BOX) {
            postBox = address.getPostalDeliveryPoint();
        } else if (properties != null) {
            postBox = properties.getPostBox();
        }
        if (postBox != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostBox"), (Object)postBox, PostBoxAdapter.class, namespaces);
        }
        PostCode postalCode = null;
        if (address != null && address.getLocality() == null && address.getPostCode() != null) {
            postalCode = address.getPostCode();
        } else if (properties != null) {
            postalCode = properties.getPostalCode();
        }
        if (postalCode != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalCode"), (Object)postalCode, PostalCodeAdapter.class, namespaces);
        }
    }
}

