/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.model.Child;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.FirmAdapter;
import org.xmlobjects.xal.adapter.deprecated.MailStopAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalCodeAdapter;
import org.xmlobjects.xal.adapter.deprecated.SubPremiseAdapter;
import org.xmlobjects.xal.adapter.deprecated.helper.PremiseNamesAndNumbers;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.BuildingNameAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseLocationAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNameAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberPrefixAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberRangeAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberSuffixAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.SubPremiseNameAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.SubPremises;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfPremises;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.PostalDeliveryPointType;
import org.xmlobjects.xal.model.types.PremisesName;
import org.xmlobjects.xal.model.types.PremisesNameOrNumber;
import org.xmlobjects.xal.model.types.PremisesType;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class PremiseAdapter
extends AddressObjectAdapter<Premises> {
    public Premises createObject(QName name, Object parent) throws ObjectBuildException {
        Premises object = new Premises();
        if (parent instanceof Child) {
            Child child = (Child)parent;
            object.setParent(child);
        }
        return object;
    }

    @Override
    public void initializeObject(Premises object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("PremiseDependency").ifPresent(v -> object.getOtherAttributes().add("PremiseDependency", v));
        attributes.getValue("PremiseDependencyType").ifPresent(v -> object.getOtherAttributes().add("PremiseDependencyType", v));
        attributes.getValue("PremiseThoroughfareConnector").ifPresent(v -> object.getOtherAttributes().add("PremiseThoroughfareConnector", v));
        attributes.getValue("Type").ifPresent(v -> {
            PremisesType type = PremisesType.fromValue(v);
            if (type != null) {
                object.setType(type);
            } else {
                object.getOtherAttributes().add("Type", v);
            }
        });
    }

    public void buildChildObject(Premises object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            Address address = (Address)object.getParent(Address.class);
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    if (address == null) break;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "PremiseName": {
                    object.getNameElementOrNumber().add(new PremisesNameOrNumber((PremisesName)reader.getObjectUsingBuilder(PremiseNameAdapter.class)));
                    break;
                }
                case "PremiseLocation": {
                    object.getNameElementOrNumber().add(new PremisesNameOrNumber((PremisesName)reader.getObjectUsingBuilder(PremiseLocationAdapter.class)));
                    break;
                }
                case "PremiseNumber": {
                    object.getNameElementOrNumber().add(new PremisesNameOrNumber((Identifier)reader.getObjectUsingBuilder(PremiseNumberAdapter.class)));
                    break;
                }
                case "PremiseNumberRange": {
                    object.getNameElementOrNumber().addAll((Collection)reader.getObjectUsingBuilder(PremiseNumberRangeAdapter.class));
                    break;
                }
                case "PremiseNumberPrefix": {
                    object.getNameElementOrNumber().add(new PremisesNameOrNumber((Identifier)reader.getObjectUsingBuilder(PremiseNumberPrefixAdapter.class)));
                    break;
                }
                case "PremiseNumberSuffix": {
                    object.getNameElementOrNumber().add(new PremisesNameOrNumber((Identifier)reader.getObjectUsingBuilder(PremiseNumberSuffixAdapter.class)));
                    break;
                }
                case "BuildingName": {
                    object.getDeprecatedProperties().getBuildingNames().add((Identifier)reader.getObjectUsingBuilder(BuildingNameAdapter.class));
                    break;
                }
                case "SubPremise": {
                    SubPremises subPremise = (SubPremises)reader.getObjectUsingBuilder(SubPremiseAdapter.class);
                    object.getSubPremises().add(subPremise);
                    while ((subPremise = subPremise.getDeprecatedProperties().getSubPremise()) != null) {
                        object.getSubPremises().add(subPremise);
                    }
                    object.getSubPremises().forEach(v -> v.getDeprecatedProperties().setSubPremise(null));
                    break;
                }
                case "Firm": {
                    object.getDeprecatedProperties().setFirm((Premises)reader.getObjectUsingBuilder(FirmAdapter.class));
                    break;
                }
                case "MailStop": {
                    PostalDeliveryPoint mailStop = (PostalDeliveryPoint)reader.getObjectUsingBuilder(MailStopAdapter.class);
                    if (address != null && address.getPostalDeliveryPoint() == null) {
                        address.setPostalDeliveryPoint(mailStop);
                        break;
                    }
                    object.getDeprecatedProperties().setMailStop(mailStop);
                    break;
                }
                case "PostalCode": {
                    PostCode postalCode = (PostCode)reader.getObjectUsingBuilder(PostalCodeAdapter.class);
                    if (address != null && address.getPostCode() == null) {
                        address.setPostCode(postalCode);
                        break;
                    }
                    object.getDeprecatedProperties().setPostalCode(postalCode);
                    break;
                }
                case "Premise": {
                    object.getDeprecatedProperties().setPremise((Premises)reader.getObjectUsingBuilder(PremiseAdapter.class));
                }
            }
        }
    }

    @Override
    public void initializeElement(Element element, Premises object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("PremiseDependency", object.getOtherAttributes().getValue("PremiseDependency"));
        element.addAttribute("PremiseDependencyType", object.getOtherAttributes().getValue("PremiseDependencyType"));
        element.addAttribute("PremiseThoroughfareConnector", object.getOtherAttributes().getValue("PremiseThoroughfareConnector"));
        if (object.getType() != null) {
            element.addAttribute("Type", object.getType().toValue());
        } else {
            element.addAttribute("Type", object.getOtherAttributes().getValue("Type"));
        }
    }

    /*
     * WARNING - void declaration
     */
    public void writeChildElements(Premises object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        void var8_22;
        Address address = (Address)object.getParent(Address.class);
        PremiseNamesAndNumbers namesAndNumbers = PremiseNamesAndNumbers.of(object);
        DeprecatedPropertiesOfPremises properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        for (PremisesName premisesName : namesAndNumbers.getNames()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseName"), (Object)premisesName, SubPremiseNameAdapter.class, namespaces);
        }
        if (namesAndNumbers.getPremiseLocation() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseLocation"), (Object)namesAndNumbers.getPremiseLocation(), PremiseLocationAdapter.class, namespaces);
        } else if (!namesAndNumbers.getNumbers().isEmpty()) {
            for (Identifier identifier : namesAndNumbers.getNumbers()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumber"), (Object)identifier, PremiseNumberAdapter.class, namespaces);
            }
        } else if (namesAndNumbers.getNumberRange() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberRange"), (Object)namesAndNumbers.getNumberRange(), PremiseNumberRangeAdapter.class, namespaces);
        }
        for (Identifier identifier : namesAndNumbers.getPrefixes()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberPrefix"), (Object)identifier, PremiseNumberPrefixAdapter.class, namespaces);
        }
        for (Identifier identifier : namesAndNumbers.getSuffixes()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberSuffix"), (Object)identifier, PremiseNumberSuffixAdapter.class, namespaces);
        }
        if (properties != null && properties.isSetBuildingNames()) {
            for (Identifier identifier : properties.getBuildingNames()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"BuildingName"), (Object)identifier, BuildingNameAdapter.class, namespaces);
            }
        }
        if (object.isSetSubPremises()) {
            ObjectSerializer serializer = writer.getOrCreateSerializer(SubPremiseAdapter.class);
            for (SubPremises subPremise : object.getSubPremises()) {
                Element element = Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"SubPremise");
                serializer.initializeElement(element, (Object)subPremise, namespaces, writer);
                writer.writeStartElement(element);
                writer.writeObjectUsingSerializer((Object)subPremise, serializer, namespaces);
            }
            writer.writeEndElements(object.getSubPremises().size());
        } else if (properties != null && properties.getFirm() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Firm"), (Object)properties.getFirm(), FirmAdapter.class, namespaces);
        }
        PostalDeliveryPoint mailStop = null;
        if (address != null && address.getPostalDeliveryPoint() != null && address.getPostalDeliveryPoint().getType() == PostalDeliveryPointType.MAIL_STOP) {
            mailStop = address.getPostalDeliveryPoint();
        } else if (properties != null) {
            mailStop = properties.getMailStop();
        }
        if (mailStop != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"MailStop"), (Object)mailStop, MailStopAdapter.class, namespaces);
        }
        Object var8_19 = null;
        if (address != null && address.getLocality() == null && address.getPostCode() != null) {
            PostCode postCode = address.getPostCode();
        } else if (properties != null) {
            PostCode postCode = properties.getPostalCode();
        }
        if (var8_22 != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalCode"), (Object)var8_22, PostalCodeAdapter.class, namespaces);
        }
        if (properties != null && properties.getPremise() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Premise"), (Object)properties.getPremise(), PremiseAdapter.class, namespaces);
        }
    }
}

