/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.model.Child;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.LocalityAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostOfficeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalCodeAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.SubAdministrativeAreaNameAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.SubAdministrativeArea;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfSubAdministrativeArea;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.SubAdministrativeAreaName;
import org.xmlobjects.xal.model.types.SubAdministrativeAreaType;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class SubAdministrativeAreaAdapter
extends AddressObjectAdapter<SubAdministrativeArea> {
    public SubAdministrativeArea createObject(QName name, Object parent) throws ObjectBuildException {
        SubAdministrativeArea object = new SubAdministrativeArea();
        if (parent instanceof Child) {
            Child child = (Child)parent;
            object.setParent(child);
        }
        return object;
    }

    @Override
    public void initializeObject(SubAdministrativeArea object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("UsageType").ifPresent(v -> object.getOtherAttributes().add("UsageType", v));
        attributes.getValue("Indicator").ifPresent(v -> object.getOtherAttributes().add("Indicator", v));
        attributes.getValue("Type").ifPresent(v -> {
            SubAdministrativeAreaType type = SubAdministrativeAreaType.fromValue(v);
            if (type != null) {
                object.setType(type);
            } else {
                object.getOtherAttributes().add("Type", v);
            }
        });
    }

    public void buildChildObject(SubAdministrativeArea object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            Address address = (Address)object.getParent(Address.class);
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    if (address == null) break;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "SubAdministrativeAreaName": {
                    object.getNameElements().add((SubAdministrativeAreaName)reader.getObjectUsingBuilder(SubAdministrativeAreaNameAdapter.class));
                    break;
                }
                case "Locality": {
                    Locality locality = (Locality)reader.getObjectUsingBuilder(LocalityAdapter.class);
                    if (address != null && address.getLocality() == null) {
                        address.setLocality(locality);
                        break;
                    }
                    object.getDeprecatedProperties().setLocality(locality);
                    break;
                }
                case "PostOffice": {
                    PostOffice postOffice = (PostOffice)reader.getObjectUsingBuilder(PostOfficeAdapter.class);
                    if (address != null && address.getPostOffice() == null) {
                        address.setPostOffice(postOffice);
                        break;
                    }
                    object.getDeprecatedProperties().setPostOffice(postOffice);
                    break;
                }
                case "PostalCode": {
                    PostCode postalCode = (PostCode)reader.getObjectUsingBuilder(PostalCodeAdapter.class);
                    if (address != null && address.getPostCode() == null) {
                        address.setPostCode(postalCode);
                        break;
                    }
                    object.getDeprecatedProperties().setPostalCode(postalCode);
                }
            }
        }
    }

    @Override
    public void initializeElement(Element element, SubAdministrativeArea object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("UsageType", object.getOtherAttributes().getValue("UsageType"));
        element.addAttribute("Indicator", object.getOtherAttributes().getValue("Indicator"));
        if (object.getType() != null) {
            element.addAttribute("Type", object.getType().toValue());
        } else {
            element.addAttribute("Type", object.getOtherAttributes().getValue("Type"));
        }
    }

    public void writeChildElements(SubAdministrativeArea object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        DeprecatedPropertiesOfSubAdministrativeArea properties;
        Address address = (Address)object.getParent(Address.class);
        DeprecatedPropertiesOfSubAdministrativeArea deprecatedPropertiesOfSubAdministrativeArea = properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        if (object.isSetNameElements()) {
            for (SubAdministrativeAreaName nameElement : object.getNameElements()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"SubAdministrativeAreaName"), (Object)nameElement, SubAdministrativeAreaNameAdapter.class, namespaces);
            }
        }
        Locality locality = null;
        if (address != null && address.getLocality() != null) {
            locality = address.getLocality();
        } else if (properties != null) {
            locality = properties.getLocality();
        }
        PostOffice postOffice = null;
        if (address != null && address.getPostOffice() != null) {
            postOffice = address.getPostOffice();
        } else if (properties != null) {
            postOffice = properties.getPostOffice();
        }
        PostCode postalCode = null;
        if (address != null && address.getPostCode() != null) {
            postalCode = address.getPostCode();
        } else if (properties != null) {
            postalCode = properties.getPostalCode();
        }
        if (locality != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Locality"), (Object)locality, LocalityAdapter.class, namespaces);
        } else if (postOffice != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostOffice"), (Object)postOffice, PostOfficeAdapter.class, namespaces);
        } else if (postalCode != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalCode"), (Object)postalCode, PostalCodeAdapter.class, namespaces);
        }
    }
}

