/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated;

import java.util.Collection;
import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.model.Child;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.AddressObjectAdapter;
import org.xmlobjects.xal.adapter.deprecated.DependentLocalityAdapter;
import org.xmlobjects.xal.adapter.deprecated.DependentThoroughfareAdapter;
import org.xmlobjects.xal.adapter.deprecated.FirmAdapter;
import org.xmlobjects.xal.adapter.deprecated.PostalCodeAdapter;
import org.xmlobjects.xal.adapter.deprecated.PremiseAdapter;
import org.xmlobjects.xal.adapter.deprecated.helper.NumberRange;
import org.xmlobjects.xal.adapter.deprecated.helper.ThoroughfareNamesAndNumbers;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNameAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberPrefixAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberRangeAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberSuffixAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfarePostDirectionAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfarePreDirectionAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.SubLocality;
import org.xmlobjects.xal.model.SubThoroughfare;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfThoroughfare;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.ThoroughfareName;
import org.xmlobjects.xal.model.types.ThoroughfareNameOrNumber;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class ThoroughfareAdapter
extends AddressObjectAdapter<Thoroughfare> {
    public Thoroughfare createObject(QName name, Object parent) throws ObjectBuildException {
        Thoroughfare object = new Thoroughfare();
        if (parent instanceof Child) {
            Child child = (Child)parent;
            object.setParent(child);
        }
        return object;
    }

    @Override
    public void initializeObject(Thoroughfare object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        super.initializeObject(object, name, attributes, reader);
        attributes.getValue("Type").ifPresent(object::setType);
        attributes.getValue("DependentThoroughfares").ifPresent(v -> object.getOtherAttributes().add("DependentThoroughfares", v));
        attributes.getValue("DependentThoroughfaresIndicator").ifPresent(v -> object.getOtherAttributes().add("DependentThoroughfaresIndicator", v));
        attributes.getValue("DependentThoroughfaresConnector").ifPresent(v -> object.getOtherAttributes().add("DependentThoroughfaresConnector", v));
        attributes.getValue("DependentThoroughfaresType").ifPresent(v -> object.getOtherAttributes().add("DependentThoroughfaresType", v));
    }

    public void buildChildObject(Thoroughfare object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            Address address = (Address)object.getParent(Address.class);
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    if (address == null) break;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "ThoroughfareNumber": {
                    object.getNameElementOrNumber().add(new ThoroughfareNameOrNumber((Identifier)reader.getObjectUsingBuilder(ThoroughfareNumberAdapter.class)));
                    break;
                }
                case "ThoroughfareNumberRange": {
                    object.getNameElementOrNumber().addAll((Collection)reader.getObjectUsingBuilder(ThoroughfareNumberRangeAdapter.class));
                    break;
                }
                case "ThoroughfareNumberPrefix": {
                    object.getNameElementOrNumber().add(new ThoroughfareNameOrNumber((Identifier)reader.getObjectUsingBuilder(ThoroughfareNumberPrefixAdapter.class)));
                    break;
                }
                case "ThoroughfareNumberSuffix": {
                    object.getNameElementOrNumber().add(new ThoroughfareNameOrNumber((Identifier)reader.getObjectUsingBuilder(ThoroughfareNumberSuffixAdapter.class)));
                    break;
                }
                case "ThoroughfarePreDirection": {
                    object.getNameElementOrNumber().add(new ThoroughfareNameOrNumber((ThoroughfareName)reader.getObjectUsingBuilder(ThoroughfarePreDirectionAdapter.class)));
                    break;
                }
                case "ThoroughfarePostDirection": {
                    object.getNameElementOrNumber().add(new ThoroughfareNameOrNumber((ThoroughfareName)reader.getObjectUsingBuilder(ThoroughfarePostDirectionAdapter.class)));
                    break;
                }
                case "ThoroughfareLeadingType": 
                case "ThoroughfareTrailingType": 
                case "ThoroughfareName": {
                    object.getNameElementOrNumber().add(new ThoroughfareNameOrNumber((ThoroughfareName)reader.getObjectUsingBuilder(ThoroughfareNameAdapter.class)));
                    break;
                }
                case "DependentThoroughfare": {
                    object.getSubThoroughfares().add((SubThoroughfare)reader.getObjectUsingBuilder(DependentThoroughfareAdapter.class));
                    break;
                }
                case "DependentLocality": {
                    object.getDeprecatedProperties().setDependentLocality((SubLocality)reader.getObjectUsingBuilder(DependentLocalityAdapter.class));
                    break;
                }
                case "Premise": {
                    Premises premise = (Premises)reader.getObjectUsingBuilder(PremiseAdapter.class);
                    if (address != null && address.getPremises() == null) {
                        address.setPremises(premise);
                        break;
                    }
                    object.getDeprecatedProperties().setPremise(premise);
                    break;
                }
                case "Firm": {
                    object.getDeprecatedProperties().setFirm((Premises)reader.getObjectUsingBuilder(FirmAdapter.class));
                    break;
                }
                case "PostalCode": {
                    PostCode postalCode = (PostCode)reader.getObjectUsingBuilder(PostalCodeAdapter.class);
                    if (address != null && address.getPostCode() == null) {
                        address.setPostCode(postalCode);
                        break;
                    }
                    object.getDeprecatedProperties().setPostalCode(postalCode);
                }
            }
        }
    }

    @Override
    public void initializeElement(Element element, Thoroughfare object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        super.initializeElement(element, object, namespaces, writer);
        element.addAttribute("Type", object.getType());
        element.addAttribute("DependentThoroughfares", object.getOtherAttributes().getValue("DependentThoroughfares"));
        element.addAttribute("DependentThoroughfaresIndicator", object.getOtherAttributes().getValue("DependentThoroughfaresIndicator"));
        element.addAttribute("DependentThoroughfaresConnector", object.getOtherAttributes().getValue("DependentThoroughfaresConnector"));
        element.addAttribute("DependentThoroughfaresType", object.getOtherAttributes().getValue("DependentThoroughfaresType"));
    }

    public void writeChildElements(Thoroughfare object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        Address address = (Address)object.getParent(Address.class);
        ThoroughfareNamesAndNumbers namesAndNumbers = ThoroughfareNamesAndNumbers.of(object);
        DeprecatedPropertiesOfThoroughfare properties = object.hasDeprecatedProperties() ? object.getDeprecatedProperties() : null;
        for (Object number : namesAndNumbers.getNumbers()) {
            if (number instanceof Identifier) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumber"), (Object)((Identifier)number), ThoroughfareNumberAdapter.class, namespaces);
                continue;
            }
            if (!(number instanceof NumberRange)) continue;
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberRange"), (Object)((NumberRange)number), ThoroughfareNumberRangeAdapter.class, namespaces);
        }
        for (Identifier prefix : namesAndNumbers.getPrefixes()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberPrefix"), (Object)prefix, ThoroughfareNumberPrefixAdapter.class, namespaces);
        }
        for (Identifier suffix : namesAndNumbers.getSuffixes()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberSuffix"), (Object)suffix, ThoroughfareNumberSuffixAdapter.class, namespaces);
        }
        if (namesAndNumbers.getPreDirection() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfarePreDirection"), (Object)namesAndNumbers.getPreDirection(), ThoroughfarePreDirectionAdapter.class, namespaces);
        }
        for (ThoroughfareName name : namesAndNumbers.getNames()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareName"), (Object)name, ThoroughfareNameAdapter.class, namespaces);
        }
        if (namesAndNumbers.getPostDirection() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfarePostDirection"), (Object)namesAndNumbers.getPostDirection(), ThoroughfarePostDirectionAdapter.class, namespaces);
        }
        if (object.isSetSubThoroughfares()) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"DependentThoroughfare"), (Object)object.getSubThoroughfares().get(0), DependentThoroughfareAdapter.class, namespaces);
        }
        Premises premise = null;
        if (address != null && address.getPremises() != null) {
            premise = address.getPremises();
        } else if (properties != null) {
            premise = properties.getPremise();
        }
        PostCode postalCode = null;
        if (address != null && address.getLocality() == null && address.getPostCode() != null) {
            postalCode = address.getPostCode();
        } else if (properties != null) {
            postalCode = properties.getPostalCode();
        }
        if (properties != null && properties.getDependentLocality() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"DependentLocality"), (Object)properties.getDependentLocality(), DependentLocalityAdapter.class, namespaces);
        } else if (premise != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Premise"), (Object)premise, PremiseAdapter.class, namespaces);
        } else if (properties != null && properties.getFirm() != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"Firm"), (Object)properties.getFirm(), FirmAdapter.class, namespaces);
        } else if (postalCode != null) {
            writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PostalCode"), (Object)postalCode, PostalCodeAdapter.class, namespaces);
        }
    }
}

