/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlobjects.xal.adapter.deprecated.helper.NumberRange;
import org.xmlobjects.xal.adapter.deprecated.helper.ParsedNumber;
import org.xmlobjects.xal.model.AbstractPremises;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.IdentifierElementType;
import org.xmlobjects.xal.model.types.PremisesName;
import org.xmlobjects.xal.model.types.PremisesNameOrNumber;
import org.xmlobjects.xal.model.types.PremisesNameType;

public class PremiseNamesAndNumbers {
    private PremisesName premiseLocation;
    private List<PremisesName> names;
    private List<Identifier> numbers;
    private NumberRange numberRange;
    private List<Identifier> prefixes;
    private List<Identifier> suffixes;
    private boolean isRange;

    public static PremiseNamesAndNumbers of(AbstractPremises premise) {
        PremiseNamesAndNumbers result = new PremiseNamesAndNumbers();
        if (premise.isSetNameElementOrNumber()) {
            ParsedNumber number = new ParsedNumber();
            for (PremisesNameOrNumber nameElementOrNumber : premise.getNameElementOrNumber()) {
                if (nameElementOrNumber.isSetNameElement()) {
                    PremisesName nameElement = nameElementOrNumber.getNameElement();
                    result.addName(nameElement);
                    continue;
                }
                if (!nameElementOrNumber.isSetNumber()) continue;
                Identifier identifier = nameElementOrNumber.getNumber();
                if (!number.accepts(identifier)) {
                    result.addNumber(number);
                    number = new ParsedNumber();
                }
                number.add(identifier);
            }
            result.addNumber(number);
        }
        return result;
    }

    private void addName(PremisesName name) {
        if (name.getNameType() != PremisesNameType.LOCATION) {
            if (this.names == null) {
                this.names = new ArrayList<PremisesName>();
            }
            this.names.add(name);
        } else if (this.premiseLocation == null) {
            this.premiseLocation = name;
        }
    }

    private void addNumber(ParsedNumber number) {
        if (number.getType() == IdentifierElementType.RANGE_FROM) {
            if (this.numbers == null) {
                this.numbers = new ArrayList<Identifier>();
            }
            this.numberRange = new NumberRange(number);
            this.isRange = true;
            return;
        }
        if (this.isRange) {
            if (number.getType() == IdentifierElementType.RANGE_TO) {
                this.numberRange.setRangeTo(number);
                this.isRange = false;
                return;
            }
            if (number.getType() == IdentifierElementType.SEPARATOR) {
                this.numberRange.setSeparator(number.getNumbers().get(0));
                this.addPrefixes(number.getPrefixes());
                this.addSuffixes(number.getSuffixes());
                return;
            }
            this.isRange = false;
        }
        this.addNumbers(number.getNumbers());
        this.addPrefixes(number.getPrefixes());
        this.addSuffixes(number.getSuffixes());
    }

    public PremisesName getPremiseLocation() {
        return this.premiseLocation;
    }

    public List<PremisesName> getNames() {
        return this.names != null ? this.names : Collections.emptyList();
    }

    public List<Identifier> getNumbers() {
        return this.numbers != null ? this.numbers : Collections.emptyList();
    }

    public NumberRange getNumberRange() {
        return this.numberRange;
    }

    private void addNumbers(List<Identifier> numbers) {
        if (!numbers.isEmpty()) {
            if (this.numbers == null) {
                this.numbers = new ArrayList<Identifier>();
            }
            this.numbers.addAll(numbers);
        }
    }

    public List<Identifier> getPrefixes() {
        return this.prefixes != null ? this.prefixes : Collections.emptyList();
    }

    private void addPrefixes(List<Identifier> prefixes) {
        if (!prefixes.isEmpty()) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<Identifier>();
            }
            this.prefixes.addAll(prefixes);
        }
    }

    public List<Identifier> getSuffixes() {
        return this.suffixes != null ? this.suffixes : Collections.emptyList();
    }

    private void addSuffixes(List<Identifier> suffixes) {
        if (!suffixes.isEmpty()) {
            if (this.suffixes == null) {
                this.suffixes = new ArrayList<Identifier>();
            }
            this.suffixes.addAll(suffixes);
        }
    }
}

