/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated.helper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.xmlobjects.xal.adapter.deprecated.helper.NumberRange;
import org.xmlobjects.xal.adapter.deprecated.helper.ParsedNumber;
import org.xmlobjects.xal.model.AbstractThoroughfare;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.IdentifierElementType;
import org.xmlobjects.xal.model.types.ThoroughfareName;
import org.xmlobjects.xal.model.types.ThoroughfareNameOrNumber;
import org.xmlobjects.xal.model.types.ThoroughfareNameType;

public class ThoroughfareNamesAndNumbers {
    private ThoroughfareName preDirection;
    private List<ThoroughfareName> names;
    private ThoroughfareName postDirection;
    private List<Object> numbers;
    private List<Identifier> prefixes;
    private List<Identifier> suffixes;
    private NumberRange numberRange;

    public static ThoroughfareNamesAndNumbers of(AbstractThoroughfare thoroughfare) {
        ThoroughfareNamesAndNumbers result = new ThoroughfareNamesAndNumbers();
        if (thoroughfare.isSetNameElementOrNumber()) {
            ParsedNumber number = new ParsedNumber();
            for (ThoroughfareNameOrNumber nameElementOrNumber : thoroughfare.getNameElementOrNumber()) {
                if (nameElementOrNumber.isSetNameElement()) {
                    ThoroughfareName nameElement = nameElementOrNumber.getNameElement();
                    result.addName(nameElement);
                    continue;
                }
                if (!nameElementOrNumber.isSetNumber()) continue;
                Identifier identifier = nameElementOrNumber.getNumber();
                if (!number.accepts(identifier)) {
                    result.addNumber(number);
                    number = new ParsedNumber();
                }
                number.add(identifier);
            }
            result.addNumber(number);
        }
        return result;
    }

    private void addName(ThoroughfareName nameElement) {
        if (nameElement.getNameType() == ThoroughfareNameType.PRE_DIRECTION && this.preDirection == null) {
            this.preDirection = nameElement;
        } else if (nameElement.getNameType() == ThoroughfareNameType.POST_DIRECTION && this.postDirection == null) {
            this.postDirection = nameElement;
        } else {
            if (this.names == null) {
                this.names = new ArrayList<ThoroughfareName>();
            }
            this.names.add(nameElement);
        }
    }

    private void addNumber(ParsedNumber number) {
        if (number.getType() == IdentifierElementType.RANGE_FROM) {
            if (this.numbers == null) {
                this.numbers = new ArrayList<Object>();
            }
            this.numberRange = new NumberRange(number);
            this.numbers.add(this.numberRange);
            return;
        }
        if (this.numberRange != null) {
            if (number.getType() == IdentifierElementType.RANGE_TO) {
                this.numberRange.setRangeTo(number);
                this.numberRange = null;
                return;
            }
            if (number.getType() == IdentifierElementType.SEPARATOR) {
                this.numberRange.setSeparator(number.getNumbers().get(0));
                this.addPrefixes(number.getPrefixes());
                this.addSuffixes(number.getSuffixes());
                return;
            }
            this.numberRange = null;
        }
        this.addNumbers(number.getNumbers());
        this.addPrefixes(number.getPrefixes());
        this.addSuffixes(number.getSuffixes());
    }

    public ThoroughfareName getPreDirection() {
        return this.preDirection;
    }

    public List<ThoroughfareName> getNames() {
        return this.names != null ? this.names : Collections.emptyList();
    }

    public ThoroughfareName getPostDirection() {
        return this.postDirection;
    }

    public List<Object> getNumbers() {
        return this.numbers != null ? this.numbers : Collections.emptyList();
    }

    private void addNumbers(List<Identifier> numbers) {
        if (!numbers.isEmpty()) {
            if (this.numbers == null) {
                this.numbers = new ArrayList<Object>();
            }
            this.numbers.addAll(numbers);
        }
    }

    public List<Identifier> getPrefixes() {
        return this.prefixes != null ? this.prefixes : Collections.emptyList();
    }

    private void addPrefixes(List<Identifier> prefixes) {
        if (!prefixes.isEmpty()) {
            if (this.prefixes == null) {
                this.prefixes = new ArrayList<Identifier>();
            }
            this.prefixes.addAll(prefixes);
        }
    }

    public List<Identifier> getSuffixes() {
        return this.suffixes != null ? this.suffixes : Collections.emptyList();
    }

    private void addSuffixes(List<Identifier> suffixes) {
        if (!suffixes.isEmpty()) {
            if (this.suffixes == null) {
                this.suffixes = new ArrayList<Identifier>();
            }
            this.suffixes.addAll(suffixes);
        }
    }
}

