/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated.types;

import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.deprecated.helper.NumberRange;
import org.xmlobjects.xal.adapter.deprecated.helper.ParsedNumber;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberPrefixAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.PremiseNumberSuffixAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.IdentifierElementType;
import org.xmlobjects.xal.model.types.PremisesNameOrNumber;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class PremiseNumberRangeAdapter
implements ObjectBuilder<ChildList<PremisesNameOrNumber>>,
ObjectSerializer<NumberRange> {
    public ChildList<PremisesNameOrNumber> createObject(QName name, Object parent) throws ObjectBuildException {
        Child child;
        return new ChildList(parent instanceof Child ? (child = (Child)parent) : null);
    }

    public void initializeObject(ChildList<PremisesNameOrNumber> object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        attributes.getValue("Separator").ifPresent(v -> object.add((Child)new PremisesNameOrNumber(new Identifier((String)v, IdentifierElementType.SEPARATOR))));
    }

    public void buildChildObject(ChildList<PremisesNameOrNumber> object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "PremiseNumberRangeFrom": {
                    this.buildNumber(object, IdentifierElementType.RANGE_FROM, reader);
                    break;
                }
                case "PremiseNumberRangeTo": {
                    this.buildNumber(object, IdentifierElementType.RANGE_TO, reader);
                }
            }
        }
    }

    private void buildNumber(ChildList<PremisesNameOrNumber> object, IdentifierElementType type, XMLReader reader) throws ObjectBuildException, XMLReadException {
        int depth = reader.getDepth();
        block12: while (reader.hasNext() && reader.getDepth() >= depth && reader.nextTag() == EventType.START_ELEMENT) {
            QName name = reader.getName();
            if (!"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) continue;
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    Child parent = object.getParent();
                    if (parent == null) break;
                    Address address = (Address)parent.getParent(Address.class);
                    if (address == null) continue block12;
                    if (address.getFreeTextAddress() == null) {
                        address.setFreeTextAddress(new FreeTextAddress());
                    }
                    address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
                    break;
                }
                case "PremiseNumberPrefix": {
                    object.add((Child)new PremisesNameOrNumber((Identifier)reader.getObjectUsingBuilder(PremiseNumberPrefixAdapter.class)));
                    break;
                }
                case "PremiseNumber": {
                    Identifier number = (Identifier)reader.getObjectUsingBuilder(PremiseNumberAdapter.class);
                    number.setType(type);
                    object.add((Child)new PremisesNameOrNumber(number));
                    break;
                }
                case "PremiseNumberSuffix": {
                    object.add((Child)new PremisesNameOrNumber((Identifier)reader.getObjectUsingBuilder(PremiseNumberSuffixAdapter.class)));
                }
            }
        }
    }

    public void initializeElement(Element element, NumberRange object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        if (object.getSeparator() != null) {
            element.addAttribute("Separator", object.getSeparator().getContent());
        }
    }

    public void writeChildElements(NumberRange object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        this.writeRangeNumber(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberRangeFrom"), object.getRangeFrom(), namespaces, writer);
        this.writeRangeNumber(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberRangeTo"), object.getRangeTo(), namespaces, writer);
    }

    private void writeRangeNumber(Element element, ParsedNumber rangeNumber, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        writer.writeStartElement(element);
        if (rangeNumber != null) {
            for (Identifier prefix : rangeNumber.getPrefixes()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberPrefix"), (Object)prefix, PremiseNumberPrefixAdapter.class, namespaces);
            }
            for (Identifier number : rangeNumber.getNumbers()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumber"), (Object)number, PremiseNumberAdapter.class, namespaces);
            }
            for (Identifier suffix : rangeNumber.getSuffixes()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"PremiseNumberSuffix"), (Object)suffix, PremiseNumberSuffixAdapter.class, namespaces);
            }
        }
        writer.writeEndElement();
    }
}

