/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.adapter.deprecated.types;

import javax.xml.namespace.QName;
import org.xmlobjects.builder.ObjectBuildException;
import org.xmlobjects.builder.ObjectBuilder;
import org.xmlobjects.model.Child;
import org.xmlobjects.model.ChildList;
import org.xmlobjects.serializer.ObjectSerializeException;
import org.xmlobjects.serializer.ObjectSerializer;
import org.xmlobjects.stream.EventType;
import org.xmlobjects.stream.XMLReadException;
import org.xmlobjects.stream.XMLReader;
import org.xmlobjects.stream.XMLWriteException;
import org.xmlobjects.stream.XMLWriter;
import org.xmlobjects.xal.adapter.deprecated.helper.NumberRange;
import org.xmlobjects.xal.adapter.deprecated.helper.ParsedNumber;
import org.xmlobjects.xal.adapter.deprecated.types.AddressLineAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberPrefixAdapter;
import org.xmlobjects.xal.adapter.deprecated.types.ThoroughfareNumberSuffixAdapter;
import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.types.AddressLine;
import org.xmlobjects.xal.model.types.Identifier;
import org.xmlobjects.xal.model.types.IdentifierElementType;
import org.xmlobjects.xal.model.types.ThoroughfareNameOrNumber;
import org.xmlobjects.xml.Attributes;
import org.xmlobjects.xml.Element;
import org.xmlobjects.xml.Namespaces;

public class ThoroughfareNumberRangeAdapter
implements ObjectBuilder<ChildList<ThoroughfareNameOrNumber>>,
ObjectSerializer<NumberRange> {
    private Identifier separator;

    public ChildList<ThoroughfareNameOrNumber> createObject(QName name, Object parent) throws ObjectBuildException {
        Child child;
        ChildList object = new ChildList(parent instanceof Child ? (child = (Child)parent) : null);
        this.separator = null;
        return object;
    }

    public void initializeObject(ChildList<ThoroughfareNameOrNumber> object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        attributes.getValue("Separator").ifPresent(v -> {
            this.separator = new Identifier((String)v, IdentifierElementType.SEPARATOR);
        });
    }

    public void buildChildObject(ChildList<ThoroughfareNameOrNumber> object, QName name, Attributes attributes, XMLReader reader) throws ObjectBuildException, XMLReadException {
        if ("urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) {
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    this.buildAddressLine(object, reader);
                    break;
                }
                case "ThoroughfareNumberFrom": {
                    this.buildNumber(object, IdentifierElementType.RANGE_FROM, reader);
                    break;
                }
                case "ThoroughfareNumberTo": {
                    if (this.separator != null) {
                        object.add((Child)new ThoroughfareNameOrNumber(this.separator));
                        this.separator = null;
                    }
                    this.buildNumber(object, IdentifierElementType.RANGE_TO, reader);
                }
            }
        }
    }

    private void buildNumber(ChildList<ThoroughfareNameOrNumber> object, IdentifierElementType type, XMLReader reader) throws ObjectBuildException, XMLReadException {
        int depth = reader.getDepth();
        while (reader.hasNext() && reader.getDepth() >= depth && reader.nextTag() == EventType.START_ELEMENT) {
            QName name = reader.getName();
            if (!"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0".equals(name.getNamespaceURI())) continue;
            switch (name.getLocalPart()) {
                case "AddressLine": {
                    this.buildAddressLine(object, reader);
                    break;
                }
                case "ThoroughfareNumberPrefix": {
                    object.add((Child)new ThoroughfareNameOrNumber((Identifier)reader.getObjectUsingBuilder(ThoroughfareNumberPrefixAdapter.class)));
                    break;
                }
                case "ThoroughfareNumber": {
                    Identifier number = (Identifier)reader.getObjectUsingBuilder(ThoroughfareNumberAdapter.class);
                    number.setType(type);
                    object.add((Child)new ThoroughfareNameOrNumber(number));
                    break;
                }
                case "ThoroughfareNumberSuffix": {
                    object.add((Child)new ThoroughfareNameOrNumber((Identifier)reader.getObjectUsingBuilder(ThoroughfareNumberSuffixAdapter.class)));
                }
            }
        }
    }

    private void buildAddressLine(ChildList<ThoroughfareNameOrNumber> object, XMLReader reader) throws ObjectBuildException, XMLReadException {
        Address address;
        Child parent = object.getParent();
        if (parent != null && (address = (Address)parent.getParent(Address.class)) != null) {
            if (address.getFreeTextAddress() == null) {
                address.setFreeTextAddress(new FreeTextAddress());
            }
            address.getFreeTextAddress().getAddressLines().add((AddressLine)reader.getObjectUsingBuilder(AddressLineAdapter.class));
        }
    }

    public void initializeElement(Element element, NumberRange object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        if (object.getSeparator() != null) {
            element.addAttribute("Separator", object.getSeparator().getContent());
        }
    }

    public void writeChildElements(NumberRange object, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        this.writeRangeNumber(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberFrom"), object.getRangeFrom(), namespaces, writer);
        this.writeRangeNumber(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberTo"), object.getRangeTo(), namespaces, writer);
    }

    private void writeRangeNumber(Element element, ParsedNumber rangeNumber, Namespaces namespaces, XMLWriter writer) throws ObjectSerializeException, XMLWriteException {
        writer.writeStartElement(element);
        if (rangeNumber != null) {
            for (Identifier prefix : rangeNumber.getPrefixes()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberPrefix"), (Object)prefix, ThoroughfareNumberPrefixAdapter.class, namespaces);
            }
            for (Identifier number : rangeNumber.getNumbers()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumber"), (Object)number, ThoroughfareNumberAdapter.class, namespaces);
            }
            for (Identifier suffix : rangeNumber.getSuffixes()) {
                writer.writeElementUsingSerializer(Element.of((String)"urn:oasis:names:tc:ciq:xsdschema:xAL:2.0", (String)"ThoroughfareNumberSuffix"), (Object)suffix, ThoroughfareNumberSuffixAdapter.class, namespaces);
            }
        }
        writer.writeEndElement();
    }
}

