/*
 * Decompiled with CFR 0.152.
 */
package org.xmlobjects.xal.visitor;

import org.xmlobjects.xal.model.Address;
import org.xmlobjects.xal.model.AddressObject;
import org.xmlobjects.xal.model.AdministrativeArea;
import org.xmlobjects.xal.model.Country;
import org.xmlobjects.xal.model.FreeTextAddress;
import org.xmlobjects.xal.model.GeoRSS;
import org.xmlobjects.xal.model.Locality;
import org.xmlobjects.xal.model.LocationByCoordinates;
import org.xmlobjects.xal.model.PostCode;
import org.xmlobjects.xal.model.PostOffice;
import org.xmlobjects.xal.model.PostalDeliveryPoint;
import org.xmlobjects.xal.model.PostalServiceElements;
import org.xmlobjects.xal.model.Premises;
import org.xmlobjects.xal.model.RuralDelivery;
import org.xmlobjects.xal.model.SubAdministrativeArea;
import org.xmlobjects.xal.model.SubLocality;
import org.xmlobjects.xal.model.SubPremises;
import org.xmlobjects.xal.model.SubThoroughfare;
import org.xmlobjects.xal.model.Thoroughfare;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfAddress;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfAdministrativeArea;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfCountry;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfLocality;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfPostCode;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfPostOffice;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfPostalDeliveryPoint;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfPremises;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfSubAdministrativeArea;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfSubLocality;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfSubPremises;
import org.xmlobjects.xal.model.deprecated.DeprecatedPropertiesOfThoroughfare;
import org.xmlobjects.xal.visitor.XALVisitor;

public abstract class XALWalker
implements XALVisitor {
    private boolean shouldWalk = true;

    public boolean shouldWalk() {
        return this.shouldWalk;
    }

    public void setShouldWalk(boolean shouldWalk) {
        this.shouldWalk = shouldWalk;
    }

    public void reset() {
        this.shouldWalk = true;
    }

    public void visit(AddressObject addressObject) {
    }

    @Override
    public void visit(Address address) {
        this.visit((AddressObject)address);
        if (this.shouldWalk && address.getFreeTextAddress() != null) {
            address.getFreeTextAddress().accept(this);
        }
        if (this.shouldWalk && address.getCountry() != null) {
            address.getCountry().accept(this);
        }
        if (this.shouldWalk && address.getAdministrativeArea() != null) {
            address.getAdministrativeArea().accept(this);
        }
        if (this.shouldWalk && address.getLocality() != null) {
            address.getLocality().accept(this);
        }
        if (this.shouldWalk && address.getThoroughfare() != null) {
            address.getThoroughfare().accept(this);
        }
        if (this.shouldWalk && address.getPremises() != null) {
            address.getPremises().accept(this);
        }
        if (this.shouldWalk && address.getPostCode() != null) {
            address.getPostCode().accept(this);
        }
        if (this.shouldWalk && address.getRuralDelivery() != null) {
            address.getRuralDelivery().accept(this);
        }
        if (this.shouldWalk && address.getPostalDeliveryPoint() != null) {
            address.getPostalDeliveryPoint().accept(this);
        }
        if (this.shouldWalk && address.getPostOffice() != null) {
            address.getPostOffice().accept(this);
        }
        if (this.shouldWalk && address.getGeoRSS() != null) {
            address.getGeoRSS().accept(this);
        }
        if (this.shouldWalk && address.getLocationByCoordinates() != null) {
            address.getLocationByCoordinates().accept(this);
        }
        if (address.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfAddress deprecatedProperties = address.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getPostalServiceElements() != null) {
                deprecatedProperties.getPostalServiceElements().accept(this);
            }
        }
    }

    @Override
    public void visit(AdministrativeArea administrativeArea) {
        this.visit((AddressObject)administrativeArea);
        if (this.shouldWalk && administrativeArea.getSubAdministrativeArea() != null) {
            administrativeArea.getSubAdministrativeArea().accept(this);
        }
        if (administrativeArea.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfAdministrativeArea deprecatedProperties = administrativeArea.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getLocality() != null) {
                deprecatedProperties.getLocality().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostOffice() != null) {
                deprecatedProperties.getPostOffice().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }

    @Override
    public void visit(Country country) {
        this.visit((AddressObject)country);
        if (country.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfCountry deprecatedProperties = country.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getAdministrativeArea() != null) {
                deprecatedProperties.getAdministrativeArea().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getLocality() != null) {
                deprecatedProperties.getLocality().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getThoroughfare() != null) {
                deprecatedProperties.getThoroughfare().accept(this);
            }
        }
    }

    @Override
    public void visit(FreeTextAddress freeTextAddress) {
        this.visit((AddressObject)freeTextAddress);
    }

    @Override
    public void visit(GeoRSS geoRSS) {
        this.visit((AddressObject)geoRSS);
    }

    @Override
    public void visit(Locality locality) {
        this.visit((AddressObject)locality);
        if (this.shouldWalk && locality.getSubLocality() != null) {
            locality.getSubLocality().accept(this);
        }
        if (locality.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfLocality deprecatedProperties = locality.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getLargeMailUser() != null) {
                deprecatedProperties.getLargeMailUser().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalRoute() != null) {
                deprecatedProperties.getPostalRoute().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostBox() != null) {
                deprecatedProperties.getPostBox().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostOffice() != null) {
                deprecatedProperties.getPostOffice().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getThoroughfare() != null) {
                deprecatedProperties.getThoroughfare().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPremise() != null) {
                deprecatedProperties.getPremise().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }

    @Override
    public void visit(LocationByCoordinates locationByCoordinates) {
        this.visit((AddressObject)locationByCoordinates);
    }

    @Override
    public void visit(PostalDeliveryPoint postalDeliveryPoint) {
        this.visit((AddressObject)postalDeliveryPoint);
        if (postalDeliveryPoint.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfPostalDeliveryPoint deprecatedProperties = postalDeliveryPoint.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getFirm() != null) {
                deprecatedProperties.getFirm().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }

    @Override
    public void visit(PostalServiceElements postalServiceElements) {
        this.visit((AddressObject)postalServiceElements);
    }

    @Override
    public void visit(PostCode postCode) {
        this.visit((AddressObject)postCode);
        if (postCode.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfPostCode deprecatedProperties = postCode.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getPostTown() != null) {
                deprecatedProperties.getPostTown().accept(this);
            }
        }
    }

    @Override
    public void visit(PostOffice postOffice) {
        this.visit((AddressObject)postOffice);
        if (postOffice.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfPostOffice deprecatedProperties = postOffice.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getPostalRoute() != null) {
                deprecatedProperties.getPostalRoute().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostBox() != null) {
                deprecatedProperties.getPostBox().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }

    @Override
    public void visit(Premises premises) {
        this.visit((AddressObject)premises);
        if (premises.isSetSubPremises()) {
            for (SubPremises subPremises : premises.getSubPremises()) {
                if (!this.shouldWalk) continue;
                subPremises.accept(this);
            }
        }
        if (premises.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfPremises deprecatedProperties = premises.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getPostBox() != null) {
                deprecatedProperties.getPostBox().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getThoroughfare() != null) {
                deprecatedProperties.getThoroughfare().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getMailStop() != null) {
                deprecatedProperties.getMailStop().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getFirm() != null) {
                deprecatedProperties.getFirm().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPremise() != null) {
                deprecatedProperties.getPremise().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getDepartment() != null) {
                deprecatedProperties.getDepartment().accept(this);
            }
        }
    }

    @Override
    public void visit(RuralDelivery ruralDelivery) {
        this.visit((AddressObject)ruralDelivery);
    }

    @Override
    public void visit(SubAdministrativeArea subAdministrativeArea) {
        this.visit((AddressObject)subAdministrativeArea);
        if (subAdministrativeArea.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfSubAdministrativeArea deprecatedProperties = subAdministrativeArea.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getLocality() != null) {
                deprecatedProperties.getLocality().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostOffice() != null) {
                deprecatedProperties.getPostOffice().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }

    @Override
    public void visit(SubLocality subLocality) {
        this.visit((AddressObject)subLocality);
        if (subLocality.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfSubLocality deprecatedProperties = subLocality.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getPostBox() != null) {
                deprecatedProperties.getPostBox().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getLargeMailUser() != null) {
                deprecatedProperties.getLargeMailUser().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostOffice() != null) {
                deprecatedProperties.getPostOffice().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalRoute() != null) {
                deprecatedProperties.getPostalRoute().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getThoroughfare() != null) {
                deprecatedProperties.getThoroughfare().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPremise() != null) {
                deprecatedProperties.getPremise().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getDependentLocality() != null) {
                deprecatedProperties.getDependentLocality().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }

    @Override
    public void visit(SubPremises subPremises) {
        this.visit((AddressObject)subPremises);
        if (subPremises.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfSubPremises deprecatedProperties = subPremises.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getMailStop() != null) {
                deprecatedProperties.getMailStop().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getFirm() != null) {
                deprecatedProperties.getFirm().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getSubPremise() != null) {
                deprecatedProperties.getSubPremise().accept(this);
            }
        }
    }

    @Override
    public void visit(SubThoroughfare subThoroughfare) {
        this.visit((AddressObject)subThoroughfare);
    }

    @Override
    public void visit(Thoroughfare thoroughfare) {
        this.visit((AddressObject)thoroughfare);
        if (thoroughfare.isSetSubThoroughfares()) {
            for (SubThoroughfare subThoroughfare : thoroughfare.getSubThoroughfares()) {
                if (!this.shouldWalk) continue;
                subThoroughfare.accept(this);
            }
        }
        if (thoroughfare.hasDeprecatedProperties()) {
            DeprecatedPropertiesOfThoroughfare deprecatedProperties = thoroughfare.getDeprecatedProperties();
            if (this.shouldWalk && deprecatedProperties.getDependentLocality() != null) {
                deprecatedProperties.getDependentLocality().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostBox() != null) {
                deprecatedProperties.getPostBox().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPremise() != null) {
                deprecatedProperties.getPremise().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getFirm() != null) {
                deprecatedProperties.getFirm().accept(this);
            }
            if (this.shouldWalk && deprecatedProperties.getPostalCode() != null) {
                deprecatedProperties.getPostalCode().accept(this);
            }
        }
    }
}

