/*
 * Decompiled with CFR 0.152.
 */
package org.xmlunit.matchers;

import java.math.BigDecimal;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public abstract class TypeMatcher<T>
extends TypeSafeMatcher<String> {
    private T value;
    private Exception exception;
    private final Class<T> clazz;
    private final Matcher<? extends T> valueMatcher;

    public TypeMatcher(Class<T> clazz, Matcher<? extends T> valueMatcher) {
        super(String.class);
        this.clazz = clazz;
        this.valueMatcher = valueMatcher;
    }

    protected boolean matchesSafely(String item) {
        try {
            this.value = this.nullSafeConvert(item);
            return this.valueMatcher.matches(this.value);
        }
        catch (Exception e) {
            this.exception = e;
            return false;
        }
    }

    public void describeTo(Description description) {
        description.appendText("string converted to ").appendText(this.clazz.getName()).appendText(" ").appendDescriptionOf(this.valueMatcher);
    }

    protected void describeMismatchSafely(String item, Description mismatchDescription) {
        if (this.exception != null) {
            mismatchDescription.appendText("failed with ").appendText(this.exception.toString());
        } else {
            mismatchDescription.appendText("was ").appendValue(this.value);
        }
    }

    private T nullSafeConvert(String item) {
        if (item == null) {
            return null;
        }
        if ((item = item.trim()).length() < 1) {
            return null;
        }
        return this.convert(item);
    }

    protected abstract T convert(String var1);

    @Factory
    public static TypeMatcher<BigDecimal> asBigDecimal(Matcher<? extends BigDecimal> valueMatcher) {
        return new BigDecimalTypeMatcher(valueMatcher);
    }

    @Factory
    public static TypeMatcher<Double> asDouble(Matcher<? extends Double> valueMatcher) {
        return new DoubleTypeMatcher(valueMatcher);
    }

    @Factory
    public static TypeMatcher<Integer> asInt(Matcher<? extends Integer> valueMatcher) {
        return new IntegerTypeMatcher(valueMatcher);
    }

    @Factory
    public static TypeMatcher<Boolean> asBoolean(Matcher<? extends Boolean> valueMatcher) {
        return new BooleanTypeMatcher(valueMatcher);
    }

    private static class BigDecimalTypeMatcher
    extends TypeMatcher<BigDecimal> {
        private BigDecimalTypeMatcher(Matcher<? extends BigDecimal> matcher) {
            super(BigDecimal.class, matcher);
        }

        @Override
        protected BigDecimal convert(String item) {
            return new BigDecimal(item);
        }
    }

    private static class DoubleTypeMatcher
    extends TypeMatcher<Double> {
        private DoubleTypeMatcher(Matcher<? extends Double> matcher) {
            super(Double.class, matcher);
        }

        @Override
        protected Double convert(String item) {
            return Double.valueOf(item);
        }
    }

    private static class IntegerTypeMatcher
    extends TypeMatcher<Integer> {
        private IntegerTypeMatcher(Matcher<? extends Integer> matcher) {
            super(Integer.class, matcher);
        }

        @Override
        protected Integer convert(String item) {
            return Integer.valueOf(item);
        }
    }

    private static class BooleanTypeMatcher
    extends TypeMatcher<Boolean> {
        private BooleanTypeMatcher(Matcher<? extends Boolean> matcher) {
            super(Boolean.class, matcher);
        }

        @Override
        protected Boolean convert(String item) {
            if ("true".equalsIgnoreCase(item)) {
                return true;
            }
            if ("false".equalsIgnoreCase(item)) {
                return false;
            }
            throw new IllegalArgumentException("\"" + item + "\" is not a boolean value");
        }
    }
}

