/*
 * Decompiled with CFR 0.152.
 */
package org.xolstice.maven.plugin.protobuf;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.plugin.logging.Log;
import org.codehaus.plexus.util.Os;
import org.xolstice.maven.plugin.protobuf.MojoConfigurationException;

public class ProtocPlugin {
    private static final String DATA_MODEL_SYSPROP = "sun.arch.data.model";
    private static final String WIN_JVM_DATA_MODEL_32 = "32";
    private static final String WIN_JVM_DATA_MODEL_64 = "64";
    private String id;
    private String groupId;
    private String artifactId;
    private String version;
    private String classifier;
    private String mainClass;
    private String javaHome;
    private String winJvmDataModel;
    private List<String> args;
    private List<String> jvmArgs;

    public String getId() {
        return this.id;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String getMainClass() {
        return this.mainClass;
    }

    public List<String> getArgs() {
        return this.args != null ? this.args : Collections.emptyList();
    }

    public List<String> getJvmArgs() {
        return this.jvmArgs != null ? this.jvmArgs : Collections.emptyList();
    }

    public String getJavaHome() {
        return this.javaHome;
    }

    public void setJavaHome(String javaHome) {
        this.javaHome = javaHome;
    }

    public String getWinJvmDataModel() {
        return this.winJvmDataModel;
    }

    public String getPluginName() {
        return "protoc-gen-" + this.id;
    }

    public void validate(Log log) {
        if (this.id == null) {
            throw new MojoConfigurationException("id must be set in protocPlugin definition");
        }
        if (this.groupId == null) {
            throw new MojoConfigurationException("groupId must be set in protocPlugin definition");
        }
        if (this.artifactId == null) {
            throw new MojoConfigurationException("artifactId must be set in protocPlugin definition");
        }
        if (this.version == null) {
            throw new MojoConfigurationException("version must be set in protocPlugin definition");
        }
        if (this.mainClass == null) {
            throw new MojoConfigurationException("mainClass must be set in protocPlugin definition");
        }
        if (this.javaHome == null || !new File(this.javaHome).isDirectory()) {
            throw new MojoConfigurationException("javaHome is invalid: " + this.javaHome);
        }
        if (Os.isFamily((String)"windows")) {
            if (this.winJvmDataModel != null) {
                if (!this.winJvmDataModel.equals(WIN_JVM_DATA_MODEL_32) && !this.winJvmDataModel.equals(WIN_JVM_DATA_MODEL_64)) {
                    throw new MojoConfigurationException("winJvmDataModel must be '32' or '64'");
                }
            } else if (this.archDirectoryExists("amd64")) {
                this.winJvmDataModel = WIN_JVM_DATA_MODEL_64;
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)"detected 64-bit JVM from directory structure");
                }
            } else if (this.archDirectoryExists("i386")) {
                this.winJvmDataModel = WIN_JVM_DATA_MODEL_32;
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)"detected 32-bit JVM from directory structure");
                }
            } else if (System.getProperty(DATA_MODEL_SYSPROP) != null) {
                this.winJvmDataModel = System.getProperty(DATA_MODEL_SYSPROP);
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)("detected " + this.winJvmDataModel + "-bit JVM from system property " + DATA_MODEL_SYSPROP));
                }
            } else {
                this.winJvmDataModel = WIN_JVM_DATA_MODEL_32;
                if (log.isDebugEnabled()) {
                    log.debug((CharSequence)"defaulting to 32-bit JVM");
                }
            }
        }
    }

    private boolean archDirectoryExists(String arch) {
        return this.javaHome != null && (new File(this.javaHome, "jre/lib/" + arch).isDirectory() || new File(this.javaHome, "lib/" + arch).isDirectory());
    }

    public File getPluginExecutableFile(File pluginDirectory) {
        if (Os.isFamily((String)"windows")) {
            return new File(pluginDirectory, this.getPluginName() + ".exe");
        }
        return new File(pluginDirectory, this.getPluginName());
    }

    public String toString() {
        return "ProtocPlugin{id='" + this.id + '\'' + ", groupId='" + this.groupId + '\'' + ", artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", classifier='" + this.classifier + '\'' + ", mainClass='" + this.mainClass + '\'' + ", javaHome='" + this.javaHome + '\'' + ", winJvmDataModel='" + this.winJvmDataModel + '\'' + ", args=" + this.args + ", jvmArgs=" + this.jvmArgs + '}';
    }
}

