/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.xrpl.xrpl4j.codec.addresses.Utils;
import org.xrpl.xrpl4j.codec.addresses.exceptions.EncodingFormatException;

public class Base58 {
    public static final char[] ALPHABET = "rpshnaf39wBUDNEGHJKLM4PQRST7VWXYZ2bcdeCg65jkm8oFqi1tuvAxyz".toCharArray();
    private static final int[] INDEXES = new int[255];

    public static String encode(byte[] input) {
        int zeroCount;
        if (input.length == 0) {
            return "";
        }
        input = Arrays.copyOfRange(input, 0, input.length);
        for (zeroCount = 0; zeroCount < input.length && input[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length * 2];
        int tempIndex = temp.length;
        int startAt = zeroCount;
        while (startAt < input.length) {
            byte mod = Base58.divmod58(input, startAt);
            if (input[startAt] == 0) {
                ++startAt;
            }
            temp[--tempIndex] = (byte)ALPHABET[mod];
        }
        while (tempIndex < temp.length && temp[tempIndex] == ALPHABET[0]) {
            ++tempIndex;
        }
        while (--zeroCount >= 0) {
            temp[--tempIndex] = (byte)ALPHABET[0];
        }
        byte[] output = Arrays.copyOfRange(temp, tempIndex, temp.length);
        return new String(output, StandardCharsets.US_ASCII);
    }

    public static byte[] decode(String input) {
        int zeroCount;
        if (input.length() == 0) {
            return new byte[0];
        }
        byte[] input58 = new byte[input.length()];
        for (int i = 0; i < input.length(); ++i) {
            char charAtIndex = input.charAt(i);
            int digit58 = -1;
            if (charAtIndex < INDEXES.length) {
                digit58 = INDEXES[charAtIndex];
            }
            if (digit58 < 0) {
                throw new EncodingFormatException("Illegal character " + charAtIndex + " at " + i);
            }
            input58[i] = (byte)digit58;
        }
        for (zeroCount = 0; zeroCount < input58.length && input58[zeroCount] == 0; ++zeroCount) {
        }
        byte[] temp = new byte[input.length()];
        int tempIndex = temp.length;
        int startAt = zeroCount;
        while (startAt < input58.length) {
            byte mod = Base58.divmod256(input58, startAt);
            if (input58[startAt] == 0) {
                ++startAt;
            }
            temp[--tempIndex] = mod;
        }
        while (tempIndex < temp.length && temp[tempIndex] == 0) {
            ++tempIndex;
        }
        return Arrays.copyOfRange(temp, tempIndex - zeroCount, temp.length);
    }

    public static String encodeChecked(byte[] bytes) {
        byte[] checkSum = Arrays.copyOfRange(Utils.doubleDigest(bytes), 0, 4);
        byte[] output = new byte[bytes.length + checkSum.length];
        System.arraycopy(bytes, 0, output, 0, bytes.length);
        System.arraycopy(checkSum, 0, output, bytes.length, checkSum.length);
        return Base58.encode(output);
    }

    public static byte[] decodeChecked(String input) throws EncodingFormatException {
        byte[] hash;
        byte[] tmp = Base58.decode(input);
        if (tmp.length < 4) {
            throw new EncodingFormatException("Input must be longer than 3 characters.");
        }
        byte[] bytes = Arrays.copyOfRange(tmp, 0, tmp.length - 4);
        byte[] checksum = Arrays.copyOfRange(tmp, tmp.length - 4, tmp.length);
        if (!Arrays.equals(checksum, hash = Arrays.copyOfRange(tmp = Utils.doubleDigest(bytes), 0, 4))) {
            throw new EncodingFormatException("Checksum does not validate");
        }
        return bytes;
    }

    private static byte divmod58(byte[] number, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number.length; ++i) {
            int digit256 = number[i] & 0xFF;
            int temp = remainder * 256 + digit256;
            number[i] = (byte)(temp / 58);
            remainder = temp % 58;
        }
        return (byte)remainder;
    }

    private static byte divmod256(byte[] number58, int startAt) {
        int remainder = 0;
        for (int i = startAt; i < number58.length; ++i) {
            int digit58 = number58[i] & 0xFF;
            int temp = remainder * 58 + digit58;
            number58[i] = (byte)(temp / 256);
            remainder = temp % 256;
        }
        return (byte)remainder;
    }

    static {
        Arrays.fill(INDEXES, -1);
        for (int i = 0; i < ALPHABET.length; ++i) {
            Base58.INDEXES[Base58.ALPHABET[i]] = i;
        }
    }
}

