/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.codec.addresses;

import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.codec.addresses.ClassicAddress;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ClassicAddress", generator="Immutables")
@Immutable
public final class ImmutableClassicAddress
implements ClassicAddress {
    private final Address classicAddress;
    private final UnsignedInteger tag;
    private final boolean test;

    private ImmutableClassicAddress(Address classicAddress, UnsignedInteger tag, boolean test) {
        this.classicAddress = classicAddress;
        this.tag = tag;
        this.test = test;
    }

    @Override
    public Address classicAddress() {
        return this.classicAddress;
    }

    @Override
    public UnsignedInteger tag() {
        return this.tag;
    }

    @Override
    public boolean test() {
        return this.test;
    }

    public final ImmutableClassicAddress withClassicAddress(Address value) {
        if (this.classicAddress == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "classicAddress");
        return new ImmutableClassicAddress(newValue, this.tag, this.test);
    }

    public final ImmutableClassicAddress withTag(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "tag");
        if (this.tag.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableClassicAddress(this.classicAddress, newValue, this.test);
    }

    public final ImmutableClassicAddress withTest(boolean value) {
        if (this.test == value) {
            return this;
        }
        return new ImmutableClassicAddress(this.classicAddress, this.tag, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableClassicAddress && this.equalTo((ImmutableClassicAddress)another);
    }

    private boolean equalTo(ImmutableClassicAddress another) {
        return this.classicAddress.equals((Object)another.classicAddress) && this.tag.equals((Object)another.tag) && this.test == another.test;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.classicAddress.hashCode();
        h += (h << 5) + this.tag.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.test);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"ClassicAddress").omitNullValues().add("classicAddress", (Object)this.classicAddress).add("tag", (Object)this.tag).add("test", this.test).toString();
    }

    public static ImmutableClassicAddress copyOf(ClassicAddress instance) {
        if (instance instanceof ImmutableClassicAddress) {
            return (ImmutableClassicAddress)instance;
        }
        return ImmutableClassicAddress.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ClassicAddress", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_CLASSIC_ADDRESS = 1L;
        private static final long INIT_BIT_TAG = 2L;
        private static final long INIT_BIT_TEST = 4L;
        private long initBits = 7L;
        @Nullable
        private Address classicAddress;
        @Nullable
        private UnsignedInteger tag;
        private boolean test;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(ClassicAddress instance) {
            Objects.requireNonNull(instance, "instance");
            this.classicAddress(instance.classicAddress());
            this.tag(instance.tag());
            this.test(instance.test());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder classicAddress(Address classicAddress) {
            this.classicAddress = Objects.requireNonNull(classicAddress, "classicAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder tag(UnsignedInteger tag) {
            this.tag = Objects.requireNonNull(tag, "tag");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder test(boolean test) {
            this.test = test;
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableClassicAddress build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableClassicAddress(this.classicAddress, this.tag, this.test);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("classicAddress");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("tag");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("test");
            }
            return "Cannot build ClassicAddress, some of required attributes are not set " + attributes;
        }
    }
}

