/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.client.JsonRpcRequest;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="JsonRpcRequest", generator="Immutables")
@Immutable
public final class ImmutableJsonRpcRequest
implements JsonRpcRequest {
    private final String method;
    private final ImmutableList<XrplRequestParams> params;

    private ImmutableJsonRpcRequest(String method, ImmutableList<XrplRequestParams> params) {
        this.method = method;
        this.params = params;
    }

    @Override
    @JsonProperty(value="method")
    public String method() {
        return this.method;
    }

    @JsonProperty(value="params")
    public ImmutableList<XrplRequestParams> params() {
        return this.params;
    }

    public final ImmutableJsonRpcRequest withMethod(String value) {
        String newValue = Objects.requireNonNull(value, "method");
        if (this.method.equals(newValue)) {
            return this;
        }
        return new ImmutableJsonRpcRequest(newValue, this.params);
    }

    public final ImmutableJsonRpcRequest withParams(XrplRequestParams ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableJsonRpcRequest(this.method, (ImmutableList<XrplRequestParams>)newValue);
    }

    public final ImmutableJsonRpcRequest withParams(Iterable<? extends XrplRequestParams> elements) {
        if (this.params == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableJsonRpcRequest(this.method, (ImmutableList<XrplRequestParams>)newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableJsonRpcRequest && this.equalTo(0, (ImmutableJsonRpcRequest)another);
    }

    private boolean equalTo(int synthetic, ImmutableJsonRpcRequest another) {
        return this.method.equals(another.method) && this.params.equals(another.params);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.method.hashCode();
        h += (h << 5) + this.params.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"JsonRpcRequest").omitNullValues().add("method", (Object)this.method).add("params", this.params).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableJsonRpcRequest fromJson(Json json) {
        Builder builder = ImmutableJsonRpcRequest.builder();
        if (json.method != null) {
            builder.method(json.method);
        }
        if (json.params != null) {
            builder.addAllParams(json.params);
        }
        return builder.build();
    }

    public static ImmutableJsonRpcRequest copyOf(JsonRpcRequest instance) {
        if (instance instanceof ImmutableJsonRpcRequest) {
            return (ImmutableJsonRpcRequest)instance;
        }
        return ImmutableJsonRpcRequest.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="JsonRpcRequest", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_METHOD = 1L;
        private long initBits = 1L;
        @Nullable
        private String method;
        private ImmutableList.Builder<XrplRequestParams> params = ImmutableList.builder();

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(JsonRpcRequest instance) {
            Objects.requireNonNull(instance, "instance");
            this.method(instance.method());
            this.addAllParams(instance.params());
            return this;
        }

        @JsonProperty(value="method")
        @CanIgnoreReturnValue
        public final Builder method(String method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParams(XrplRequestParams element) {
            this.params.add((Object)element);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addParams(XrplRequestParams ... elements) {
            this.params.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="params")
        @CanIgnoreReturnValue
        public final Builder params(Iterable<? extends XrplRequestParams> elements) {
            this.params = ImmutableList.builder();
            return this.addAllParams(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllParams(Iterable<? extends XrplRequestParams> elements) {
            this.params.addAll(elements);
            return this;
        }

        public ImmutableJsonRpcRequest build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableJsonRpcRequest(this.method, this.params.build());
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("method");
            }
            return "Cannot build JsonRpcRequest, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="JsonRpcRequest", generator="Immutables")
    static final class Json
    implements JsonRpcRequest {
        @Nullable
        String method;
        @Nullable
        List<XrplRequestParams> params = ImmutableList.of();

        Json() {
        }

        @JsonProperty(value="method")
        public void setMethod(String method) {
            this.method = method;
        }

        @JsonProperty(value="params")
        public void setParams(List<XrplRequestParams> params) {
            this.params = params;
        }

        @Override
        public String method() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<XrplRequestParams> params() {
            throw new UnsupportedOperationException();
        }
    }
}

