/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import feign.Feign;
import feign.Headers;
import feign.Request;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.optionals.OptionalDecoder;
import java.time.Duration;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xrpl.xrpl4j.client.JsonRpcClientErrorException;
import org.xrpl.xrpl4j.client.JsonRpcRequest;
import org.xrpl.xrpl4j.client.RetryStatusDecoder;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.jackson.ObjectMapperFactory;

@Beta
public interface JsonRpcClient {
    public static final Logger logger = LoggerFactory.getLogger(JsonRpcClient.class);
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";
    public static final ObjectMapper objectMapper = ObjectMapperFactory.create();
    public static final int SERVICE_UNAVAILABLE_STATUS = 503;
    public static final Duration RETRY_INTERVAL = Duration.ofSeconds(1L);
    public static final String RESULT = "result";
    public static final String STATUS = "status";
    public static final String ERROR = "error";
    public static final String ERROR_EXCEPTION = "error_exception";
    public static final String ERROR_MESSAGE = "error_message";
    public static final String N_A = "n/a";

    public static JsonRpcClient construct(HttpUrl rippledUrl) {
        Objects.requireNonNull(rippledUrl);
        return JsonRpcClient.construct(rippledUrl, new Request.Options());
    }

    public static JsonRpcClient construct(HttpUrl rippledUrl, Request.Options options) {
        Objects.requireNonNull(rippledUrl);
        Objects.requireNonNull(options);
        return (JsonRpcClient)Feign.builder().encoder((Encoder)new JacksonEncoder(objectMapper)).errorDecoder((ErrorDecoder)new RetryStatusDecoder(RETRY_INTERVAL, 503, new Integer[0])).decode404().options(options).decoder((Decoder)new OptionalDecoder((Decoder)new JacksonDecoder(objectMapper))).target(JsonRpcClient.class, rippledUrl.toString());
    }

    @RequestLine(value="POST /")
    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    public JsonNode postRpcRequest(JsonRpcRequest var1);

    default public <T extends XrplResult> T send(JsonRpcRequest request, Class<T> resultType) throws JsonRpcClientErrorException {
        JavaType javaType = objectMapper.constructType(resultType);
        return this.send(request, javaType);
    }

    default public <T extends XrplResult> T send(JsonRpcRequest request, JavaType resultType) throws JsonRpcClientErrorException {
        JsonNode response = this.postRpcRequest(request);
        JsonNode result = response.get(RESULT);
        this.checkForError(response);
        try {
            return (T)((XrplResult)objectMapper.readValue(result.toString(), resultType));
        }
        catch (JsonProcessingException e) {
            throw new JsonRpcClientErrorException(e);
        }
    }

    default public void checkForError(JsonNode response) throws JsonRpcClientErrorException {
        String status;
        JsonNode result;
        if (response.has(RESULT) && (result = response.get(RESULT)).has(STATUS) && (status = result.get(STATUS).asText()).equals(ERROR) && result.has(ERROR)) {
            String errorCode = result.get(ERROR).asText();
            String errorMessage = result.hasNonNull(ERROR_EXCEPTION) ? result.get(ERROR_EXCEPTION).asText() : (result.hasNonNull(ERROR_MESSAGE) ? result.get(ERROR_MESSAGE).asText() : N_A);
            throw new JsonRpcClientErrorException(String.format("%s (%s)", errorCode, errorMessage));
        }
    }
}

