/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client;

import com.google.common.collect.ImmutableList;
import feign.Response;
import feign.RetryableException;
import feign.codec.ErrorDecoder;
import java.time.Duration;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.xrpl.xrpl4j.client.JsonRpcClient;

public class RetryStatusDecoder
implements ErrorDecoder {
    private final ErrorDecoder defaultErrorDecoder = new ErrorDecoder.Default();
    private final Duration retryInterval;
    private final List<Integer> retryableStatuses;

    public RetryStatusDecoder(Duration retryInterval, Integer retryHttpStatusCode, Integer ... otherStatuses) {
        this.retryableStatuses = ImmutableList.builder().add((Object)retryHttpStatusCode).addAll(Arrays.asList(otherStatuses)).build();
        this.retryInterval = retryInterval;
    }

    public Exception decode(String methodKey, Response response) {
        Exception exception = this.defaultErrorDecoder.decode(methodKey, response);
        if (this.retryableStatuses.contains(response.status())) {
            JsonRpcClient.logger.error(String.format("##### Got %s response from %s #######", response.status(), methodKey));
            return new RetryableException(response.status(), exception.getMessage(), response.request().httpMethod(), Date.from(new Date().toInstant().plus(this.retryInterval)), response.request());
        }
        return exception;
    }
}

