/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.Beta;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Range;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import feign.Request;
import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import okhttp3.HttpUrl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xrpl.xrpl4j.client.ImmutableJsonRpcRequest;
import org.xrpl.xrpl4j.client.JsonRpcClient;
import org.xrpl.xrpl4j.client.JsonRpcClientErrorException;
import org.xrpl.xrpl4j.client.JsonRpcRequest;
import org.xrpl.xrpl4j.codec.binary.XrplBinaryCodec;
import org.xrpl.xrpl4j.crypto.signing.MultiSignedTransaction;
import org.xrpl.xrpl4j.crypto.signing.SingleSignedTransaction;
import org.xrpl.xrpl4j.model.client.Finality;
import org.xrpl.xrpl4j.model.client.FinalityStatus;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountChannelsRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountChannelsResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountCurrenciesRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountCurrenciesResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountInfoRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountInfoResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountLinesRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountLinesResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountNftsRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountNftsResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountObjectsRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountObjectsResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountOffersRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountOffersResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsResult;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesRequestParams;
import org.xrpl.xrpl4j.model.client.accounts.GatewayBalancesResult;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoRequestParams;
import org.xrpl.xrpl4j.model.client.amm.AmmInfoResult;
import org.xrpl.xrpl4j.model.client.channels.ChannelVerifyRequestParams;
import org.xrpl.xrpl4j.model.client.channels.ChannelVerifyResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.fees.FeeResult;
import org.xrpl.xrpl4j.model.client.ledger.LedgerEntryRequestParams;
import org.xrpl.xrpl4j.model.client.ledger.LedgerEntryResult;
import org.xrpl.xrpl4j.model.client.ledger.LedgerRequestParams;
import org.xrpl.xrpl4j.model.client.ledger.LedgerResult;
import org.xrpl.xrpl4j.model.client.nft.NftBuyOffersRequestParams;
import org.xrpl.xrpl4j.model.client.nft.NftBuyOffersResult;
import org.xrpl.xrpl4j.model.client.nft.NftInfoRequestParams;
import org.xrpl.xrpl4j.model.client.nft.NftInfoResult;
import org.xrpl.xrpl4j.model.client.nft.NftSellOffersRequestParams;
import org.xrpl.xrpl4j.model.client.nft.NftSellOffersResult;
import org.xrpl.xrpl4j.model.client.oracle.GetAggregatePriceRequestParams;
import org.xrpl.xrpl4j.model.client.oracle.GetAggregatePriceResult;
import org.xrpl.xrpl4j.model.client.path.BookOffersRequestParams;
import org.xrpl.xrpl4j.model.client.path.BookOffersResult;
import org.xrpl.xrpl4j.model.client.path.DepositAuthorizedRequestParams;
import org.xrpl.xrpl4j.model.client.path.DepositAuthorizedResult;
import org.xrpl.xrpl4j.model.client.path.RipplePathFindRequestParams;
import org.xrpl.xrpl4j.model.client.path.RipplePathFindResult;
import org.xrpl.xrpl4j.model.client.serverinfo.ServerInfoResult;
import org.xrpl.xrpl4j.model.client.transactions.SubmitMultiSignedRequestParams;
import org.xrpl.xrpl4j.model.client.transactions.SubmitMultiSignedResult;
import org.xrpl.xrpl4j.model.client.transactions.SubmitRequestParams;
import org.xrpl.xrpl4j.model.client.transactions.SubmitResult;
import org.xrpl.xrpl4j.model.client.transactions.TransactionRequestParams;
import org.xrpl.xrpl4j.model.client.transactions.TransactionResult;
import org.xrpl.xrpl4j.model.immutables.FluentCompareTo;
import org.xrpl.xrpl4j.model.jackson.ObjectMapperFactory;
import org.xrpl.xrpl4j.model.ledger.LedgerObject;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

@Beta
public class XrplClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(XrplClient.class);
    private final ObjectMapper objectMapper;
    private final XrplBinaryCodec binaryCodec;
    private final JsonRpcClient jsonRpcClient;

    public XrplClient(HttpUrl rippledUrl) {
        this(JsonRpcClient.construct(rippledUrl));
    }

    public XrplClient(HttpUrl rippledUrl, Duration connectTimeout, Duration readTimeout) {
        this(JsonRpcClient.construct(rippledUrl, new Request.Options(connectTimeout.toMillis(), TimeUnit.MILLISECONDS, readTimeout.toMillis(), TimeUnit.MILLISECONDS, true)));
    }

    @VisibleForTesting
    XrplClient(JsonRpcClient jsonRpcClient) {
        this.jsonRpcClient = Objects.requireNonNull(jsonRpcClient);
        this.objectMapper = ObjectMapperFactory.create();
        this.binaryCodec = XrplBinaryCodec.getInstance();
    }

    public <T extends Transaction> SubmitResult<T> submit(SingleSignedTransaction<T> signedTransaction) throws JsonRpcClientErrorException, JsonProcessingException {
        Objects.requireNonNull(signedTransaction);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to submit signedTransaction: {}", signedTransaction);
        }
        String signedJson = this.objectMapper.writeValueAsString((Object)signedTransaction.signedTransaction());
        String signedBlob = this.binaryCodec.encode(signedJson);
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("submit").addParams((XrplRequestParams)SubmitRequestParams.of((String)signedBlob)).build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("About to submit JsonRpcRequest: {}", (Object)request);
        }
        JavaType resultType = this.objectMapper.getTypeFactory().constructParametricType(SubmitResult.class, new Class[]{signedTransaction.unsignedTransaction().getClass()});
        return (SubmitResult)this.jsonRpcClient.send((JsonRpcRequest)request, resultType);
    }

    public <T extends Transaction> SubmitMultiSignedResult<T> submitMultisigned(MultiSignedTransaction<T> transaction) throws JsonRpcClientErrorException {
        Objects.requireNonNull(transaction);
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("submit_multisigned").addParams((XrplRequestParams)SubmitMultiSignedRequestParams.of((Transaction)transaction.signedTransaction())).build();
        JavaType resultType = this.objectMapper.getTypeFactory().constructParametricType(SubmitMultiSignedResult.class, new Class[]{transaction.getClass()});
        return (SubmitMultiSignedResult)this.jsonRpcClient.send((JsonRpcRequest)request, resultType);
    }

    public FeeResult fee() throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("fee").build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, FeeResult.class);
    }

    protected UnsignedInteger getMostRecentlyValidatedLedgerIndex() throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("ledger").addParams((XrplRequestParams)LedgerRequestParams.builder().ledgerSpecifier(LedgerSpecifier.VALIDATED).build()).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, LedgerResult.class).ledgerIndexSafe().unsignedIntegerValue();
    }

    protected Optional<? extends TransactionResult<? extends Transaction>> getValidatedTransaction(Hash256 transactionHash) {
        Objects.requireNonNull(transactionHash);
        try {
            TransactionResult<Transaction> transactionResult = this.transaction(TransactionRequestParams.of((Hash256)transactionHash), Transaction.class);
            return Optional.ofNullable(transactionResult).filter(TransactionResult::validated);
        }
        catch (JsonRpcClientErrorException e) {
            LOGGER.warn(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    protected boolean ledgerGapsExistBetween(UnsignedLong submittedLedgerSequence, UnsignedLong lastLedgerSequence) {
        ServerInfoResult serverInfo;
        Objects.requireNonNull(submittedLedgerSequence);
        Objects.requireNonNull(lastLedgerSequence);
        try {
            serverInfo = this.serverInformation();
        }
        catch (JsonRpcClientErrorException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return true;
        }
        if (FluentCompareTo.is((Comparable)lastLedgerSequence).lessThan((Comparable)submittedLedgerSequence)) {
            lastLedgerSequence = submittedLedgerSequence;
        }
        Range submittedToLast = Range.closed((Comparable)submittedLedgerSequence, (Comparable)lastLedgerSequence);
        return serverInfo.info().completeLedgers().stream().noneMatch(range -> range.encloses(submittedToLast));
    }

    public Finality isFinal(Hash256 transactionHash, LedgerIndex submittedOnLedgerIndex, UnsignedInteger lastLedgerSequence, UnsignedInteger transactionAccountSequence, Address account) {
        return (Finality)this.getValidatedTransaction(transactionHash).map(transactionResult -> {
            boolean isTesSuccess = transactionResult.metadata().map(TransactionMetadata::transactionResult).filter("tesSUCCESS"::equals).map($ -> true).isPresent();
            boolean metadataExists = transactionResult.metadata().isPresent();
            if (isTesSuccess) {
                LOGGER.debug("Transaction with hash: {} was validated with success", (Object)transactionHash);
                return Finality.builder().finalityStatus(FinalityStatus.VALIDATED_SUCCESS).resultCode(((TransactionMetadata)transactionResult.metadata().get()).transactionResult()).build();
            }
            if (!metadataExists) {
                return Finality.builder().finalityStatus(FinalityStatus.VALIDATED_UNKNOWN).build();
            }
            LOGGER.debug("Transaction with hash: {} was validated with failure", (Object)transactionHash);
            return Finality.builder().finalityStatus(FinalityStatus.VALIDATED_FAILURE).resultCode(((TransactionMetadata)transactionResult.metadata().get()).transactionResult()).build();
        }).orElseGet(() -> {
            try {
                boolean isTransactionExpired = FluentCompareTo.is((Comparable)this.getMostRecentlyValidatedLedgerIndex()).greaterThan((Comparable)lastLedgerSequence);
                if (!isTransactionExpired) {
                    LOGGER.debug("Transaction with hash: {} has not expired yet, check again", (Object)transactionHash);
                    return Finality.builder().finalityStatus(FinalityStatus.NOT_FINAL).build();
                }
                boolean isMissingLedgers = this.ledgerGapsExistBetween(UnsignedLong.valueOf((String)submittedOnLedgerIndex.toString()), UnsignedLong.valueOf((String)lastLedgerSequence.toString()));
                if (isMissingLedgers) {
                    LOGGER.debug("Transaction with hash: {} has expired and rippled is missing some to confirm if it was validated", (Object)transactionHash);
                    return Finality.builder().finalityStatus(FinalityStatus.NOT_FINAL).build();
                }
                AccountInfoResult accountInfoResult = this.accountInfo(AccountInfoRequestParams.of((Address)account));
                UnsignedInteger accountSequence = accountInfoResult.accountData().sequence();
                if (FluentCompareTo.is((Comparable)transactionAccountSequence).lessThan((Comparable)accountSequence)) {
                    return Finality.builder().finalityStatus(FinalityStatus.EXPIRED_WITH_SPENT_ACCOUNT_SEQUENCE).build();
                }
                LOGGER.debug("Transaction with hash: {} has expired, consider resubmitting with updated lastledgersequence and fee", (Object)transactionHash);
                return Finality.builder().finalityStatus(FinalityStatus.EXPIRED).build();
            }
            catch (JsonRpcClientErrorException e) {
                LOGGER.warn(e.getMessage(), (Throwable)e);
                return Finality.builder().finalityStatus(FinalityStatus.NOT_FINAL).build();
            }
        });
    }

    public ServerInfoResult serverInformation() throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("server_info").build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, ServerInfoResult.class);
    }

    public AccountChannelsResult accountChannels(AccountChannelsRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_channels").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountChannelsResult.class);
    }

    public AccountCurrenciesResult accountCurrencies(AccountCurrenciesRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_currencies").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountCurrenciesResult.class);
    }

    public AccountInfoResult accountInfo(AccountInfoRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_info").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountInfoResult.class);
    }

    public AccountNftsResult accountNfts(Address account) throws JsonRpcClientErrorException {
        Objects.requireNonNull(account);
        return this.accountNfts((AccountNftsRequestParams)AccountNftsRequestParams.builder().account(account).build());
    }

    public AccountNftsResult accountNfts(AccountNftsRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_nfts").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountNftsResult.class);
    }

    public NftBuyOffersResult nftBuyOffers(NftBuyOffersRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("nft_buy_offers").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, NftBuyOffersResult.class);
    }

    public NftSellOffersResult nftSellOffers(NftSellOffersRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("nft_sell_offers").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, NftSellOffersResult.class);
    }

    public NftInfoResult nftInfo(NftInfoRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("nft_info").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, NftInfoResult.class);
    }

    public AccountObjectsResult accountObjects(AccountObjectsRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_objects").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountObjectsResult.class);
    }

    public AccountOffersResult accountOffers(AccountOffersRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_offers").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountOffersResult.class);
    }

    public DepositAuthorizedResult depositAuthorized(DepositAuthorizedRequestParams params) throws JsonRpcClientErrorException {
        Objects.requireNonNull(params);
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("deposit_authorized").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, DepositAuthorizedResult.class);
    }

    public AccountTransactionsResult accountTransactions(Address address) throws JsonRpcClientErrorException {
        return this.accountTransactions((AccountTransactionsRequestParams)AccountTransactionsRequestParams.unboundedBuilder().account(address).build());
    }

    public AccountTransactionsResult accountTransactions(AccountTransactionsRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_tx").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountTransactionsResult.class);
    }

    public <T extends Transaction> TransactionResult<T> transaction(TransactionRequestParams params, Class<T> transactionType) throws JsonRpcClientErrorException {
        Objects.requireNonNull(params);
        Objects.requireNonNull(transactionType);
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("tx").addParams((XrplRequestParams)params).build();
        JavaType resultType = this.objectMapper.getTypeFactory().constructParametricType(TransactionResult.class, new Class[]{transactionType});
        return (TransactionResult)this.jsonRpcClient.send((JsonRpcRequest)request, resultType);
    }

    public LedgerResult ledger(LedgerRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("ledger").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, LedgerResult.class);
    }

    public <T extends LedgerObject> LedgerEntryResult<T> ledgerEntry(LedgerEntryRequestParams<T> params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("ledger_entry").addParams((XrplRequestParams)params).build();
        JavaType resultType = this.objectMapper.getTypeFactory().constructParametricType(LedgerEntryResult.class, new Class[]{params.ledgerObjectClass()});
        return (LedgerEntryResult)this.jsonRpcClient.send((JsonRpcRequest)request, resultType);
    }

    public RipplePathFindResult ripplePathFind(RipplePathFindRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("ripple_path_find").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, RipplePathFindResult.class);
    }

    public BookOffersResult bookOffers(BookOffersRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("book_offers").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, BookOffersResult.class);
    }

    public AccountLinesResult accountLines(AccountLinesRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("account_lines").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AccountLinesResult.class);
    }

    public ChannelVerifyResult channelVerify(ChannelVerifyRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("channel_verify").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, ChannelVerifyResult.class);
    }

    public GatewayBalancesResult gatewayBalances(GatewayBalancesRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("gateway_balances").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, GatewayBalancesResult.class);
    }

    @Beta
    public AmmInfoResult ammInfo(AmmInfoRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("amm_info").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, AmmInfoResult.class);
    }

    @Beta
    public GetAggregatePriceResult getAggregatePrice(GetAggregatePriceRequestParams params) throws JsonRpcClientErrorException {
        ImmutableJsonRpcRequest request = JsonRpcRequest.builder().method("get_aggregate_price").addParams((XrplRequestParams)params).build();
        return this.jsonRpcClient.send((JsonRpcRequest)request, GetAggregatePriceResult.class);
    }

    public JsonRpcClient getJsonRpcClient() {
        return this.jsonRpcClient;
    }
}

