/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client.faucet;

import com.fasterxml.jackson.databind.ObjectMapper;
import feign.Feign;
import feign.Headers;
import feign.RequestLine;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.optionals.OptionalDecoder;
import java.time.Duration;
import java.util.Objects;
import okhttp3.HttpUrl;
import org.xrpl.xrpl4j.client.RetryStatusDecoder;
import org.xrpl.xrpl4j.client.faucet.FaucetAccountResponse;
import org.xrpl.xrpl4j.client.faucet.FundAccountRequest;
import org.xrpl.xrpl4j.model.jackson.ObjectMapperFactory;

public interface FaucetClient {
    public static final String HEADER_ACCEPT = "Accept";
    public static final String HEADER_CONTENT_TYPE = "Content-Type";
    public static final String APPLICATION_JSON = "application/json";
    public static final int SERVICE_UNAVAILABLE_STATUS = 503;
    public static final Duration RETRY_INTERVAL = Duration.ofSeconds(1L);

    public static FaucetClient construct(HttpUrl faucetUrl) {
        Objects.requireNonNull(faucetUrl);
        ObjectMapper objectMapper = ObjectMapperFactory.create();
        return (FaucetClient)Feign.builder().encoder((Encoder)new JacksonEncoder(objectMapper)).decode404().errorDecoder((ErrorDecoder)new RetryStatusDecoder(RETRY_INTERVAL, 503, new Integer[0])).decoder((Decoder)new OptionalDecoder((Decoder)new JacksonDecoder(objectMapper))).target(FaucetClient.class, faucetUrl.toString());
    }

    @RequestLine(value="POST /accounts")
    @Headers(value={"Accept: application/json", "Content-Type: application/json"})
    public FaucetAccountResponse fundAccount(FundAccountRequest var1);
}

