/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client.faucet;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.client.faucet.FaucetAccount;
import org.xrpl.xrpl4j.model.transactions.Address;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FaucetAccount", generator="Immutables")
@Immutable
public final class ImmutableFaucetAccount
implements FaucetAccount {
    private final String xAddress;
    private final Address classicAddress;
    private final Address address;
    @Nullable
    private final String secret;

    private ImmutableFaucetAccount(String xAddress, Address classicAddress, Address address, @Nullable String secret) {
        this.xAddress = xAddress;
        this.classicAddress = classicAddress;
        this.address = address;
        this.secret = secret;
    }

    @Override
    @JsonProperty(value="xAddress")
    public String xAddress() {
        return this.xAddress;
    }

    @Override
    @JsonProperty(value="classicAddress")
    public Address classicAddress() {
        return this.classicAddress;
    }

    @Override
    @JsonProperty(value="address")
    public Address address() {
        return this.address;
    }

    @Override
    @JsonProperty(value="secret")
    public Optional<String> secret() {
        return Optional.ofNullable(this.secret);
    }

    public final ImmutableFaucetAccount withXAddress(String value) {
        String newValue = Objects.requireNonNull(value, "xAddress");
        if (this.xAddress.equals(newValue)) {
            return this;
        }
        return new ImmutableFaucetAccount(newValue, this.classicAddress, this.address, this.secret);
    }

    public final ImmutableFaucetAccount withClassicAddress(Address value) {
        if (this.classicAddress == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "classicAddress");
        return new ImmutableFaucetAccount(this.xAddress, newValue, this.address, this.secret);
    }

    public final ImmutableFaucetAccount withAddress(Address value) {
        if (this.address == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "address");
        return new ImmutableFaucetAccount(this.xAddress, this.classicAddress, newValue, this.secret);
    }

    public final ImmutableFaucetAccount withSecret(String value) {
        String newValue = Objects.requireNonNull(value, "secret");
        if (Objects.equals(this.secret, newValue)) {
            return this;
        }
        return new ImmutableFaucetAccount(this.xAddress, this.classicAddress, this.address, newValue);
    }

    public final ImmutableFaucetAccount withSecret(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.secret, value)) {
            return this;
        }
        return new ImmutableFaucetAccount(this.xAddress, this.classicAddress, this.address, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFaucetAccount && this.equalTo(0, (ImmutableFaucetAccount)another);
    }

    private boolean equalTo(int synthetic, ImmutableFaucetAccount another) {
        return this.xAddress.equals(another.xAddress) && this.classicAddress.equals((Object)another.classicAddress) && this.address.equals((Object)another.address) && Objects.equals(this.secret, another.secret);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.xAddress.hashCode();
        h += (h << 5) + this.classicAddress.hashCode();
        h += (h << 5) + this.address.hashCode();
        h += (h << 5) + Objects.hashCode(this.secret);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FaucetAccount").omitNullValues().add("xAddress", (Object)this.xAddress).add("classicAddress", (Object)this.classicAddress).add("address", (Object)this.address).add("secret", (Object)this.secret).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFaucetAccount fromJson(Json json) {
        Builder builder = ImmutableFaucetAccount.builder();
        if (json.xAddress != null) {
            builder.xAddress(json.xAddress);
        }
        if (json.classicAddress != null) {
            builder.classicAddress(json.classicAddress);
        }
        if (json.address != null) {
            builder.address(json.address);
        }
        if (json.secret != null) {
            builder.secret(json.secret);
        }
        return builder.build();
    }

    public static ImmutableFaucetAccount copyOf(FaucetAccount instance) {
        if (instance instanceof ImmutableFaucetAccount) {
            return (ImmutableFaucetAccount)instance;
        }
        return ImmutableFaucetAccount.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FaucetAccount", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_X_ADDRESS = 1L;
        private static final long INIT_BIT_CLASSIC_ADDRESS = 2L;
        private static final long INIT_BIT_ADDRESS = 4L;
        private long initBits = 7L;
        @Nullable
        private String xAddress;
        @Nullable
        private Address classicAddress;
        @Nullable
        private Address address;
        @Nullable
        private String secret;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FaucetAccount instance) {
            Objects.requireNonNull(instance, "instance");
            this.xAddress(instance.xAddress());
            this.classicAddress(instance.classicAddress());
            this.address(instance.address());
            Optional<String> secretOptional = instance.secret();
            if (secretOptional.isPresent()) {
                this.secret(secretOptional);
            }
            return this;
        }

        @JsonProperty(value="xAddress")
        @CanIgnoreReturnValue
        public final Builder xAddress(String xAddress) {
            this.xAddress = Objects.requireNonNull(xAddress, "xAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="classicAddress")
        @CanIgnoreReturnValue
        public final Builder classicAddress(Address classicAddress) {
            this.classicAddress = Objects.requireNonNull(classicAddress, "classicAddress");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="address")
        @CanIgnoreReturnValue
        public final Builder address(Address address) {
            this.address = Objects.requireNonNull(address, "address");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder secret(String secret) {
            this.secret = Objects.requireNonNull(secret, "secret");
            return this;
        }

        @JsonProperty(value="secret")
        @CanIgnoreReturnValue
        public final Builder secret(Optional<String> secret) {
            this.secret = secret.orElse(null);
            return this;
        }

        public ImmutableFaucetAccount build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFaucetAccount(this.xAddress, this.classicAddress, this.address, this.secret);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("xAddress");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("classicAddress");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("address");
            }
            return "Cannot build FaucetAccount, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FaucetAccount", generator="Immutables")
    static final class Json
    implements FaucetAccount {
        @Nullable
        String xAddress;
        @Nullable
        Address classicAddress;
        @Nullable
        Address address;
        @Nullable
        Optional<String> secret = Optional.empty();

        Json() {
        }

        @JsonProperty(value="xAddress")
        public void setXAddress(String xAddress) {
            this.xAddress = xAddress;
        }

        @JsonProperty(value="classicAddress")
        public void setClassicAddress(Address classicAddress) {
            this.classicAddress = classicAddress;
        }

        @JsonProperty(value="address")
        public void setAddress(Address address) {
            this.address = address;
        }

        @JsonProperty(value="secret")
        public void setSecret(Optional<String> secret) {
            this.secret = secret;
        }

        @Override
        public String xAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address classicAddress() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address address() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<String> secret() {
            throw new UnsupportedOperationException();
        }
    }
}

