/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.client.faucet;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Longs;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.OptionalLong;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.client.faucet.FaucetAccount;
import org.xrpl.xrpl4j.client.faucet.FaucetAccountResponse;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="FaucetAccountResponse", generator="Immutables")
@Immutable
public final class ImmutableFaucetAccountResponse
implements FaucetAccountResponse {
    private final FaucetAccount account;
    private final long amount;
    @Nullable
    private final Long balance;

    private ImmutableFaucetAccountResponse(FaucetAccount account, long amount, @Nullable Long balance) {
        this.account = account;
        this.amount = amount;
        this.balance = balance;
    }

    @Override
    @JsonProperty(value="account")
    public FaucetAccount account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="amount")
    public long amount() {
        return this.amount;
    }

    @Override
    @JsonProperty(value="balance")
    public OptionalLong balance() {
        return this.balance != null ? OptionalLong.of(this.balance) : OptionalLong.empty();
    }

    public final ImmutableFaucetAccountResponse withAccount(FaucetAccount value) {
        if (this.account == value) {
            return this;
        }
        FaucetAccount newValue = Objects.requireNonNull(value, "account");
        return new ImmutableFaucetAccountResponse(newValue, this.amount, this.balance);
    }

    public final ImmutableFaucetAccountResponse withAmount(long value) {
        if (this.amount == value) {
            return this;
        }
        return new ImmutableFaucetAccountResponse(this.account, value, this.balance);
    }

    public final ImmutableFaucetAccountResponse withBalance(long value) {
        Long newValue = value;
        if (Objects.equals(this.balance, newValue)) {
            return this;
        }
        return new ImmutableFaucetAccountResponse(this.account, this.amount, newValue);
    }

    public final ImmutableFaucetAccountResponse withBalance(OptionalLong optional) {
        Long value;
        Long l = value = optional.isPresent() ? Long.valueOf(optional.getAsLong()) : null;
        if (Objects.equals(this.balance, value)) {
            return this;
        }
        return new ImmutableFaucetAccountResponse(this.account, this.amount, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFaucetAccountResponse && this.equalTo(0, (ImmutableFaucetAccountResponse)another);
    }

    private boolean equalTo(int synthetic, ImmutableFaucetAccountResponse another) {
        return this.account.equals(another.account) && this.amount == another.amount && Objects.equals(this.balance, another.balance);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Longs.hashCode((long)this.amount);
        h += (h << 5) + Objects.hashCode(this.balance);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"FaucetAccountResponse").omitNullValues().add("account", (Object)this.account).add("amount", this.amount).add("balance", (Object)this.balance).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableFaucetAccountResponse fromJson(Json json) {
        Builder builder = ImmutableFaucetAccountResponse.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.amountIsSet) {
            builder.amount(json.amount);
        }
        if (json.balance != null) {
            builder.balance(json.balance);
        }
        return builder.build();
    }

    public static ImmutableFaucetAccountResponse copyOf(FaucetAccountResponse instance) {
        if (instance instanceof ImmutableFaucetAccountResponse) {
            return (ImmutableFaucetAccountResponse)instance;
        }
        return ImmutableFaucetAccountResponse.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="FaucetAccountResponse", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_AMOUNT = 2L;
        private long initBits = 3L;
        @Nullable
        private FaucetAccount account;
        private long amount;
        @Nullable
        private Long balance;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(FaucetAccountResponse instance) {
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            this.amount(instance.amount());
            OptionalLong balanceOptional = instance.balance();
            if (balanceOptional.isPresent()) {
                this.balance(balanceOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(FaucetAccount account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="amount")
        @CanIgnoreReturnValue
        public final Builder amount(long amount) {
            this.amount = amount;
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder balance(long balance) {
            this.balance = balance;
            return this;
        }

        @JsonProperty(value="balance")
        @CanIgnoreReturnValue
        public final Builder balance(OptionalLong balance) {
            this.balance = balance.isPresent() ? Long.valueOf(balance.getAsLong()) : null;
            return this;
        }

        public ImmutableFaucetAccountResponse build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFaucetAccountResponse(this.account, this.amount, this.balance);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("amount");
            }
            return "Cannot build FaucetAccountResponse, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="FaucetAccountResponse", generator="Immutables")
    static final class Json
    implements FaucetAccountResponse {
        @Nullable
        FaucetAccount account;
        long amount;
        boolean amountIsSet;
        @Nullable
        OptionalLong balance = OptionalLong.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(FaucetAccount account) {
            this.account = account;
        }

        @JsonProperty(value="amount")
        public void setAmount(long amount) {
            this.amount = amount;
            this.amountIsSet = true;
        }

        @JsonProperty(value="balance")
        public void setBalance(OptionalLong balance) {
            this.balance = balance;
        }

        @Override
        public FaucetAccount account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long amount() {
            throw new UnsupportedOperationException();
        }

        @Override
        public OptionalLong balance() {
            throw new UnsupportedOperationException();
        }
    }
}

