/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountCurrenciesRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountCurrenciesRequestParams
implements AccountCurrenciesRequestParams {
    private final Address account;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final LedgerSpecifier ledgerSpecifier;
    private final transient boolean strict;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountCurrenciesRequestParams(Builder builder) {
        this.account = builder.account;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        if (builder.ledgerSpecifier != null) {
            this.initShim.ledgerSpecifier(builder.ledgerSpecifier);
        }
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.strict = this.initShim.strict();
        this.initShim = null;
    }

    private ImmutableAccountCurrenciesRequestParams(Address account, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, LedgerSpecifier ledgerSpecifier) {
        this.account = account;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.initShim.ledgerSpecifier(ledgerSpecifier);
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.strict = this.initShim.strict();
        this.initShim = null;
    }

    private LedgerSpecifier ledgerSpecifierInitialize() {
        return AccountCurrenciesRequestParams.super.ledgerSpecifier();
    }

    private boolean strictInitialize() {
        return AccountCurrenciesRequestParams.super.strict();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledgerHash")
    @JsonIgnore
    @Deprecated
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledgerIndex")
    @JsonIgnore
    @Deprecated
    @Nullable
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerSpecifier() : this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="strict")
    public boolean strict() {
        InitShim shim = this.initShim;
        return shim != null ? shim.strict() : this.strict;
    }

    public final ImmutableAccountCurrenciesRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountCurrenciesRequestParams(newValue, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier);
    }

    @Deprecated
    public final ImmutableAccountCurrenciesRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountCurrenciesRequestParams(this.account, newValue, this.ledgerIndex, this.ledgerSpecifier);
    }

    @Deprecated
    public final ImmutableAccountCurrenciesRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountCurrenciesRequestParams(this.account, value, this.ledgerIndex, this.ledgerSpecifier);
    }

    @Deprecated
    public final ImmutableAccountCurrenciesRequestParams withLedgerIndex(@Nullable LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountCurrenciesRequestParams(this.account, this.ledgerHash, value, this.ledgerSpecifier);
    }

    public final ImmutableAccountCurrenciesRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableAccountCurrenciesRequestParams(this.account, this.ledgerHash, this.ledgerIndex, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountCurrenciesRequestParams && this.equalTo((ImmutableAccountCurrenciesRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountCurrenciesRequestParams another) {
        return this.account.equals(another.account) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && this.strict == another.strict;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.strict);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountCurrenciesRequestParams").omitNullValues().add("account", (Object)this.account).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("strict", this.strict).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountCurrenciesRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountCurrenciesRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        return builder.build();
    }

    public static ImmutableAccountCurrenciesRequestParams copyOf(AccountCurrenciesRequestParams instance) {
        if (instance instanceof ImmutableAccountCurrenciesRequestParams) {
            return (ImmutableAccountCurrenciesRequestParams)instance;
        }
        return ImmutableAccountCurrenciesRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private long initBits = 1L;
        @Nullable
        private Address account;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountCurrenciesRequestParams instance) {
            LedgerIndex ledgerIndexValue;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((ledgerIndexValue = instance.ledgerIndex()) != null) {
                this.ledgerIndex(ledgerIndexValue);
            }
            this.ledgerSpecifier(instance.ledgerSpecifier());
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        public ImmutableAccountCurrenciesRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountCurrenciesRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountCurrenciesRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
    static final class Json
    implements AccountCurrenciesRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        LedgerSpecifier ledgerSpecifier;

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        public void setLedgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean strict() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountCurrenciesRequestParams", generator="Immutables")
    private final class InitShim {
        private byte ledgerSpecifierBuildStage = 0;
        private LedgerSpecifier ledgerSpecifier;
        private byte strictBuildStage = 0;
        private boolean strict;

        private InitShim() {
        }

        LedgerSpecifier ledgerSpecifier() {
            if (this.ledgerSpecifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerSpecifierBuildStage == 0) {
                this.ledgerSpecifierBuildStage = (byte)-1;
                this.ledgerSpecifier = Objects.requireNonNull(ImmutableAccountCurrenciesRequestParams.this.ledgerSpecifierInitialize(), "ledgerSpecifier");
                this.ledgerSpecifierBuildStage = 1;
            }
            return this.ledgerSpecifier;
        }

        void ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
            this.ledgerSpecifierBuildStage = 1;
        }

        boolean strict() {
            if (this.strictBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.strictBuildStage == 0) {
                this.strictBuildStage = (byte)-1;
                this.strict = ImmutableAccountCurrenciesRequestParams.this.strictInitialize();
                this.strictBuildStage = 1;
            }
            return this.strict;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerSpecifierBuildStage == -1) {
                attributes.add("ledgerSpecifier");
            }
            if (this.strictBuildStage == -1) {
                attributes.add("strict");
            }
            return "Cannot build AccountCurrenciesRequestParams, attribute initializers form cycle " + attributes;
        }
    }
}

