/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountOffersRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountOffersRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountOffersRequestParams
implements AccountOffersRequestParams {
    private final Address account;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final LedgerSpecifier ledgerSpecifier;
    private final transient boolean strict;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountOffersRequestParams(Builder builder) {
        this.account = builder.account;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.limit = builder.limit;
        this.marker = builder.marker;
        if (builder.ledgerSpecifier != null) {
            this.initShim.ledgerSpecifier(builder.ledgerSpecifier);
        }
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.strict = this.initShim.strict();
        this.initShim = null;
    }

    private ImmutableAccountOffersRequestParams(Address account, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, LedgerSpecifier ledgerSpecifier, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.initShim.ledgerSpecifier(ledgerSpecifier);
        this.limit = limit;
        this.marker = marker;
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.strict = this.initShim.strict();
        this.initShim = null;
    }

    private LedgerSpecifier ledgerSpecifierInitialize() {
        return AccountOffersRequestParams.super.ledgerSpecifier();
    }

    private boolean strictInitialize() {
        return AccountOffersRequestParams.super.strict();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledgerHash")
    @JsonIgnore
    @Deprecated
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledgerIndex")
    @JsonIgnore
    @Deprecated
    @Nullable
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public LedgerSpecifier ledgerSpecifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerSpecifier() : this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="strict")
    public boolean strict() {
        InitShim shim = this.initShim;
        return shim != null ? shim.strict() : this.strict;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountOffersRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountOffersRequestParams(newValue, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountOffersRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, newValue, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountOffersRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, value, this.ledgerIndex, this.ledgerSpecifier, this.limit, this.marker);
    }

    @Deprecated
    public final ImmutableAccountOffersRequestParams withLedgerIndex(@Nullable LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, this.ledgerHash, value, this.ledgerSpecifier, this.limit, this.marker);
    }

    public final ImmutableAccountOffersRequestParams withLedgerSpecifier(LedgerSpecifier value) {
        if (this.ledgerSpecifier == value) {
            return this;
        }
        LedgerSpecifier newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        return new ImmutableAccountOffersRequestParams(this.account, this.ledgerHash, this.ledgerIndex, newValue, this.limit, this.marker);
    }

    public final ImmutableAccountOffersRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, newValue, this.marker);
    }

    public final ImmutableAccountOffersRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, value, this.marker);
    }

    public final ImmutableAccountOffersRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, newValue);
    }

    public final ImmutableAccountOffersRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountOffersRequestParams(this.account, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.limit, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountOffersRequestParams && this.equalTo((ImmutableAccountOffersRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountOffersRequestParams another) {
        return this.account.equals(another.account) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && this.strict == another.strict && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.strict);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountOffersRequestParams").omitNullValues().add("account", (Object)this.account).add("ledgerSpecifier", (Object)this.ledgerSpecifier).add("strict", this.strict).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountOffersRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountOffersRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    public static ImmutableAccountOffersRequestParams copyOf(AccountOffersRequestParams instance) {
        if (instance instanceof ImmutableAccountOffersRequestParams) {
            return (ImmutableAccountOffersRequestParams)instance;
        }
        return ImmutableAccountOffersRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountOffersRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private long initBits = 1L;
        @Nullable
        private Address account;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private LedgerSpecifier ledgerSpecifier;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountOffersRequestParams instance) {
            Optional<Marker> markerOptional;
            LedgerIndex ledgerIndexValue;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<Hash256> ledgerHashOptional = instance.ledgerHash();
            if (ledgerHashOptional.isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((ledgerIndexValue = instance.ledgerIndex()) != null) {
                this.ledgerIndex(ledgerIndexValue);
            }
            this.ledgerSpecifier(instance.ledgerSpecifier());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountOffersRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountOffersRequestParams(this);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountOffersRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountOffersRequestParams", generator="Immutables")
    static final class Json
    implements AccountOffersRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        LedgerIndex ledgerIndex;
        @Nullable
        LedgerSpecifier ledgerSpecifier;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        public void setLedgerIndex(@Nullable LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerSpecifier ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean strict() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountOffersRequestParams", generator="Immutables")
    private final class InitShim {
        private byte ledgerSpecifierBuildStage = 0;
        private LedgerSpecifier ledgerSpecifier;
        private byte strictBuildStage = 0;
        private boolean strict;

        private InitShim() {
        }

        LedgerSpecifier ledgerSpecifier() {
            if (this.ledgerSpecifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerSpecifierBuildStage == 0) {
                this.ledgerSpecifierBuildStage = (byte)-1;
                this.ledgerSpecifier = Objects.requireNonNull(ImmutableAccountOffersRequestParams.this.ledgerSpecifierInitialize(), "ledgerSpecifier");
                this.ledgerSpecifierBuildStage = 1;
            }
            return this.ledgerSpecifier;
        }

        void ledgerSpecifier(LedgerSpecifier ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
            this.ledgerSpecifierBuildStage = 1;
        }

        boolean strict() {
            if (this.strictBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.strictBuildStage == 0) {
                this.strictBuildStage = (byte)-1;
                this.strict = ImmutableAccountOffersRequestParams.this.strictInitialize();
                this.strictBuildStage = 1;
            }
            return this.strict;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerSpecifierBuildStage == -1) {
                attributes.add("ledgerSpecifier");
            }
            if (this.strictBuildStage == -1) {
                attributes.add("strict");
            }
            return "Cannot build AccountOffersRequestParams, attribute initializers form cycle " + attributes;
        }
    }
}

