/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexBound;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Marker;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountTransactionsRequestParams", generator="Immutables")
@Immutable
public final class ImmutableAccountTransactionsRequestParams
implements AccountTransactionsRequestParams {
    private final Address account;
    @Nullable
    private final LedgerIndex ledgerIndexMin;
    @Nullable
    private final LedgerIndex ledgerIndexMax;
    @Nullable
    private final LedgerIndexBound ledgerIndexMinimum;
    @Nullable
    private final LedgerIndexBound ledgerIndexMaximum;
    @Nullable
    private final Hash256 ledgerHash;
    @Nullable
    private final LedgerIndex ledgerIndex;
    private final Optional<LedgerSpecifier> ledgerSpecifier;
    private final transient boolean binary;
    private final boolean forward;
    @Nullable
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountTransactionsRequestParams(Builder builder) {
        this.account = builder.account;
        this.ledgerIndexMin = builder.ledgerIndexMin;
        this.ledgerIndexMax = builder.ledgerIndexMax;
        this.ledgerHash = builder.ledgerHash;
        this.ledgerIndex = builder.ledgerIndex;
        this.limit = builder.limit;
        this.marker = builder.marker;
        if (builder.ledgerIndexMinimumIsSet()) {
            this.initShim.ledgerIndexMinimum(builder.ledgerIndexMinimum);
        }
        if (builder.ledgerIndexMaximumIsSet()) {
            this.initShim.ledgerIndexMaximum(builder.ledgerIndexMaximum);
        }
        if (builder.ledgerSpecifier != null) {
            this.initShim.ledgerSpecifier(builder.ledgerSpecifier);
        }
        if (builder.forwardIsSet()) {
            this.initShim.forward(builder.forward);
        }
        this.ledgerIndexMinimum = this.initShim.ledgerIndexMinimum();
        this.ledgerIndexMaximum = this.initShim.ledgerIndexMaximum();
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.binary = this.initShim.binary();
        this.forward = this.initShim.forward();
        this.initShim = null;
    }

    private ImmutableAccountTransactionsRequestParams(Address account, @Nullable LedgerIndex ledgerIndexMin, @Nullable LedgerIndex ledgerIndexMax, @Nullable LedgerIndexBound ledgerIndexMinimum, @Nullable LedgerIndexBound ledgerIndexMaximum, @Nullable Hash256 ledgerHash, @Nullable LedgerIndex ledgerIndex, Optional<LedgerSpecifier> ledgerSpecifier, boolean forward, @Nullable UnsignedInteger limit, @Nullable Marker marker) {
        this.account = account;
        this.ledgerIndexMin = ledgerIndexMin;
        this.ledgerIndexMax = ledgerIndexMax;
        this.initShim.ledgerIndexMinimum(ledgerIndexMinimum);
        this.initShim.ledgerIndexMaximum(ledgerIndexMaximum);
        this.ledgerHash = ledgerHash;
        this.ledgerIndex = ledgerIndex;
        this.initShim.ledgerSpecifier(ledgerSpecifier);
        this.initShim.forward(forward);
        this.limit = limit;
        this.marker = marker;
        this.ledgerIndexMinimum = this.initShim.ledgerIndexMinimum();
        this.ledgerIndexMaximum = this.initShim.ledgerIndexMaximum();
        this.ledgerSpecifier = this.initShim.ledgerSpecifier();
        this.binary = this.initShim.binary();
        this.forward = this.initShim.forward();
        this.initShim = null;
    }

    @Nullable
    private LedgerIndexBound ledgerIndexMinimumInitialize() {
        return AccountTransactionsRequestParams.super.ledgerIndexMinimum();
    }

    @Nullable
    private LedgerIndexBound ledgerIndexMaximumInitialize() {
        return AccountTransactionsRequestParams.super.ledgerIndexMaximum();
    }

    private Optional<LedgerSpecifier> ledgerSpecifierInitialize() {
        return AccountTransactionsRequestParams.super.ledgerSpecifier();
    }

    private boolean binaryInitialize() {
        return AccountTransactionsRequestParams.super.binary();
    }

    private boolean forwardInitialize() {
        return AccountTransactionsRequestParams.super.forward();
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledgerIndexMin")
    @JsonIgnore
    @Deprecated
    public Optional<LedgerIndex> ledgerIndexMin() {
        return Optional.ofNullable(this.ledgerIndexMin);
    }

    @Override
    @JsonProperty(value="ledgerIndexMax")
    @JsonIgnore
    @Deprecated
    public Optional<LedgerIndex> ledgerIndexMax() {
        return Optional.ofNullable(this.ledgerIndexMax);
    }

    @Override
    @JsonProperty(value="ledger_index_min")
    @Nullable
    public LedgerIndexBound ledgerIndexMinimum() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerIndexMinimum() : this.ledgerIndexMinimum;
    }

    @Override
    @JsonProperty(value="ledger_index_max")
    @Nullable
    public LedgerIndexBound ledgerIndexMaximum() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerIndexMaximum() : this.ledgerIndexMaximum;
    }

    @Override
    @JsonProperty(value="ledgerHash")
    @JsonIgnore
    @Deprecated
    public Optional<Hash256> ledgerHash() {
        return Optional.ofNullable(this.ledgerHash);
    }

    @Override
    @JsonProperty(value="ledgerIndex")
    @JsonIgnore
    @Deprecated
    public Optional<LedgerIndex> ledgerIndex() {
        return Optional.ofNullable(this.ledgerIndex);
    }

    @Override
    @JsonProperty(value="ledgerSpecifier")
    @JsonUnwrapped
    public Optional<LedgerSpecifier> ledgerSpecifier() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerSpecifier() : this.ledgerSpecifier;
    }

    @Override
    @JsonProperty(value="binary")
    public boolean binary() {
        InitShim shim = this.initShim;
        return shim != null ? shim.binary() : this.binary;
    }

    @Override
    @JsonProperty(value="forward")
    public boolean forward() {
        InitShim shim = this.initShim;
        return shim != null ? shim.forward() : this.forward;
    }

    @Override
    @JsonProperty(value="limit")
    public Optional<UnsignedInteger> limit() {
        return Optional.ofNullable(this.limit);
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    public final ImmutableAccountTransactionsRequestParams withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(newValue, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerIndexMin(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndexMin");
        if (this.ledgerIndexMin == newValue) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, newValue, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerIndexMin(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndexMin == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, value, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerIndexMax(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndexMax");
        if (this.ledgerIndexMax == newValue) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, newValue, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerIndexMax(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndexMax == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, value, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withLedgerIndexMinimum(@Nullable LedgerIndexBound value) {
        if (this.ledgerIndexMinimum == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, value, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withLedgerIndexMaximum(@Nullable LedgerIndexBound value) {
        if (this.ledgerIndexMaximum == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, value, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerHash(Hash256 value) {
        Hash256 newValue = Objects.requireNonNull(value, "ledgerHash");
        if (this.ledgerHash == newValue) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, newValue, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerHash(Optional<? extends Hash256> optional) {
        Hash256 value = optional.orElse(null);
        if (this.ledgerHash == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, value, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerIndex(LedgerIndex value) {
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        if (this.ledgerIndex == newValue) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, newValue, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    @Deprecated
    public final ImmutableAccountTransactionsRequestParams withLedgerIndex(Optional<? extends LedgerIndex> optional) {
        LedgerIndex value = optional.orElse(null);
        if (this.ledgerIndex == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, value, this.ledgerSpecifier, this.forward, this.limit, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withLedgerSpecifier(Optional<LedgerSpecifier> value) {
        Optional<LedgerSpecifier> newValue = Objects.requireNonNull(value, "ledgerSpecifier");
        if (this.ledgerSpecifier.equals(newValue)) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, newValue, this.forward, this.limit, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withForward(boolean value) {
        if (this.forward == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, value, this.limit, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (Objects.equals(this.limit, newValue)) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, newValue, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withLimit(Optional<? extends UnsignedInteger> optional) {
        UnsignedInteger value = optional.orElse(null);
        if (Objects.equals(this.limit, value)) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, value, this.marker));
    }

    public final ImmutableAccountTransactionsRequestParams withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, newValue));
    }

    public final ImmutableAccountTransactionsRequestParams withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.ledgerHash, this.ledgerIndex, this.ledgerSpecifier, this.forward, this.limit, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountTransactionsRequestParams && this.equalTo((ImmutableAccountTransactionsRequestParams)another);
    }

    private boolean equalTo(ImmutableAccountTransactionsRequestParams another) {
        return this.account.equals(another.account) && Objects.equals(this.ledgerIndexMinimum, another.ledgerIndexMinimum) && Objects.equals(this.ledgerIndexMaximum, another.ledgerIndexMaximum) && this.ledgerSpecifier.equals(another.ledgerSpecifier) && this.binary == another.binary && this.forward == another.forward && Objects.equals(this.limit, another.limit) && Objects.equals(this.marker, another.marker);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + Objects.hashCode(this.ledgerIndexMinimum);
        h += (h << 5) + Objects.hashCode(this.ledgerIndexMaximum);
        h += (h << 5) + this.ledgerSpecifier.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.binary);
        h += (h << 5) + Booleans.hashCode((boolean)this.forward);
        h += (h << 5) + Objects.hashCode(this.limit);
        h += (h << 5) + Objects.hashCode(this.marker);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountTransactionsRequestParams").omitNullValues().add("account", (Object)this.account).add("ledgerIndexMinimum", (Object)this.ledgerIndexMinimum).add("ledgerIndexMaximum", (Object)this.ledgerIndexMaximum).add("ledgerSpecifier", this.ledgerSpecifier).add("binary", this.binary).add("forward", this.forward).add("limit", (Object)this.limit).add("marker", (Object)this.marker).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountTransactionsRequestParams fromJson(Json json) {
        Builder builder = ImmutableAccountTransactionsRequestParams.builder();
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerIndexMin != null) {
            builder.ledgerIndexMin(json.ledgerIndexMin);
        }
        if (json.ledgerIndexMax != null) {
            builder.ledgerIndexMax(json.ledgerIndexMax);
        }
        if (json.ledgerIndexMinimumIsSet) {
            builder.ledgerIndexMinimum(json.ledgerIndexMinimum);
        }
        if (json.ledgerIndexMaximumIsSet) {
            builder.ledgerIndexMaximum(json.ledgerIndexMaximum);
        }
        if (json.ledgerHash != null) {
            builder.ledgerHash(json.ledgerHash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        if (json.ledgerSpecifier != null) {
            builder.ledgerSpecifier(json.ledgerSpecifier);
        }
        if (json.forwardIsSet) {
            builder.forward(json.forward);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        return builder.build();
    }

    private static ImmutableAccountTransactionsRequestParams validate(ImmutableAccountTransactionsRequestParams instance) {
        instance = (ImmutableAccountTransactionsRequestParams)instance.emptyBoundedParametersIfSpecifierPresent();
        instance.validateSpecifierNotCurrentOrClosed();
        return instance;
    }

    public static ImmutableAccountTransactionsRequestParams copyOf(AccountTransactionsRequestParams instance) {
        if (instance instanceof ImmutableAccountTransactionsRequestParams) {
            return (ImmutableAccountTransactionsRequestParams)instance;
        }
        return ImmutableAccountTransactionsRequestParams.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountTransactionsRequestParams", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long OPT_BIT_LEDGER_INDEX_MINIMUM = 1L;
        private static final long OPT_BIT_LEDGER_INDEX_MAXIMUM = 2L;
        private static final long OPT_BIT_FORWARD = 4L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private Address account;
        @Nullable
        private LedgerIndex ledgerIndexMin;
        @Nullable
        private LedgerIndex ledgerIndexMax;
        @Nullable
        private LedgerIndexBound ledgerIndexMinimum;
        @Nullable
        private LedgerIndexBound ledgerIndexMaximum;
        @Nullable
        private Hash256 ledgerHash;
        @Nullable
        private LedgerIndex ledgerIndex;
        @Nullable
        private Optional<LedgerSpecifier> ledgerSpecifier;
        private boolean forward;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountTransactionsRequestParams instance) {
            Optional<Marker> markerOptional;
            Optional<LedgerIndex> ledgerIndexOptional;
            Optional<Hash256> ledgerHashOptional;
            LedgerIndexBound ledgerIndexMaximumValue;
            LedgerIndexBound ledgerIndexMinimumValue;
            Optional<LedgerIndex> ledgerIndexMaxOptional;
            Objects.requireNonNull(instance, "instance");
            this.account(instance.account());
            Optional<LedgerIndex> ledgerIndexMinOptional = instance.ledgerIndexMin();
            if (ledgerIndexMinOptional.isPresent()) {
                this.ledgerIndexMin(ledgerIndexMinOptional);
            }
            if ((ledgerIndexMaxOptional = instance.ledgerIndexMax()).isPresent()) {
                this.ledgerIndexMax(ledgerIndexMaxOptional);
            }
            if ((ledgerIndexMinimumValue = instance.ledgerIndexMinimum()) != null) {
                this.ledgerIndexMinimum(ledgerIndexMinimumValue);
            }
            if ((ledgerIndexMaximumValue = instance.ledgerIndexMaximum()) != null) {
                this.ledgerIndexMaximum(ledgerIndexMaximumValue);
            }
            if ((ledgerHashOptional = instance.ledgerHash()).isPresent()) {
                this.ledgerHash(ledgerHashOptional);
            }
            if ((ledgerIndexOptional = instance.ledgerIndex()).isPresent()) {
                this.ledgerIndex(ledgerIndexOptional);
            }
            this.ledgerSpecifier(instance.ledgerSpecifier());
            this.forward(instance.forward());
            Optional<UnsignedInteger> limitOptional = instance.limit();
            if (limitOptional.isPresent()) {
                this.limit(limitOptional);
            }
            if ((markerOptional = instance.marker()).isPresent()) {
                this.marker(markerOptional);
            }
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMin(LedgerIndex ledgerIndexMin) {
            this.ledgerIndexMin = Objects.requireNonNull(ledgerIndexMin, "ledgerIndexMin");
            return this;
        }

        @JsonProperty(value="ledgerIndexMin")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMin(Optional<? extends LedgerIndex> ledgerIndexMin) {
            this.ledgerIndexMin = ledgerIndexMin.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMax(LedgerIndex ledgerIndexMax) {
            this.ledgerIndexMax = Objects.requireNonNull(ledgerIndexMax, "ledgerIndexMax");
            return this;
        }

        @JsonProperty(value="ledgerIndexMax")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMax(Optional<? extends LedgerIndex> ledgerIndexMax) {
            this.ledgerIndexMax = ledgerIndexMax.orElse(null);
            return this;
        }

        @JsonProperty(value="ledger_index_min")
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMinimum(@Nullable LedgerIndexBound ledgerIndexMinimum) {
            this.ledgerIndexMinimum = ledgerIndexMinimum;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="ledger_index_max")
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMaximum(@Nullable LedgerIndexBound ledgerIndexMaximum) {
            this.ledgerIndexMaximum = ledgerIndexMaximum;
            this.optBits |= 2L;
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Hash256 ledgerHash) {
            this.ledgerHash = Objects.requireNonNull(ledgerHash, "ledgerHash");
            return this;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerHash(Optional<? extends Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash.orElse(null);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            return this;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndex(Optional<? extends LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex.orElse(null);
            return this;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder ledgerSpecifier(Optional<LedgerSpecifier> ledgerSpecifier) {
            this.ledgerSpecifier = Objects.requireNonNull(ledgerSpecifier, "ledgerSpecifier");
            return this;
        }

        @JsonProperty(value="forward")
        @CanIgnoreReturnValue
        public final Builder forward(boolean forward) {
            this.forward = forward;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(Optional<? extends UnsignedInteger> limit) {
            this.limit = limit.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        public ImmutableAccountTransactionsRequestParams build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableAccountTransactionsRequestParams.validate(new ImmutableAccountTransactionsRequestParams(this));
        }

        private boolean ledgerIndexMinimumIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean ledgerIndexMaximumIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean forwardIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            return "Cannot build AccountTransactionsRequestParams, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountTransactionsRequestParams", generator="Immutables")
    static final class Json
    implements AccountTransactionsRequestParams {
        @Nullable
        Address account;
        @Nullable
        Optional<LedgerIndex> ledgerIndexMin = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndexMax = Optional.empty();
        @Nullable
        LedgerIndexBound ledgerIndexMinimum;
        boolean ledgerIndexMinimumIsSet;
        @Nullable
        LedgerIndexBound ledgerIndexMaximum;
        boolean ledgerIndexMaximumIsSet;
        @Nullable
        Optional<Hash256> ledgerHash = Optional.empty();
        @Nullable
        Optional<LedgerIndex> ledgerIndex = Optional.empty();
        @Nullable
        Optional<LedgerSpecifier> ledgerSpecifier;
        boolean forward;
        boolean forwardIsSet;
        @Nullable
        Optional<UnsignedInteger> limit = Optional.empty();
        @Nullable
        Optional<Marker> marker = Optional.empty();

        Json() {
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledgerIndexMin")
        @JsonIgnore
        public void setLedgerIndexMin(Optional<LedgerIndex> ledgerIndexMin) {
            this.ledgerIndexMin = ledgerIndexMin;
        }

        @JsonProperty(value="ledgerIndexMax")
        @JsonIgnore
        public void setLedgerIndexMax(Optional<LedgerIndex> ledgerIndexMax) {
            this.ledgerIndexMax = ledgerIndexMax;
        }

        @JsonProperty(value="ledger_index_min")
        public void setLedgerIndexMinimum(@Nullable LedgerIndexBound ledgerIndexMinimum) {
            this.ledgerIndexMinimum = ledgerIndexMinimum;
            this.ledgerIndexMinimumIsSet = true;
        }

        @JsonProperty(value="ledger_index_max")
        public void setLedgerIndexMaximum(@Nullable LedgerIndexBound ledgerIndexMaximum) {
            this.ledgerIndexMaximum = ledgerIndexMaximum;
            this.ledgerIndexMaximumIsSet = true;
        }

        @JsonProperty(value="ledgerHash")
        @JsonIgnore
        public void setLedgerHash(Optional<Hash256> ledgerHash) {
            this.ledgerHash = ledgerHash;
        }

        @JsonProperty(value="ledgerIndex")
        @JsonIgnore
        public void setLedgerIndex(Optional<LedgerIndex> ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @JsonProperty(value="ledgerSpecifier")
        @JsonUnwrapped
        public void setLedgerSpecifier(Optional<LedgerSpecifier> ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
        }

        @JsonProperty(value="forward")
        public void setForward(boolean forward) {
            this.forward = forward;
            this.forwardIsSet = true;
        }

        @JsonProperty(value="limit")
        public void setLimit(Optional<UnsignedInteger> limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndexMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndexMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndexBound ledgerIndexMinimum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndexBound ledgerIndexMaximum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Hash256> ledgerHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerIndex> ledgerIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<LedgerSpecifier> ledgerSpecifier() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public boolean binary() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean forward() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<UnsignedInteger> limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountTransactionsRequestParams", generator="Immutables")
    private final class InitShim {
        private byte ledgerIndexMinimumBuildStage = 0;
        private LedgerIndexBound ledgerIndexMinimum;
        private byte ledgerIndexMaximumBuildStage = 0;
        private LedgerIndexBound ledgerIndexMaximum;
        private byte ledgerSpecifierBuildStage = 0;
        private Optional<LedgerSpecifier> ledgerSpecifier;
        private byte binaryBuildStage = 0;
        private boolean binary;
        private byte forwardBuildStage = 0;
        private boolean forward;

        private InitShim() {
        }

        LedgerIndexBound ledgerIndexMinimum() {
            if (this.ledgerIndexMinimumBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerIndexMinimumBuildStage == 0) {
                this.ledgerIndexMinimumBuildStage = (byte)-1;
                this.ledgerIndexMinimum = ImmutableAccountTransactionsRequestParams.this.ledgerIndexMinimumInitialize();
                this.ledgerIndexMinimumBuildStage = 1;
            }
            return this.ledgerIndexMinimum;
        }

        void ledgerIndexMinimum(LedgerIndexBound ledgerIndexMinimum) {
            this.ledgerIndexMinimum = ledgerIndexMinimum;
            this.ledgerIndexMinimumBuildStage = 1;
        }

        LedgerIndexBound ledgerIndexMaximum() {
            if (this.ledgerIndexMaximumBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerIndexMaximumBuildStage == 0) {
                this.ledgerIndexMaximumBuildStage = (byte)-1;
                this.ledgerIndexMaximum = ImmutableAccountTransactionsRequestParams.this.ledgerIndexMaximumInitialize();
                this.ledgerIndexMaximumBuildStage = 1;
            }
            return this.ledgerIndexMaximum;
        }

        void ledgerIndexMaximum(LedgerIndexBound ledgerIndexMaximum) {
            this.ledgerIndexMaximum = ledgerIndexMaximum;
            this.ledgerIndexMaximumBuildStage = 1;
        }

        Optional<LedgerSpecifier> ledgerSpecifier() {
            if (this.ledgerSpecifierBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerSpecifierBuildStage == 0) {
                this.ledgerSpecifierBuildStage = (byte)-1;
                this.ledgerSpecifier = Objects.requireNonNull(ImmutableAccountTransactionsRequestParams.this.ledgerSpecifierInitialize(), "ledgerSpecifier");
                this.ledgerSpecifierBuildStage = 1;
            }
            return this.ledgerSpecifier;
        }

        void ledgerSpecifier(Optional<LedgerSpecifier> ledgerSpecifier) {
            this.ledgerSpecifier = ledgerSpecifier;
            this.ledgerSpecifierBuildStage = 1;
        }

        boolean binary() {
            if (this.binaryBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.binaryBuildStage == 0) {
                this.binaryBuildStage = (byte)-1;
                this.binary = ImmutableAccountTransactionsRequestParams.this.binaryInitialize();
                this.binaryBuildStage = 1;
            }
            return this.binary;
        }

        boolean forward() {
            if (this.forwardBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.forwardBuildStage == 0) {
                this.forwardBuildStage = (byte)-1;
                this.forward = ImmutableAccountTransactionsRequestParams.this.forwardInitialize();
                this.forwardBuildStage = 1;
            }
            return this.forward;
        }

        void forward(boolean forward) {
            this.forward = forward;
            this.forwardBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerIndexMinimumBuildStage == -1) {
                attributes.add("ledgerIndexMinimum");
            }
            if (this.ledgerIndexMaximumBuildStage == -1) {
                attributes.add("ledgerIndexMaximum");
            }
            if (this.ledgerSpecifierBuildStage == -1) {
                attributes.add("ledgerSpecifier");
            }
            if (this.binaryBuildStage == -1) {
                attributes.add("binary");
            }
            if (this.forwardBuildStage == -1) {
                attributes.add("forward");
            }
            return "Cannot build AccountTransactionsRequestParams, attribute initializers form cycle " + attributes;
        }
    }
}

