/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsTransactionResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerIndexBound;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.Marker;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountTransactionsResult", generator="Immutables")
@Immutable
public final class ImmutableAccountTransactionsResult
implements AccountTransactionsResult {
    @Nullable
    private final String status;
    private final Address account;
    private final LedgerIndex ledgerIndexMin;
    private final LedgerIndex ledgerIndexMax;
    private final LedgerIndexBound ledgerIndexMinimum;
    private final LedgerIndexBound ledgerIndexMaximum;
    private final UnsignedInteger limit;
    @Nullable
    private final Marker marker;
    private final ImmutableList<AccountTransactionsTransactionResult<? extends Transaction>> transactions;
    private final boolean validated;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountTransactionsResult(Builder builder) {
        this.status = builder.status;
        this.account = builder.account;
        this.ledgerIndexMinimum = builder.ledgerIndexMinimum;
        this.ledgerIndexMaximum = builder.ledgerIndexMaximum;
        this.limit = builder.limit;
        this.marker = builder.marker;
        this.transactions = builder.transactions.build();
        if (builder.ledgerIndexMin != null) {
            this.initShim.ledgerIndexMin(builder.ledgerIndexMin);
        }
        if (builder.ledgerIndexMax != null) {
            this.initShim.ledgerIndexMax(builder.ledgerIndexMax);
        }
        if (builder.validatedIsSet()) {
            this.initShim.validated(builder.validated);
        }
        this.ledgerIndexMin = this.initShim.ledgerIndexMin();
        this.ledgerIndexMax = this.initShim.ledgerIndexMax();
        this.validated = this.initShim.validated();
        this.initShim = null;
    }

    private ImmutableAccountTransactionsResult(@Nullable String status, Address account, LedgerIndex ledgerIndexMin, LedgerIndex ledgerIndexMax, LedgerIndexBound ledgerIndexMinimum, LedgerIndexBound ledgerIndexMaximum, UnsignedInteger limit, @Nullable Marker marker, ImmutableList<AccountTransactionsTransactionResult<? extends Transaction>> transactions, boolean validated) {
        this.status = status;
        this.account = account;
        this.ledgerIndexMin = ledgerIndexMin;
        this.ledgerIndexMax = ledgerIndexMax;
        this.ledgerIndexMinimum = ledgerIndexMinimum;
        this.ledgerIndexMaximum = ledgerIndexMaximum;
        this.limit = limit;
        this.marker = marker;
        this.transactions = transactions;
        this.validated = validated;
        this.initShim = null;
    }

    private LedgerIndex ledgerIndexMinInitialize() {
        return AccountTransactionsResult.super.ledgerIndexMin();
    }

    private LedgerIndex ledgerIndexMaxInitialize() {
        return AccountTransactionsResult.super.ledgerIndexMax();
    }

    private boolean validatedInitialize() {
        return AccountTransactionsResult.super.validated();
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="account")
    public Address account() {
        return this.account;
    }

    @Override
    @JsonProperty(value="ledgerIndexMin")
    @JsonIgnore
    @Deprecated
    public LedgerIndex ledgerIndexMin() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerIndexMin() : this.ledgerIndexMin;
    }

    @Override
    @JsonProperty(value="ledgerIndexMax")
    @JsonIgnore
    @Deprecated
    public LedgerIndex ledgerIndexMax() {
        InitShim shim = this.initShim;
        return shim != null ? shim.ledgerIndexMax() : this.ledgerIndexMax;
    }

    @Override
    @JsonProperty(value="ledger_index_min")
    public LedgerIndexBound ledgerIndexMinimum() {
        return this.ledgerIndexMinimum;
    }

    @Override
    @JsonProperty(value="ledger_index_max")
    public LedgerIndexBound ledgerIndexMaximum() {
        return this.ledgerIndexMaximum;
    }

    @Override
    @JsonProperty(value="limit")
    public UnsignedInteger limit() {
        return this.limit;
    }

    @Override
    @JsonProperty(value="marker")
    public Optional<Marker> marker() {
        return Optional.ofNullable(this.marker);
    }

    @JsonProperty(value="transactions")
    public ImmutableList<AccountTransactionsTransactionResult<? extends Transaction>> transactions() {
        return this.transactions;
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validated() : this.validated;
    }

    public final ImmutableAccountTransactionsResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountTransactionsResult(newValue, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountTransactionsResult(value, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withAccount(Address value) {
        if (this.account == value) {
            return this;
        }
        Address newValue = Objects.requireNonNull(value, "account");
        return new ImmutableAccountTransactionsResult(this.status, newValue, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, this.validated);
    }

    @Deprecated
    public final ImmutableAccountTransactionsResult withLedgerIndexMin(LedgerIndex value) {
        if (this.ledgerIndexMin == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndexMin");
        return new ImmutableAccountTransactionsResult(this.status, this.account, newValue, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, this.validated);
    }

    @Deprecated
    public final ImmutableAccountTransactionsResult withLedgerIndexMax(LedgerIndex value) {
        if (this.ledgerIndexMax == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndexMax");
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, newValue, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withLedgerIndexMinimum(LedgerIndexBound value) {
        if (this.ledgerIndexMinimum == value) {
            return this;
        }
        LedgerIndexBound newValue = Objects.requireNonNull(value, "ledgerIndexMinimum");
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, newValue, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withLedgerIndexMaximum(LedgerIndexBound value) {
        if (this.ledgerIndexMaximum == value) {
            return this;
        }
        LedgerIndexBound newValue = Objects.requireNonNull(value, "ledgerIndexMaximum");
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, newValue, this.limit, this.marker, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withLimit(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "limit");
        if (this.limit.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, newValue, this.marker, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withMarker(Marker value) {
        Marker newValue = Objects.requireNonNull(value, "marker");
        if (this.marker == newValue) {
            return this;
        }
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, newValue, this.transactions, this.validated);
    }

    public final ImmutableAccountTransactionsResult withMarker(Optional<? extends Marker> optional) {
        Marker value = optional.orElse(null);
        if (this.marker == value) {
            return this;
        }
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, value, this.transactions, this.validated);
    }

    @SafeVarargs
    public final ImmutableAccountTransactionsResult withTransactions(AccountTransactionsTransactionResult<? extends Transaction> ... elements) {
        ImmutableList newValue = ImmutableList.copyOf((Object[])elements);
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, (ImmutableList<AccountTransactionsTransactionResult<? extends Transaction>>)newValue, this.validated);
    }

    public final ImmutableAccountTransactionsResult withTransactions(Iterable<? extends AccountTransactionsTransactionResult<? extends Transaction>> elements) {
        if (this.transactions == elements) {
            return this;
        }
        ImmutableList newValue = ImmutableList.copyOf(elements);
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, (ImmutableList<AccountTransactionsTransactionResult<? extends Transaction>>)newValue, this.validated);
    }

    public final ImmutableAccountTransactionsResult withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountTransactionsResult(this.status, this.account, this.ledgerIndexMin, this.ledgerIndexMax, this.ledgerIndexMinimum, this.ledgerIndexMaximum, this.limit, this.marker, this.transactions, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountTransactionsResult && this.equalTo((ImmutableAccountTransactionsResult)another);
    }

    private boolean equalTo(ImmutableAccountTransactionsResult another) {
        return Objects.equals(this.status, another.status) && this.account.equals(another.account) && this.ledgerIndexMinimum.equals(another.ledgerIndexMinimum) && this.ledgerIndexMaximum.equals(another.ledgerIndexMaximum) && this.limit.equals((Object)another.limit) && Objects.equals(this.marker, another.marker) && this.transactions.equals(another.transactions) && this.validated == another.validated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.account.hashCode();
        h += (h << 5) + this.ledgerIndexMinimum.hashCode();
        h += (h << 5) + this.ledgerIndexMaximum.hashCode();
        h += (h << 5) + this.limit.hashCode();
        h += (h << 5) + Objects.hashCode(this.marker);
        h += (h << 5) + this.transactions.hashCode();
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountTransactionsResult").omitNullValues().add("status", (Object)this.status).add("account", (Object)this.account).add("ledgerIndexMinimum", (Object)this.ledgerIndexMinimum).add("ledgerIndexMaximum", (Object)this.ledgerIndexMaximum).add("limit", (Object)this.limit).add("marker", (Object)this.marker).add("transactions", this.transactions).add("validated", this.validated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAccountTransactionsResult fromJson(Json json) {
        Builder builder = ImmutableAccountTransactionsResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.account != null) {
            builder.account(json.account);
        }
        if (json.ledgerIndexMin != null) {
            builder.ledgerIndexMin(json.ledgerIndexMin);
        }
        if (json.ledgerIndexMax != null) {
            builder.ledgerIndexMax(json.ledgerIndexMax);
        }
        if (json.ledgerIndexMinimum != null) {
            builder.ledgerIndexMinimum(json.ledgerIndexMinimum);
        }
        if (json.ledgerIndexMaximum != null) {
            builder.ledgerIndexMaximum(json.ledgerIndexMaximum);
        }
        if (json.limit != null) {
            builder.limit(json.limit);
        }
        if (json.marker != null) {
            builder.marker(json.marker);
        }
        if (json.transactions != null) {
            builder.addAllTransactions(json.transactions);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        return builder.build();
    }

    public static ImmutableAccountTransactionsResult copyOf(AccountTransactionsResult instance) {
        if (instance instanceof ImmutableAccountTransactionsResult) {
            return (ImmutableAccountTransactionsResult)instance;
        }
        return ImmutableAccountTransactionsResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AccountTransactionsResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ACCOUNT = 1L;
        private static final long INIT_BIT_LEDGER_INDEX_MINIMUM = 2L;
        private static final long INIT_BIT_LEDGER_INDEX_MAXIMUM = 4L;
        private static final long INIT_BIT_LIMIT = 8L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 15L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private Address account;
        @Nullable
        private LedgerIndex ledgerIndexMin;
        @Nullable
        private LedgerIndex ledgerIndexMax;
        @Nullable
        private LedgerIndexBound ledgerIndexMinimum;
        @Nullable
        private LedgerIndexBound ledgerIndexMaximum;
        @Nullable
        private UnsignedInteger limit;
        @Nullable
        private Marker marker;
        private ImmutableList.Builder<AccountTransactionsTransactionResult<? extends Transaction>> transactions = ImmutableList.builder();
        private boolean validated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(AccountTransactionsResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            XrplResult instance;
            Optional<String> statusOptional;
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
            if (object instanceof AccountTransactionsResult) {
                instance = (AccountTransactionsResult)object;
                this.ledgerIndexMin(instance.ledgerIndexMin());
                this.ledgerIndexMinimum(instance.ledgerIndexMinimum());
                this.validated(instance.validated());
                this.ledgerIndexMax(instance.ledgerIndexMax());
                Optional<Marker> markerOptional = instance.marker();
                if (markerOptional.isPresent()) {
                    this.marker(markerOptional);
                }
                this.limit(instance.limit());
                this.addAllTransactions(instance.transactions());
                this.account(instance.account());
                this.ledgerIndexMaximum(instance.ledgerIndexMaximum());
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="account")
        @CanIgnoreReturnValue
        public final Builder account(Address account) {
            this.account = Objects.requireNonNull(account, "account");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="ledgerIndexMin")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMin(LedgerIndex ledgerIndexMin) {
            this.ledgerIndexMin = Objects.requireNonNull(ledgerIndexMin, "ledgerIndexMin");
            return this;
        }

        @JsonProperty(value="ledgerIndexMax")
        @JsonIgnore
        @Deprecated
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMax(LedgerIndex ledgerIndexMax) {
            this.ledgerIndexMax = Objects.requireNonNull(ledgerIndexMax, "ledgerIndexMax");
            return this;
        }

        @JsonProperty(value="ledger_index_min")
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMinimum(LedgerIndexBound ledgerIndexMinimum) {
            this.ledgerIndexMinimum = Objects.requireNonNull(ledgerIndexMinimum, "ledgerIndexMinimum");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ledger_index_max")
        @CanIgnoreReturnValue
        public final Builder ledgerIndexMaximum(LedgerIndexBound ledgerIndexMaximum) {
            this.ledgerIndexMaximum = Objects.requireNonNull(ledgerIndexMaximum, "ledgerIndexMaximum");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @JsonProperty(value="limit")
        @CanIgnoreReturnValue
        public final Builder limit(UnsignedInteger limit) {
            this.limit = Objects.requireNonNull(limit, "limit");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder marker(Marker marker) {
            this.marker = Objects.requireNonNull(marker, "marker");
            return this;
        }

        @JsonProperty(value="marker")
        @CanIgnoreReturnValue
        public final Builder marker(Optional<? extends Marker> marker) {
            this.marker = marker.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addTransactions(AccountTransactionsTransactionResult<? extends Transaction> element) {
            this.transactions.add(element);
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addTransactions(AccountTransactionsTransactionResult<? extends Transaction> ... elements) {
            this.transactions.add((Object[])elements);
            return this;
        }

        @JsonProperty(value="transactions")
        @CanIgnoreReturnValue
        public final Builder transactions(Iterable<? extends AccountTransactionsTransactionResult<? extends Transaction>> elements) {
            this.transactions = ImmutableList.builder();
            return this.addAllTransactions(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllTransactions(Iterable<? extends AccountTransactionsTransactionResult<? extends Transaction>> elements) {
            this.transactions.addAll(elements);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAccountTransactionsResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountTransactionsResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("account");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("ledgerIndexMinimum");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ledgerIndexMaximum");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("limit");
            }
            return "Cannot build AccountTransactionsResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountTransactionsResult", generator="Immutables")
    static final class Json
    implements AccountTransactionsResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        Address account;
        @Nullable
        LedgerIndex ledgerIndexMin;
        @Nullable
        LedgerIndex ledgerIndexMax;
        @Nullable
        LedgerIndexBound ledgerIndexMinimum;
        @Nullable
        LedgerIndexBound ledgerIndexMaximum;
        @Nullable
        UnsignedInteger limit;
        @Nullable
        Optional<Marker> marker = Optional.empty();
        @Nullable
        List<AccountTransactionsTransactionResult<? extends Transaction>> transactions = ImmutableList.of();
        boolean validated;
        boolean validatedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="account")
        public void setAccount(Address account) {
            this.account = account;
        }

        @JsonProperty(value="ledgerIndexMin")
        @JsonIgnore
        public void setLedgerIndexMin(LedgerIndex ledgerIndexMin) {
            this.ledgerIndexMin = ledgerIndexMin;
        }

        @JsonProperty(value="ledgerIndexMax")
        @JsonIgnore
        public void setLedgerIndexMax(LedgerIndex ledgerIndexMax) {
            this.ledgerIndexMax = ledgerIndexMax;
        }

        @JsonProperty(value="ledger_index_min")
        public void setLedgerIndexMinimum(LedgerIndexBound ledgerIndexMinimum) {
            this.ledgerIndexMinimum = ledgerIndexMinimum;
        }

        @JsonProperty(value="ledger_index_max")
        public void setLedgerIndexMaximum(LedgerIndexBound ledgerIndexMaximum) {
            this.ledgerIndexMaximum = ledgerIndexMaximum;
        }

        @JsonProperty(value="limit")
        public void setLimit(UnsignedInteger limit) {
            this.limit = limit;
        }

        @JsonProperty(value="marker")
        public void setMarker(Optional<Marker> marker) {
            this.marker = marker;
        }

        @JsonProperty(value="transactions")
        public void setTransactions(List<AccountTransactionsTransactionResult<? extends Transaction>> transactions) {
            this.transactions = transactions;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Address account() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndexMin() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndexMax() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndexBound ledgerIndexMinimum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndexBound ledgerIndexMaximum() {
            throw new UnsupportedOperationException();
        }

        @Override
        public UnsignedInteger limit() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<Marker> marker() {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<AccountTransactionsTransactionResult<? extends Transaction>> transactions() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountTransactionsResult", generator="Immutables")
    private final class InitShim {
        private byte ledgerIndexMinBuildStage = 0;
        private LedgerIndex ledgerIndexMin;
        private byte ledgerIndexMaxBuildStage = 0;
        private LedgerIndex ledgerIndexMax;
        private byte validatedBuildStage = 0;
        private boolean validated;

        private InitShim() {
        }

        LedgerIndex ledgerIndexMin() {
            if (this.ledgerIndexMinBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerIndexMinBuildStage == 0) {
                this.ledgerIndexMinBuildStage = (byte)-1;
                this.ledgerIndexMin = Objects.requireNonNull(ImmutableAccountTransactionsResult.this.ledgerIndexMinInitialize(), "ledgerIndexMin");
                this.ledgerIndexMinBuildStage = 1;
            }
            return this.ledgerIndexMin;
        }

        void ledgerIndexMin(LedgerIndex ledgerIndexMin) {
            this.ledgerIndexMin = ledgerIndexMin;
            this.ledgerIndexMinBuildStage = 1;
        }

        LedgerIndex ledgerIndexMax() {
            if (this.ledgerIndexMaxBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.ledgerIndexMaxBuildStage == 0) {
                this.ledgerIndexMaxBuildStage = (byte)-1;
                this.ledgerIndexMax = Objects.requireNonNull(ImmutableAccountTransactionsResult.this.ledgerIndexMaxInitialize(), "ledgerIndexMax");
                this.ledgerIndexMaxBuildStage = 1;
            }
            return this.ledgerIndexMax;
        }

        void ledgerIndexMax(LedgerIndex ledgerIndexMax) {
            this.ledgerIndexMax = ledgerIndexMax;
            this.ledgerIndexMaxBuildStage = 1;
        }

        boolean validated() {
            if (this.validatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatedBuildStage == 0) {
                this.validatedBuildStage = (byte)-1;
                this.validated = ImmutableAccountTransactionsResult.this.validatedInitialize();
                this.validatedBuildStage = 1;
            }
            return this.validated;
        }

        void validated(boolean validated) {
            this.validated = validated;
            this.validatedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.ledgerIndexMinBuildStage == -1) {
                attributes.add("ledgerIndexMin");
            }
            if (this.ledgerIndexMaxBuildStage == -1) {
                attributes.add("ledgerIndexMax");
            }
            if (this.validatedBuildStage == -1) {
                attributes.add("validated");
            }
            return "Cannot build AccountTransactionsResult, attribute initializers form cycle " + attributes;
        }
    }
}

