/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsTransaction;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountTransactionsTransaction", generator="Immutables")
@Immutable
public final class ImmutableAccountTransactionsTransaction<T extends Transaction>
implements AccountTransactionsTransaction<T> {
    private final T transaction;
    private final Hash256 hash;
    private final LedgerIndex ledgerIndex;

    private ImmutableAccountTransactionsTransaction(T transaction, Hash256 hash, LedgerIndex ledgerIndex) {
        this.transaction = transaction;
        this.hash = hash;
        this.ledgerIndex = ledgerIndex;
    }

    @Override
    @JsonProperty(value="transaction")
    @JsonUnwrapped
    public T transaction() {
        return this.transaction;
    }

    @Override
    @JsonProperty(value="hash")
    public Hash256 hash() {
        return this.hash;
    }

    @Override
    @JsonProperty(value="ledger_index")
    public LedgerIndex ledgerIndex() {
        return this.ledgerIndex;
    }

    public final ImmutableAccountTransactionsTransaction<T> withTransaction(T value) {
        if (this.transaction == value) {
            return this;
        }
        Transaction newValue = (Transaction)Objects.requireNonNull(value, "transaction");
        return new ImmutableAccountTransactionsTransaction<Transaction>(newValue, this.hash, this.ledgerIndex);
    }

    public final ImmutableAccountTransactionsTransaction<T> withHash(Hash256 value) {
        if (this.hash == value) {
            return this;
        }
        Hash256 newValue = Objects.requireNonNull(value, "hash");
        return new ImmutableAccountTransactionsTransaction<T>(this.transaction, newValue, this.ledgerIndex);
    }

    public final ImmutableAccountTransactionsTransaction<T> withLedgerIndex(LedgerIndex value) {
        if (this.ledgerIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerIndex");
        return new ImmutableAccountTransactionsTransaction<T>(this.transaction, this.hash, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountTransactionsTransaction && this.equalTo((ImmutableAccountTransactionsTransaction)another);
    }

    private boolean equalTo(ImmutableAccountTransactionsTransaction<?> another) {
        return this.transaction.equals(another.transaction) && this.hash.equals(another.hash) && this.ledgerIndex.equals(another.ledgerIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + this.hash.hashCode();
        h += (h << 5) + this.ledgerIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountTransactionsTransaction").omitNullValues().add("transaction", this.transaction).add("hash", (Object)this.hash).add("ledgerIndex", (Object)this.ledgerIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends Transaction> ImmutableAccountTransactionsTransaction<T> fromJson(Json<T> json) {
        Builder builder = ImmutableAccountTransactionsTransaction.builder();
        if (json.transaction != null) {
            builder.transaction(json.transaction);
        }
        if (json.hash != null) {
            builder.hash(json.hash);
        }
        if (json.ledgerIndex != null) {
            builder.ledgerIndex(json.ledgerIndex);
        }
        return builder.build();
    }

    public static <T extends Transaction> ImmutableAccountTransactionsTransaction<T> copyOf(AccountTransactionsTransaction<T> instance) {
        if (instance instanceof ImmutableAccountTransactionsTransaction) {
            return (ImmutableAccountTransactionsTransaction)instance;
        }
        return ImmutableAccountTransactionsTransaction.builder().from(instance).build();
    }

    public static <T extends Transaction> Builder<T> builder() {
        return new Builder();
    }

    /* synthetic */ ImmutableAccountTransactionsTransaction(Transaction x0, Hash256 x1, LedgerIndex x2, 1 x3) {
        this(x0, x1, x2);
    }

    @Generated(from="AccountTransactionsTransaction", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Transaction> {
        private static final long INIT_BIT_TRANSACTION = 1L;
        private static final long INIT_BIT_HASH = 2L;
        private static final long INIT_BIT_LEDGER_INDEX = 4L;
        private long initBits = 7L;
        @Nullable
        private T transaction;
        @Nullable
        private Hash256 hash;
        @Nullable
        private LedgerIndex ledgerIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AccountTransactionsTransaction<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.transaction(instance.transaction());
            this.hash(instance.hash());
            this.ledgerIndex(instance.ledgerIndex());
            return this;
        }

        @JsonProperty(value="transaction")
        @JsonUnwrapped
        @CanIgnoreReturnValue
        public final Builder<T> transaction(T transaction) {
            this.transaction = (Transaction)Objects.requireNonNull(transaction, "transaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="hash")
        @CanIgnoreReturnValue
        public final Builder<T> hash(Hash256 hash) {
            this.hash = Objects.requireNonNull(hash, "hash");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @JsonProperty(value="ledger_index")
        @CanIgnoreReturnValue
        public final Builder<T> ledgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = Objects.requireNonNull(ledgerIndex, "ledgerIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public ImmutableAccountTransactionsTransaction<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountTransactionsTransaction((Transaction)this.transaction, this.hash, this.ledgerIndex, null);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transaction");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("hash");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("ledgerIndex");
            }
            return "Cannot build AccountTransactionsTransaction, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountTransactionsTransaction", generator="Immutables")
    static final class Json<T extends Transaction>
    implements AccountTransactionsTransaction<T> {
        @Nullable
        T transaction;
        @Nullable
        Hash256 hash;
        @Nullable
        LedgerIndex ledgerIndex;

        Json() {
        }

        @JsonProperty(value="transaction")
        @JsonUnwrapped
        public void setTransaction(T transaction) {
            this.transaction = transaction;
        }

        @JsonProperty(value="hash")
        public void setHash(Hash256 hash) {
            this.hash = hash;
        }

        @JsonProperty(value="ledger_index")
        public void setLedgerIndex(LedgerIndex ledgerIndex) {
            this.ledgerIndex = ledgerIndex;
        }

        @Override
        public T transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Hash256 hash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

