/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.accounts;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Booleans;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsTransaction;
import org.xrpl.xrpl4j.model.client.accounts.AccountTransactionsTransactionResult;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
@Immutable
public final class ImmutableAccountTransactionsTransactionResult<T extends Transaction>
implements AccountTransactionsTransactionResult<T> {
    @Nullable
    private final String status;
    private final transient T transaction;
    private final AccountTransactionsTransaction<T> resultTransaction;
    @Nullable
    private final TransactionMetadata metadata;
    private final boolean validated;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableAccountTransactionsTransactionResult(Builder<T> builder) {
        this.status = ((Builder)builder).status;
        this.resultTransaction = ((Builder)builder).resultTransaction;
        this.metadata = ((Builder)builder).metadata;
        if (((Builder)builder).validatedIsSet()) {
            this.initShim.validated(((Builder)builder).validated);
        }
        this.transaction = this.initShim.transaction();
        this.validated = this.initShim.validated();
        this.initShim = null;
    }

    private ImmutableAccountTransactionsTransactionResult(@Nullable String status, AccountTransactionsTransaction<T> resultTransaction, @Nullable TransactionMetadata metadata, boolean validated) {
        this.status = status;
        this.resultTransaction = resultTransaction;
        this.metadata = metadata;
        this.initShim.validated(validated);
        this.transaction = this.initShim.transaction();
        this.validated = this.initShim.validated();
        this.initShim = null;
    }

    private T transactionInitialize() {
        return AccountTransactionsTransactionResult.super.transaction();
    }

    private boolean validatedInitialize() {
        return AccountTransactionsTransactionResult.super.validated();
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="transaction")
    @JsonIgnore
    @Deprecated
    public T transaction() {
        InitShim shim = this.initShim;
        return shim != null ? shim.transaction() : this.transaction;
    }

    @Override
    @JsonProperty(value="tx")
    public AccountTransactionsTransaction<T> resultTransaction() {
        return this.resultTransaction;
    }

    @Override
    @JsonProperty(value="meta")
    public Optional<TransactionMetadata> metadata() {
        return Optional.ofNullable(this.metadata);
    }

    @Override
    @JsonProperty(value="validated")
    public boolean validated() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validated() : this.validated;
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(newValue, this.resultTransaction, this.metadata, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(value, this.resultTransaction, this.metadata, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withResultTransaction(AccountTransactionsTransaction<T> value) {
        if (this.resultTransaction == value) {
            return this;
        }
        AccountTransactionsTransaction<T> newValue = Objects.requireNonNull(value, "resultTransaction");
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, newValue, this.metadata, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withMetadata(TransactionMetadata value) {
        TransactionMetadata newValue = Objects.requireNonNull(value, "metadata");
        if (this.metadata == newValue) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, this.resultTransaction, newValue, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withMetadata(Optional<? extends TransactionMetadata> optional) {
        TransactionMetadata value = optional.orElse(null);
        if (this.metadata == value) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, this.resultTransaction, value, this.validated);
    }

    public final ImmutableAccountTransactionsTransactionResult<T> withValidated(boolean value) {
        if (this.validated == value) {
            return this;
        }
        return new ImmutableAccountTransactionsTransactionResult<T>(this.status, this.resultTransaction, this.metadata, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAccountTransactionsTransactionResult && this.equalTo((ImmutableAccountTransactionsTransactionResult)another);
    }

    private boolean equalTo(ImmutableAccountTransactionsTransactionResult<?> another) {
        return Objects.equals(this.status, another.status) && this.transaction.equals(another.transaction) && this.resultTransaction.equals(another.resultTransaction) && Objects.equals(this.metadata, another.metadata) && this.validated == another.validated;
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.transaction.hashCode();
        h += (h << 5) + this.resultTransaction.hashCode();
        h += (h << 5) + Objects.hashCode(this.metadata);
        h += (h << 5) + Booleans.hashCode((boolean)this.validated);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AccountTransactionsTransactionResult").omitNullValues().add("status", (Object)this.status).add("transaction", this.transaction).add("resultTransaction", this.resultTransaction).add("metadata", (Object)this.metadata).add("validated", this.validated).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static <T extends Transaction> ImmutableAccountTransactionsTransactionResult<T> fromJson(Json<T> json) {
        Builder builder = ImmutableAccountTransactionsTransactionResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.resultTransaction != null) {
            builder.resultTransaction(json.resultTransaction);
        }
        if (json.metadata != null) {
            builder.metadata(json.metadata);
        }
        if (json.validatedIsSet) {
            builder.validated(json.validated);
        }
        return builder.build();
    }

    public static <T extends Transaction> ImmutableAccountTransactionsTransactionResult<T> copyOf(AccountTransactionsTransactionResult<T> instance) {
        if (instance instanceof ImmutableAccountTransactionsTransactionResult) {
            return (ImmutableAccountTransactionsTransactionResult)instance;
        }
        return ImmutableAccountTransactionsTransactionResult.builder().from(instance).build();
    }

    public static <T extends Transaction> Builder<T> builder() {
        return new Builder();
    }

    @Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder<T extends Transaction> {
        private static final long INIT_BIT_RESULT_TRANSACTION = 1L;
        private static final long OPT_BIT_VALIDATED = 1L;
        private long initBits = 1L;
        private long optBits;
        @Nullable
        private String status;
        @Nullable
        private AccountTransactionsTransaction<T> resultTransaction;
        @Nullable
        private TransactionMetadata metadata;
        private boolean validated;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(AccountTransactionsTransactionResult<T> instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof AccountTransactionsTransactionResult) {
                instance = (AccountTransactionsTransactionResult)object;
                this.validated(instance.validated());
                Optional<TransactionMetadata> metadataOptional = instance.metadata();
                if (metadataOptional.isPresent()) {
                    this.metadata(metadataOptional);
                }
                this.resultTransaction(instance.resultTransaction());
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder<T> status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder<T> status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="tx")
        @CanIgnoreReturnValue
        public final Builder<T> resultTransaction(AccountTransactionsTransaction<T> resultTransaction) {
            this.resultTransaction = Objects.requireNonNull(resultTransaction, "resultTransaction");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder<T> metadata(TransactionMetadata metadata) {
            this.metadata = Objects.requireNonNull(metadata, "metadata");
            return this;
        }

        @JsonProperty(value="meta")
        @CanIgnoreReturnValue
        public final Builder<T> metadata(Optional<? extends TransactionMetadata> metadata) {
            this.metadata = metadata.orElse(null);
            return this;
        }

        @JsonProperty(value="validated")
        @CanIgnoreReturnValue
        public final Builder<T> validated(boolean validated) {
            this.validated = validated;
            this.optBits |= 1L;
            return this;
        }

        public ImmutableAccountTransactionsTransactionResult<T> build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAccountTransactionsTransactionResult(this);
        }

        private boolean validatedIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("resultTransaction");
            }
            return "Cannot build AccountTransactionsTransactionResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
    static final class Json<T extends Transaction>
    implements AccountTransactionsTransactionResult<T> {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        AccountTransactionsTransaction<T> resultTransaction;
        @Nullable
        Optional<TransactionMetadata> metadata = Optional.empty();
        boolean validated;
        boolean validatedIsSet;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="tx")
        public void setResultTransaction(AccountTransactionsTransaction<T> resultTransaction) {
            this.resultTransaction = resultTransaction;
        }

        @JsonProperty(value="meta")
        public void setMetadata(Optional<TransactionMetadata> metadata) {
            this.metadata = metadata;
        }

        @JsonProperty(value="validated")
        public void setValidated(boolean validated) {
            this.validated = validated;
            this.validatedIsSet = true;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        @JsonIgnore
        public T transaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public AccountTransactionsTransaction<T> resultTransaction() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<TransactionMetadata> metadata() {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean validated() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="AccountTransactionsTransactionResult", generator="Immutables")
    private final class InitShim {
        private byte transactionBuildStage = 0;
        private T transaction;
        private byte validatedBuildStage = 0;
        private boolean validated;

        private InitShim() {
        }

        T transaction() {
            if (this.transactionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.transactionBuildStage == 0) {
                this.transactionBuildStage = (byte)-1;
                this.transaction = Objects.requireNonNull(ImmutableAccountTransactionsTransactionResult.this.transactionInitialize(), "transaction");
                this.transactionBuildStage = 1;
            }
            return this.transaction;
        }

        boolean validated() {
            if (this.validatedBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatedBuildStage == 0) {
                this.validatedBuildStage = (byte)-1;
                this.validated = ImmutableAccountTransactionsTransactionResult.this.validatedInitialize();
                this.validatedBuildStage = 1;
            }
            return this.validated;
        }

        void validated(boolean validated) {
            this.validated = validated;
            this.validatedBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.transactionBuildStage == -1) {
                attributes.add("transaction");
            }
            if (this.validatedBuildStage == -1) {
                attributes.add("validated");
            }
            return "Cannot build AccountTransactionsTransactionResult, attribute initializers form cycle " + attributes;
        }
    }
}

