/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.admin;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.admin.AcceptLedgerResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="AcceptLedgerResult", generator="Immutables")
@Immutable
public final class ImmutableAcceptLedgerResult
implements AcceptLedgerResult {
    @Nullable
    private final String status;
    private final LedgerIndex ledgerCurrentIndex;

    private ImmutableAcceptLedgerResult(@Nullable String status, LedgerIndex ledgerCurrentIndex) {
        this.status = status;
        this.ledgerCurrentIndex = ledgerCurrentIndex;
    }

    @Override
    @JsonProperty(value="status")
    public Optional<String> status() {
        return Optional.ofNullable(this.status);
    }

    @Override
    @JsonProperty(value="ledger_current_index")
    public LedgerIndex ledgerCurrentIndex() {
        return this.ledgerCurrentIndex;
    }

    public final ImmutableAcceptLedgerResult withStatus(String value) {
        String newValue = Objects.requireNonNull(value, "status");
        if (Objects.equals(this.status, newValue)) {
            return this;
        }
        return new ImmutableAcceptLedgerResult(newValue, this.ledgerCurrentIndex);
    }

    public final ImmutableAcceptLedgerResult withStatus(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.status, value)) {
            return this;
        }
        return new ImmutableAcceptLedgerResult(value, this.ledgerCurrentIndex);
    }

    public final ImmutableAcceptLedgerResult withLedgerCurrentIndex(LedgerIndex value) {
        if (this.ledgerCurrentIndex == value) {
            return this;
        }
        LedgerIndex newValue = Objects.requireNonNull(value, "ledgerCurrentIndex");
        return new ImmutableAcceptLedgerResult(this.status, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableAcceptLedgerResult && this.equalTo((ImmutableAcceptLedgerResult)another);
    }

    private boolean equalTo(ImmutableAcceptLedgerResult another) {
        return Objects.equals(this.status, another.status) && this.ledgerCurrentIndex.equals(another.ledgerCurrentIndex);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.status);
        h += (h << 5) + this.ledgerCurrentIndex.hashCode();
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"AcceptLedgerResult").omitNullValues().add("status", (Object)this.status).add("ledgerCurrentIndex", (Object)this.ledgerCurrentIndex).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableAcceptLedgerResult fromJson(Json json) {
        Builder builder = ImmutableAcceptLedgerResult.builder();
        if (json.status != null) {
            builder.status(json.status);
        }
        if (json.ledgerCurrentIndex != null) {
            builder.ledgerCurrentIndex(json.ledgerCurrentIndex);
        }
        return builder.build();
    }

    public static ImmutableAcceptLedgerResult copyOf(AcceptLedgerResult instance) {
        if (instance instanceof ImmutableAcceptLedgerResult) {
            return (ImmutableAcceptLedgerResult)instance;
        }
        return ImmutableAcceptLedgerResult.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="AcceptLedgerResult", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_LEDGER_CURRENT_INDEX = 1L;
        private long initBits = 1L;
        @Nullable
        private String status;
        @Nullable
        private LedgerIndex ledgerCurrentIndex;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(AcceptLedgerResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder from(XrplResult instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional<String> statusOptional;
            XrplResult instance;
            if (object instanceof AcceptLedgerResult) {
                instance = (AcceptLedgerResult)object;
                this.ledgerCurrentIndex(instance.ledgerCurrentIndex());
            }
            if (object instanceof XrplResult && (statusOptional = (instance = (XrplResult)object).status()).isPresent()) {
                this.status(statusOptional);
            }
        }

        @CanIgnoreReturnValue
        public final Builder status(String status) {
            this.status = Objects.requireNonNull(status, "status");
            return this;
        }

        @JsonProperty(value="status")
        @CanIgnoreReturnValue
        public final Builder status(Optional<String> status) {
            this.status = status.orElse(null);
            return this;
        }

        @JsonProperty(value="ledger_current_index")
        @CanIgnoreReturnValue
        public final Builder ledgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = Objects.requireNonNull(ledgerCurrentIndex, "ledgerCurrentIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public ImmutableAcceptLedgerResult build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableAcceptLedgerResult(this.status, this.ledgerCurrentIndex);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("ledgerCurrentIndex");
            }
            return "Cannot build AcceptLedgerResult, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="AcceptLedgerResult", generator="Immutables")
    static final class Json
    implements AcceptLedgerResult {
        @Nullable
        Optional<String> status = Optional.empty();
        @Nullable
        LedgerIndex ledgerCurrentIndex;

        Json() {
        }

        @JsonProperty(value="status")
        public void setStatus(Optional<String> status) {
            this.status = status;
        }

        @JsonProperty(value="ledger_current_index")
        public void setLedgerCurrentIndex(LedgerIndex ledgerCurrentIndex) {
            this.ledgerCurrentIndex = ledgerCurrentIndex;
        }

        @Override
        public Optional<String> status() {
            throw new UnsupportedOperationException();
        }

        @Override
        public LedgerIndex ledgerCurrentIndex() {
            throw new UnsupportedOperationException();
        }
    }
}

