/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.path;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.LegacyLedgerSpecifierUtils;
import org.xrpl.xrpl4j.model.client.XrplRequestParams;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.common.LedgerSpecifier;
import org.xrpl.xrpl4j.model.client.path.ImmutableRipplePathFindRequestParams;
import org.xrpl.xrpl4j.model.client.path.PathCurrency;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;

@JsonSerialize(as=ImmutableRipplePathFindRequestParams.class)
@JsonDeserialize(as=ImmutableRipplePathFindRequestParams.class)
@Value.Immutable
public interface RipplePathFindRequestParams
extends XrplRequestParams {
    public static ImmutableRipplePathFindRequestParams.Builder builder() {
        return ImmutableRipplePathFindRequestParams.builder();
    }

    @JsonProperty(value="source_account")
    public Address sourceAccount();

    @JsonProperty(value="destination_account")
    public Address destinationAccount();

    @JsonProperty(value="destination_amount")
    public CurrencyAmount destinationAmount();

    @JsonProperty(value="send_max")
    public Optional<CurrencyAmount> sendMax();

    @JsonProperty(value="source_currencies")
    public List<PathCurrency> sourceCurrencies();

    @JsonIgnore
    @Deprecated
    @Value.Auxiliary
    public Optional<Hash256> ledgerHash();

    @JsonIgnore
    @Deprecated
    @Nullable
    @Value.Auxiliary
    public LedgerIndex ledgerIndex();

    @JsonUnwrapped
    @Value.Default
    default public LedgerSpecifier ledgerSpecifier() {
        return LegacyLedgerSpecifierUtils.computeLedgerSpecifier(this.ledgerHash(), this.ledgerIndex());
    }
}

