/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.client.transactions;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedLong;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.client.XrplResult;
import org.xrpl.xrpl4j.model.client.common.LedgerIndex;
import org.xrpl.xrpl4j.model.client.transactions.ImmutableTransactionResult;
import org.xrpl.xrpl4j.model.jackson.modules.TransactionResultDeserializer;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.Transaction;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

@JsonSerialize(as=ImmutableTransactionResult.class)
@JsonDeserialize(using=TransactionResultDeserializer.class)
@Value.Immutable
public interface TransactionResult<TxnType extends Transaction>
extends XrplResult {
    public static final long RIPPLE_EPOCH = 946684800L;

    public static <T extends Transaction> ImmutableTransactionResult.Builder<T> builder() {
        return ImmutableTransactionResult.builder();
    }

    @JsonUnwrapped
    public TxnType transaction();

    @JsonProperty(value="ledger_index")
    public Optional<LedgerIndex> ledgerIndex();

    @JsonIgnore
    @Value.Auxiliary
    default public LedgerIndex ledgerIndexSafe() {
        return this.ledgerIndex().orElseThrow(() -> new IllegalStateException("Result did not contain a ledgerIndex."));
    }

    public Hash256 hash();

    @Value.Default
    default public boolean validated() {
        return false;
    }

    @JsonProperty(value="meta")
    public Optional<TransactionMetadata> metadata();

    @JsonProperty(value="date")
    public Optional<UnsignedLong> closeDate();

    @JsonIgnore
    @Value.Auxiliary
    default public Optional<ZonedDateTime> closeDateHuman() {
        return this.closeDate().map(secondsSinceRippleEpoch -> Instant.ofEpochSecond(946684800L + secondsSinceRippleEpoch.longValue()).atZone(ZoneId.of("UTC")));
    }
}

