/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import com.google.common.primitives.UnsignedInteger;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.ImmutableAccountSet;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableAccountSet.class)
@JsonDeserialize(as=ImmutableAccountSet.class)
@Value.Immutable
public interface AccountSet
extends Transaction {
    public static ImmutableAccountSet.Builder builder() {
        return ImmutableAccountSet.builder();
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags.TransactionFlags flags() {
        return new Flags.TransactionFlags.Builder().tfFullyCanonicalSig(true).build();
    }

    @JsonProperty(value="ClearFlag")
    public Optional<AccountSetFlag> clearFlag();

    @JsonProperty(value="SetFlag")
    public Optional<AccountSetFlag> setFlag();

    @JsonProperty(value="Domain")
    public Optional<String> domain();

    @JsonProperty(value="EmailHash")
    public Optional<String> emailHash();

    @JsonProperty(value="MessageKey")
    public Optional<String> messageKey();

    @JsonProperty(value="TransferRate")
    public Optional<UnsignedInteger> transferRate();

    @JsonProperty(value="TickSize")
    public Optional<UnsignedInteger> tickSize();

    @Value.Check
    default public void checkEmailHashLength() {
        this.emailHash().ifPresent(hash -> Preconditions.checkArgument((hash.length() == 32 ? 1 : 0) != 0, (Object)String.format("emailHash must be 32 characters (128 bits), but was %s characters long.", hash.length())));
    }

    @Value.Check
    default public void checkTransferRate() {
        this.transferRate().ifPresent(rate -> Preconditions.checkArgument((rate.equals((Object)UnsignedInteger.ZERO) || rate.compareTo(UnsignedInteger.valueOf((long)1000000000L)) >= 0 && rate.compareTo(UnsignedInteger.valueOf((long)2000000000L)) <= 0 ? 1 : 0) != 0, (Object)"transferRate must be between 1,000,000,000 and 2,000,000,000 or equal to 0."));
    }

    @Value.Check
    default public void checkTickSize() {
        this.tickSize().ifPresent(tickSize -> Preconditions.checkArgument((tickSize.equals((Object)UnsignedInteger.ZERO) || tickSize.compareTo(UnsignedInteger.valueOf((long)3L)) >= 0 && tickSize.compareTo(UnsignedInteger.valueOf((long)15L)) <= 0 ? 1 : 0) != 0, (Object)"tickSize must be between 3 and 15 inclusive or be equal to 0."));
    }

    public static enum AccountSetFlag {
        REQUIRE_DEST(1),
        REQUIRE_AUTH(2),
        DISALLOW_XRP(3),
        DISABLE_MASTER(4),
        ACCOUNT_TXN_ID(5),
        NO_FREEZE(6),
        GLOBAL_FREEZE(7),
        DEFAULT_RIPPLE(8),
        DEPOSIT_AUTH(9);

        int value;

        private AccountSetFlag(int value) {
            this.value = value;
        }

        @JsonCreator
        public static AccountSetFlag forValue(int value) {
            for (AccountSetFlag flag : AccountSetFlag.values()) {
                if (flag.value != value) continue;
                return flag;
            }
            throw new IllegalArgumentException("No matching AccountSetFlag enum value for int value " + value);
        }

        @JsonValue
        public int getValue() {
            return this.value;
        }
    }
}

