/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.base.Preconditions;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.ImmutableCheckCash;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutableCheckCash.class)
@JsonDeserialize(as=ImmutableCheckCash.class)
@Value.Immutable
public interface CheckCash
extends Transaction {
    public static ImmutableCheckCash.Builder builder() {
        return ImmutableCheckCash.builder();
    }

    @JsonProperty(value="Flags")
    @Value.Derived
    default public Flags.TransactionFlags flags() {
        return new Flags.TransactionFlags.Builder().tfFullyCanonicalSig(true).build();
    }

    @JsonProperty(value="CheckID")
    public Hash256 checkId();

    @JsonProperty(value="Amount")
    public Optional<CurrencyAmount> amount();

    @JsonProperty(value="DeliverMin")
    public Optional<CurrencyAmount> deliverMin();

    @Value.Check
    default public void validateOnlyOneAmountSet() {
        Preconditions.checkArgument((!(!this.amount().isPresent() && !this.deliverMin().isPresent() || this.amount().isPresent() && this.deliverMin().isPresent()) ? 1 : 0) != 0, (Object)"The CheckCash transaction must include either amount or deliverMin, but not both.");
    }
}

