/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.UnsignedInteger;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.TransactionMetadata;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="TransactionMetadata", generator="Immutables")
@Immutable
public final class ImmutableTransactionMetadata
implements TransactionMetadata {
    private final UnsignedInteger transactionIndex;
    private final String transactionResult;
    @Nullable
    private final CurrencyAmount deliveredAmount;

    private ImmutableTransactionMetadata(UnsignedInteger transactionIndex, String transactionResult, @Nullable CurrencyAmount deliveredAmount) {
        this.transactionIndex = transactionIndex;
        this.transactionResult = transactionResult;
        this.deliveredAmount = deliveredAmount;
    }

    @Override
    @JsonProperty(value="TransactionIndex")
    public UnsignedInteger transactionIndex() {
        return this.transactionIndex;
    }

    @Override
    @JsonProperty(value="TransactionResult")
    public String transactionResult() {
        return this.transactionResult;
    }

    @Override
    @JsonProperty(value="delivered_amount")
    public Optional<CurrencyAmount> deliveredAmount() {
        return Optional.ofNullable(this.deliveredAmount);
    }

    public final ImmutableTransactionMetadata withTransactionIndex(UnsignedInteger value) {
        UnsignedInteger newValue = Objects.requireNonNull(value, "transactionIndex");
        if (this.transactionIndex.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableTransactionMetadata(newValue, this.transactionResult, this.deliveredAmount);
    }

    public final ImmutableTransactionMetadata withTransactionResult(String value) {
        String newValue = Objects.requireNonNull(value, "transactionResult");
        if (this.transactionResult.equals(newValue)) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, newValue, this.deliveredAmount);
    }

    public final ImmutableTransactionMetadata withDeliveredAmount(CurrencyAmount value) {
        CurrencyAmount newValue = Objects.requireNonNull(value, "deliveredAmount");
        if (this.deliveredAmount == newValue) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, newValue);
    }

    public final ImmutableTransactionMetadata withDeliveredAmount(Optional<? extends CurrencyAmount> optional) {
        CurrencyAmount value = optional.orElse(null);
        if (this.deliveredAmount == value) {
            return this;
        }
        return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, value);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableTransactionMetadata && this.equalTo((ImmutableTransactionMetadata)another);
    }

    private boolean equalTo(ImmutableTransactionMetadata another) {
        return this.transactionIndex.equals((Object)another.transactionIndex) && this.transactionResult.equals(another.transactionResult) && Objects.equals(this.deliveredAmount, another.deliveredAmount);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.transactionIndex.hashCode();
        h += (h << 5) + this.transactionResult.hashCode();
        h += (h << 5) + Objects.hashCode(this.deliveredAmount);
        return h;
    }

    public String toString() {
        return MoreObjects.toStringHelper((String)"TransactionMetadata").omitNullValues().add("transactionIndex", (Object)this.transactionIndex).add("transactionResult", (Object)this.transactionResult).add("deliveredAmount", (Object)this.deliveredAmount).toString();
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableTransactionMetadata fromJson(Json json) {
        Builder builder = ImmutableTransactionMetadata.builder();
        if (json.transactionIndex != null) {
            builder.transactionIndex(json.transactionIndex);
        }
        if (json.transactionResult != null) {
            builder.transactionResult(json.transactionResult);
        }
        if (json.deliveredAmount != null) {
            builder.deliveredAmount(json.deliveredAmount);
        }
        return builder.build();
    }

    public static ImmutableTransactionMetadata copyOf(TransactionMetadata instance) {
        if (instance instanceof ImmutableTransactionMetadata) {
            return (ImmutableTransactionMetadata)instance;
        }
        return ImmutableTransactionMetadata.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="TransactionMetadata", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TRANSACTION_INDEX = 1L;
        private static final long INIT_BIT_TRANSACTION_RESULT = 2L;
        private long initBits = 3L;
        @Nullable
        private UnsignedInteger transactionIndex;
        @Nullable
        private String transactionResult;
        @Nullable
        private CurrencyAmount deliveredAmount;

        private Builder() {
        }

        @CanIgnoreReturnValue
        public final Builder from(TransactionMetadata instance) {
            Objects.requireNonNull(instance, "instance");
            this.transactionIndex(instance.transactionIndex());
            this.transactionResult(instance.transactionResult());
            Optional<CurrencyAmount> deliveredAmountOptional = instance.deliveredAmount();
            if (deliveredAmountOptional.isPresent()) {
                this.deliveredAmount(deliveredAmountOptional);
            }
            return this;
        }

        @JsonProperty(value="TransactionIndex")
        @CanIgnoreReturnValue
        public final Builder transactionIndex(UnsignedInteger transactionIndex) {
            this.transactionIndex = Objects.requireNonNull(transactionIndex, "transactionIndex");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="TransactionResult")
        @CanIgnoreReturnValue
        public final Builder transactionResult(String transactionResult) {
            this.transactionResult = Objects.requireNonNull(transactionResult, "transactionResult");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deliveredAmount(CurrencyAmount deliveredAmount) {
            this.deliveredAmount = Objects.requireNonNull(deliveredAmount, "deliveredAmount");
            return this;
        }

        @JsonProperty(value="delivered_amount")
        @CanIgnoreReturnValue
        public final Builder deliveredAmount(Optional<? extends CurrencyAmount> deliveredAmount) {
            this.deliveredAmount = deliveredAmount.orElse(null);
            return this;
        }

        public ImmutableTransactionMetadata build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableTransactionMetadata(this.transactionIndex, this.transactionResult, this.deliveredAmount);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("transactionIndex");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("transactionResult");
            }
            return "Cannot build TransactionMetadata, some of required attributes are not set " + attributes;
        }
    }

    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="TransactionMetadata", generator="Immutables")
    static final class Json
    implements TransactionMetadata {
        @Nullable
        UnsignedInteger transactionIndex;
        @Nullable
        String transactionResult;
        @Nullable
        Optional<CurrencyAmount> deliveredAmount = Optional.empty();

        Json() {
        }

        @JsonProperty(value="TransactionIndex")
        public void setTransactionIndex(UnsignedInteger transactionIndex) {
            this.transactionIndex = transactionIndex;
        }

        @JsonProperty(value="TransactionResult")
        public void setTransactionResult(String transactionResult) {
            this.transactionResult = transactionResult;
        }

        @JsonProperty(value="delivered_amount")
        public void setDeliveredAmount(Optional<CurrencyAmount> deliveredAmount) {
            this.deliveredAmount = deliveredAmount;
        }

        @Override
        public UnsignedInteger transactionIndex() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String transactionResult() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Optional<CurrencyAmount> deliveredAmount() {
            throw new UnsupportedOperationException();
        }
    }
}

