/*
 * Decompiled with CFR 0.152.
 */
package org.xrpl.xrpl4j.model.transactions;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.primitives.UnsignedInteger;
import java.util.List;
import java.util.Optional;
import org.immutables.value.Value;
import org.xrpl.xrpl4j.model.flags.Flags;
import org.xrpl.xrpl4j.model.transactions.Address;
import org.xrpl.xrpl4j.model.transactions.CurrencyAmount;
import org.xrpl.xrpl4j.model.transactions.Hash256;
import org.xrpl.xrpl4j.model.transactions.ImmutablePayment;
import org.xrpl.xrpl4j.model.transactions.PathStep;
import org.xrpl.xrpl4j.model.transactions.Transaction;

@JsonSerialize(as=ImmutablePayment.class)
@JsonDeserialize(as=ImmutablePayment.class)
@Value.Immutable
public interface Payment
extends Transaction {
    public static ImmutablePayment.Builder builder() {
        return ImmutablePayment.builder();
    }

    @JsonProperty(value="Flags")
    @Value.Default
    default public Flags.PaymentFlags flags() {
        return Flags.PaymentFlags.builder().tfFullyCanonicalSig(true).build();
    }

    @JsonProperty(value="Amount")
    public CurrencyAmount amount();

    @JsonProperty(value="Destination")
    public Address destination();

    @JsonProperty(value="DestinationTag")
    public Optional<UnsignedInteger> destinationTag();

    @JsonProperty(value="InvoiceID")
    public Optional<Hash256> invoiceId();

    @JsonProperty(value="Paths")
    public List<List<PathStep>> paths();

    @JsonProperty(value="SendMax")
    public Optional<CurrencyAmount> sendMax();

    @JsonProperty(value="DeliverMin")
    public Optional<CurrencyAmount> deliverMin();
}

