/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.Closeable;
import java.io.IOException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.xsocket.DataConverter;
import org.xsocket.connection.AbstractMemoryManager;
import org.xsocket.connection.ConnectionUtils;
import org.xsocket.connection.IoProvider;
import org.xsocket.connection.IoSocketHandler;
import org.xsocket.connection.MonitoredSelector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class IoSocketDispatcher
extends MonitoredSelector
implements Runnable,
Closeable {
    private static final Logger LOG = Logger.getLogger(IoSocketDispatcher.class.getName());
    static final String DISPATCHER_PREFIX = "xDispatcher";
    private final ConcurrentLinkedQueue<Runnable> registerQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<IoSocketHandler> deregisterQueue = new ConcurrentLinkedQueue();
    private final ConcurrentLinkedQueue<Runnable> keyUpdateQueue = new ConcurrentLinkedQueue();
    private static int nextId = 1;
    private final String name;
    private final int id;
    private static final ThreadLocal<Integer> THREADBOUND_ID = new ThreadLocal();
    private static final ThreadLocal<Integer> DIRECT_CALL_COUNTER = new ThreadLocal();
    private final AtomicBoolean isOpen = new AtomicBoolean(true);
    private static final Integer MAX_HANDLES = IoProvider.getMaxHandles();
    private int roughNumOfRegisteredHandles;
    private Selector selector;
    private final AbstractMemoryManager memoryManager;
    private long lastTimeWokeUp = System.currentTimeMillis();
    private long statisticsStartTime = System.currentTimeMillis();
    private long countIdleTimeouts = 0L;
    private long countConnectionTimeouts = 0L;
    private long handledRegistractions = 0L;
    private long handledReads = 0L;
    private long handledWrites = 0L;
    private long lastRequestReceiveRate = System.currentTimeMillis();
    private long lastRequestSendRate = System.currentTimeMillis();
    private long receivedBytes = 0L;
    private long sentBytes = 0L;
    private long countUnregisteredWrite = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoSocketDispatcher(AbstractMemoryManager memoryManager, String name) {
        this.memoryManager = memoryManager;
        this.name = DISPATCHER_PREFIX + name;
        IoSocketDispatcher ioSocketDispatcher = this;
        synchronized (ioSocketDispatcher) {
            this.id = nextId++;
        }
        try {
            this.selector = Selector.open();
        }
        catch (IOException ioe) {
            String text = "exception occured while opening selector. Reason: " + ioe.toString();
            LOG.severe(text);
            throw new RuntimeException(text, ioe);
        }
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("dispatcher " + this.hashCode() + " has been closed");
        }
    }

    String getName() {
        return this.name;
    }

    int getId() {
        return this.id;
    }

    private static Integer getThreadBoundId() {
        return THREADBOUND_ID.get();
    }

    long getCountUnregisteredWrite() {
        return this.countUnregisteredWrite;
    }

    Integer getMaxRegisterdHandles() {
        return MAX_HANDLES;
    }

    @Override
    int getNumRegisteredHandles() {
        int hdls;
        this.roughNumOfRegisteredHandles = hdls = this.selector.keys().size();
        return hdls;
    }

    int getRoughNumRegisteredHandles() {
        return this.roughNumOfRegisteredHandles;
    }

    @Override
    void reinit() throws IOException {
        Selector oldSelector = this.selector;
        HashSet<SelectionKey> keys = new HashSet<SelectionKey>();
        keys.addAll(oldSelector.keys());
        this.selector = Selector.open();
        for (SelectionKey key : keys) {
            int ops = key.interestOps();
            IoSocketHandler socketHandler = (IoSocketHandler)key.attachment();
            key.cancel();
            try {
                socketHandler.getChannel().register(this.selector, ops, socketHandler);
            }
            catch (IOException ioe) {
                LOG.warning("could not reinit " + socketHandler.toString() + " " + DataConverter.toString(ioe));
            }
        }
        oldSelector.close();
        if (LOG.isLoggable(Level.FINE)) {
            LOG.fine("selector has been reinitialized");
        }
    }

    @Override
    public void run() {
        block8: {
            Thread.currentThread().setName(this.name);
            THREADBOUND_ID.set(this.id);
            DIRECT_CALL_COUNTER.set(0);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("selector " + this.name + " listening ...");
            }
            int handledTasks = 0;
            while (this.isOpen.get()) {
                try {
                    int eventCount = this.selector.select(5000L);
                    handledTasks = this.performRegisterHandlerTasks();
                    handledTasks += this.performKeyUpdateTasks();
                    if (eventCount > 0) {
                        this.handleReadWriteKeys();
                    }
                    this.checkForLooping(eventCount + (handledTasks += this.performDeregisterHandlerTasks()), this.lastTimeWokeUp);
                }
                catch (Throwable e) {
                    if (!LOG.isLoggable(Level.FINE)) continue;
                    LOG.fine("[" + Thread.currentThread().getName() + "] exception occured while processing. Reason " + DataConverter.toString(e));
                }
            }
            for (IoSocketHandler socketHandler : this.getRegistered()) {
                socketHandler.onDeregisteredEvent();
            }
            try {
                this.selector.close();
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block8;
                LOG.fine("error occured by close selector within tearDown " + DataConverter.toString(e));
            }
        }
    }

    private void handleReadWriteKeys() {
        Set<SelectionKey> selectedEventKeys = this.selector.selectedKeys();
        Iterator<SelectionKey> it = selectedEventKeys.iterator();
        while (it.hasNext()) {
            try {
                SelectionKey eventKey = it.next();
                it.remove();
                IoSocketHandler socketHandler = (IoSocketHandler)eventKey.attachment();
                try {
                    if (eventKey.isValid() && eventKey.isReadable()) {
                        this.onReadableEvent(socketHandler);
                    }
                    if (!eventKey.isValid() || !eventKey.isWritable()) continue;
                    this.onWriteableEvent(socketHandler);
                }
                catch (Exception e) {
                    socketHandler.close(e);
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) continue;
                LOG.fine("error occured by handling selection keys + " + e.toString());
            }
        }
    }

    private void onReadableEvent(IoSocketHandler socketHandler) {
        try {
            long read = socketHandler.onReadableEvent();
            this.receivedBytes += read;
            ++this.handledReads;
        }
        catch (Exception t) {
            SelectionKey key = this.getSelectionKey(socketHandler);
            if (key != null && key.isValid()) {
                key.cancel();
            }
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("error occured by handling readable event " + DataConverter.toString(t));
            }
            socketHandler.closeSilence(true);
        }
    }

    private void onWriteableEvent(IoSocketHandler socketHandler) {
        try {
            socketHandler.onWriteableEvent();
            ++this.handledWrites;
        }
        catch (ClosedChannelException ce) {
            IOException ioe = ConnectionUtils.toIOException("error occured by handling readable event. reason closed channel exception " + ce.toString(), ce);
            socketHandler.close(ioe);
        }
        catch (Exception e2) {
            IOException e2 = ConnectionUtils.toIOException("error occured by handling readable event. reason " + e2.toString(), e2);
            socketHandler.close(e2);
        }
    }

    private void wakeUp() {
        this.lastTimeWokeUp = System.currentTimeMillis();
        this.selector.wakeup();
    }

    boolean preRegister() {
        ++this.roughNumOfRegisteredHandles;
        return MAX_HANDLES == null || this.roughNumOfRegisteredHandles < MAX_HANDLES || this.getNumRegisteredHandles() < MAX_HANDLES;
    }

    public boolean register(IoSocketHandler socketHandler, int ops) throws IOException {
        assert (!socketHandler.getChannel().isBlocking());
        socketHandler.setMemoryManager(this.memoryManager);
        if (this.isDispatcherInstanceThread()) {
            this.registerHandlerNow(socketHandler, ops);
        } else {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + socketHandler.getId() + "] add new connection to register task queue");
            }
            this.registerQueue.add(new RegisterTask(socketHandler, ops));
            this.wakeUp();
        }
        return true;
    }

    public void deregisterAndClose(IoSocketHandler handler) {
        if (this.isOpen.get()) {
            if (this.isDispatcherInstanceThread()) {
                this.deregisterAndCloseNow(handler);
            } else {
                this.deregisterQueue.add(handler);
                this.wakeUp();
            }
        } else {
            handler.onDeregisteredEvent();
        }
    }

    private int performDeregisterHandlerTasks() {
        int handledTasks = 0;
        IoSocketHandler socketHandler;
        while ((socketHandler = this.deregisterQueue.poll()) != null) {
            this.deregisterAndCloseNow(socketHandler);
            ++handledTasks;
        }
        return handledTasks;
    }

    private void deregisterAndCloseNow(IoSocketHandler socketHandler) {
        block4: {
            try {
                SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
                if (key != null && key.isValid()) {
                    key.cancel();
                    if (this.roughNumOfRegisteredHandles > 0) {
                        --this.roughNumOfRegisteredHandles;
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isLoggable(Level.FINE)) break block4;
                LOG.fine("error occured by deregistering socket handler " + e.toString());
            }
        }
        socketHandler.onDeregisteredEvent();
    }

    public void addKeyUpdateTask(Runnable task) {
        this.keyUpdateQueue.add(task);
        this.wakeUp();
    }

    public void flushKeyUpdate() {
        this.wakeUp();
    }

    public void suspendRead(IoSocketHandler socketHandler) throws IOException {
        this.addKeyUpdateTask(new UpdateReadSelectionKeyTask(socketHandler, false));
    }

    public void resumeRead(IoSocketHandler socketHandler) throws IOException {
        this.addKeyUpdateTask(new UpdateReadSelectionKeyTask(socketHandler, true));
    }

    private int performKeyUpdateTasks() {
        int handledTasks = 0;
        Runnable keyUpdateTask;
        while ((keyUpdateTask = this.keyUpdateQueue.poll()) != null) {
            keyUpdateTask.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    public boolean isDispatcherInstanceThread() {
        Integer tbid = IoSocketDispatcher.getThreadBoundId();
        return tbid != null && tbid == this.id;
    }

    private SelectionKey getSelectionKey(IoSocketHandler socketHandler) {
        SelectionKey key = socketHandler.getChannel().keyFor(this.selector);
        if (LOG.isLoggable(Level.FINE)) {
            if (key == null) {
                LOG.fine("[" + socketHandler.getId() + "] key is null");
            } else if (!key.isValid()) {
                LOG.fine("[" + socketHandler.getId() + "] key is not valid");
            }
        }
        return key;
    }

    public boolean setWriteSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherInstanceThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (key != null) {
            if (!this.isWriteable(key)) {
                key.interestOps(key.interestOps() | 4);
                return true;
            }
        } else {
            throw new IOException("[" + socketHandler.getId() + "] Error occured by setting write selection key. key is null");
        }
        return false;
    }

    public boolean unsetWriteSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherInstanceThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (key != null) {
            if (this.isWriteable(key)) {
                key.interestOps(key.interestOps() & 0xFFFFFFFB);
                return true;
            }
        } else {
            throw new IOException("[" + socketHandler.getId() + "] Error occured by unsetting write selection key. key is null");
        }
        return false;
    }

    public boolean setReadSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherInstanceThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (key != null) {
            if (!this.isReadable(key)) {
                key.interestOps(key.interestOps() | 1);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.fine("[" + socketHandler.getId() + "] key set to " + this.printSelectionKey(socketHandler));
                }
                this.onReadableEvent(socketHandler);
                return true;
            }
        } else {
            throw new IOException("[" + socketHandler.getId() + "] Error occured by setting read selection key. key is null");
        }
        return false;
    }

    private void unsetReadSelectionKeyNow(IoSocketHandler socketHandler) throws IOException {
        assert (this.isDispatcherInstanceThread());
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (key != null) {
            if (this.isReadable(key)) {
                key.interestOps(key.interestOps() & 0xFFFFFFFE);
            }
        } else {
            throw new IOException("[" + socketHandler.getId() + "] Error occured by unsetting read selection key. key is null");
        }
    }

    String getRegisteredOpsInfo(IoSocketHandler socketHandler) {
        SelectionKey key = this.getSelectionKey(socketHandler);
        if (key == null) {
            return "<not registered>";
        }
        return ConnectionUtils.printSelectionKeyValue(key.interestOps());
    }

    private int performRegisterHandlerTasks() throws IOException {
        int handledTasks = 0;
        Runnable registerTask;
        while ((registerTask = this.registerQueue.poll()) != null) {
            registerTask.run();
            ++handledTasks;
        }
        return handledTasks;
    }

    private void registerHandlerNow(IoSocketHandler socketHandler, int ops) throws IOException {
        if (socketHandler.isOpen()) {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("[" + socketHandler.getId() + "] registering connection");
            }
            try {
                socketHandler.getChannel().register(this.selector, ops, socketHandler);
                socketHandler.onRegisteredEvent();
                ++this.handledRegistractions;
            }
            catch (Exception e) {
                socketHandler.close(e);
            }
        } else {
            socketHandler.onRegisteredFailedEvent(new IOException("could not register handler " + socketHandler.getId() + " because the channel is closed"));
        }
    }

    public Set<IoSocketHandler> getRegistered() {
        HashSet<IoSocketHandler> registered = new HashSet<IoSocketHandler>();
        Set<SelectionKey> keys = this.selector.keys();
        for (SelectionKey key : keys) {
            IoSocketHandler socketHandler = (IoSocketHandler)key.attachment();
            registered.add(socketHandler);
        }
        return registered;
    }

    public boolean isOpen() {
        return this.isOpen.get();
    }

    boolean isReadable(IoSocketHandler socketHandler) {
        SelectionKey key = this.getSelectionKey(socketHandler);
        return key != null && (key.interestOps() & 1) == 1;
    }

    private boolean isReadable(SelectionKey key) {
        return key != null && (key.interestOps() & 1) == 1;
    }

    private boolean isWriteable(SelectionKey key) {
        return key != null && (key.interestOps() & 4) == 4;
    }

    public long getNumberOfHandledRegistrations() {
        return this.handledRegistractions;
    }

    public long getNumberOfHandledReads() {
        return this.handledReads;
    }

    public long getNumberOfHandledWrites() {
        return this.handledWrites;
    }

    long getReceiveRateBytesPerSec() {
        long rate = 0L;
        long elapsed = System.currentTimeMillis() - this.lastRequestReceiveRate;
        rate = this.receivedBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.receivedBytes * 1000L / elapsed);
        this.lastRequestReceiveRate = System.currentTimeMillis();
        this.receivedBytes = 0L;
        return rate;
    }

    long getSendRateBytesPerSec() {
        long rate = 0L;
        long elapsed = System.currentTimeMillis() - this.lastRequestSendRate;
        rate = this.sentBytes == 0L ? 0L : (elapsed == 0L ? Long.MAX_VALUE : this.sentBytes * 1000L / elapsed);
        this.lastRequestSendRate = System.currentTimeMillis();
        this.sentBytes = 0L;
        return rate;
    }

    long getCountIdleTimeout() {
        return this.countIdleTimeouts;
    }

    long getCountConnectionTimeout() {
        return this.countConnectionTimeouts;
    }

    public int getPreallocatedReadMemorySize() {
        return this.memoryManager.getCurrentSizePreallocatedBuffer();
    }

    boolean getReceiveBufferPreallocationMode() {
        return this.memoryManager.isPreallocationMode();
    }

    void setReceiveBufferPreallocationMode(boolean mode) {
        this.memoryManager.setPreallocationMode(mode);
    }

    void setReceiveBufferPreallocatedMinSize(Integer minSize) {
        this.memoryManager.setPreallocatedMinBufferSize(minSize);
    }

    Integer getReceiveBufferPreallocatedMinSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.getPreallocatedMinBufferSize();
        }
        return null;
    }

    Integer getReceiveBufferPreallocatedSize() {
        if (this.memoryManager.isPreallocationMode()) {
            return this.memoryManager.getPreallocationBufferSize();
        }
        return null;
    }

    void setReceiveBufferPreallocatedSize(Integer size) {
        this.memoryManager.setPreallocationBufferSize(size);
    }

    boolean getReceiveBufferIsDirect() {
        return this.memoryManager.isDirect();
    }

    void setReceiveBufferIsDirect(boolean isDirect) {
        this.memoryManager.setDirect(isDirect);
    }

    public void resetStatistics() {
        this.statisticsStartTime = System.currentTimeMillis();
        this.handledRegistractions = 0L;
        this.handledReads = 0L;
        this.handledWrites = 0L;
    }

    public String toString() {
        return "open channels  " + this.getRegistered().size();
    }

    protected long getStatisticsStartTime() {
        return this.statisticsStartTime;
    }

    @Override
    String printRegistered() {
        StringBuilder sb = new StringBuilder();
        for (IoSocketHandler handler : this.getRegistered()) {
            sb.append(handler.toString() + " (key: " + this.printSelectionKey(handler) + ")\r\n");
        }
        return sb.toString();
    }

    String printSelectionKey(IoSocketHandler socketHandler) {
        return ConnectionUtils.printSelectionKey(socketHandler.getChannel().keyFor(this.selector));
    }

    @Override
    public void close() throws IOException {
        if (this.isOpen.getAndSet(false) && this.selector != null) {
            this.selector.wakeup();
        }
    }

    private final class UpdateReadSelectionKeyTask
    implements Runnable {
        private final IoSocketHandler socketHandler;
        private final boolean isSet;

        public UpdateReadSelectionKeyTask(IoSocketHandler socketHandler, boolean isSet) {
            this.socketHandler = socketHandler;
            this.isSet = isSet;
        }

        public void run() {
            assert (IoSocketDispatcher.this.isDispatcherInstanceThread());
            try {
                if (this.isSet) {
                    IoSocketDispatcher.this.setReadSelectionKeyNow(this.socketHandler);
                } else {
                    IoSocketDispatcher.this.unsetReadSelectionKeyNow(this.socketHandler);
                }
            }
            catch (Exception e2) {
                IOException e2 = ConnectionUtils.toIOException("Error by set read selection key now " + e2.toString(), e2);
                this.socketHandler.close(e2);
            }
        }

        public String toString() {
            return "setReadSelectionKeyTask#" + super.toString();
        }
    }

    private final class RegisterTask
    implements Runnable {
        private final IoSocketHandler socketHandler;
        private final int ops;

        public RegisterTask(IoSocketHandler socketHandler, int ops) {
            this.socketHandler = socketHandler;
            this.ops = ops;
        }

        public void run() {
            try {
                IoSocketDispatcher.this.registerHandlerNow(this.socketHandler, this.ops);
            }
            catch (IOException ioe) {
                ioe = ConnectionUtils.toIOException("error occured by registering handler " + this.socketHandler.getId() + " " + ioe.toString(), ioe);
                this.socketHandler.close(ioe);
            }
        }
    }
}

