/*
 * Decompiled with CFR 0.152.
 */
package org.xsocket.connection;

import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

abstract class MonitoredSelector {
    private static final Logger LOG = Logger.getLogger(MonitoredSelector.class.getName());
    private static final boolean IS_LOOPING_CHECK_ACTIVATED = Boolean.parseBoolean(System.getProperty("org.xsocket.connection.selector.looping.check", "true"));
    private static final boolean IS_REINIT_ACTIVATED = Boolean.parseBoolean(System.getProperty("org.xsocket.connection.selector.looping.reinit", "true"));
    private static final long LOG_PERIOD_MILLIS = 5000L;
    private static final int LOOPING_DETECTED_WAIT_TIME_MILLIS = 100;
    private static final int ZERO_COUNTER_THRESHOLD = 100;
    private static final int ZERO_COUNTER_TIME_THRESHOLD_MILLIS = 100;
    private int zeroCounter = 0;
    private long lastTimeEventCountIsZero = 0L;
    private long lastTimeSpinningLog = 0L;

    MonitoredSelector() {
    }

    protected final void checkForLooping(int eventCount) {
        this.checkForLooping(eventCount, 0L);
    }

    protected final void checkForLooping(int eventCount, long lastTimeWokeUpManually) {
        if (IS_LOOPING_CHECK_ACTIVATED) {
            if (eventCount == 0) {
                ++this.zeroCounter;
                if (this.zeroCounter == 1) {
                    this.lastTimeEventCountIsZero = System.currentTimeMillis();
                    return;
                }
                if (this.zeroCounter > 100) {
                    long current = System.currentTimeMillis();
                    if (current < this.lastTimeEventCountIsZero + 100L && current < lastTimeWokeUpManually + 100L) {
                        block12: {
                            if (current > this.lastTimeSpinningLog + 5000L) {
                                this.lastTimeSpinningLog = current;
                                LOG.warning("looping selector? (" + this.getNumRegisteredHandles() + " keys)\r\n" + this.printRegistered());
                            }
                            if (IS_REINIT_ACTIVATED) {
                                try {
                                    this.reinit();
                                }
                                catch (IOException ioe) {
                                    if (!LOG.isLoggable(Level.FINE)) break block12;
                                    LOG.fine("could not re-init selector " + ioe.toString());
                                }
                            }
                        }
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException ie) {
                            Thread.currentThread().interrupt();
                        }
                    }
                    this.zeroCounter = 0;
                }
            } else {
                this.zeroCounter = 0;
            }
        }
    }

    abstract int getNumRegisteredHandles();

    abstract String printRegistered();

    abstract void reinit() throws IOException;
}

