/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks;

import groovy.lang.Closure;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.Action;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.NamedDomainObjectFactory;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.util.ConfigureUtil;
import org.xtext.gradle.tasks.GeneratedAnnotationOptions;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.Outlet;

@Accessors
public class GeneratorConfig {
    @Input
    private boolean suppressWarningsAnnotation = true;
    @Input
    private String javaSourceLevel;
    @Nested
    private final GeneratedAnnotationOptions generatedAnnotation = new GeneratedAnnotationOptions();
    @Nested
    private final NamedDomainObjectContainer<Outlet> outlets;

    public GeneratorConfig(Project project, Language language) {
        NamedDomainObjectContainer _container;
        NamedDomainObjectFactory _function = outlet -> new Outlet(language, outlet);
        this.outlets = _container = project.container(Outlet.class, _function);
    }

    public NamedDomainObjectContainer<Outlet> outlets(Closure<?> configureClosure) {
        return (NamedDomainObjectContainer)ConfigureUtil.configure(configureClosure, this.outlets);
    }

    public void outlets(Action<NamedDomainObjectContainer<Outlet>> action) {
        action.execute(this.outlets);
    }

    @Internal
    public Outlet getOutlet() {
        return (Outlet)this.outlets.maybeCreate("DEFAULT_OUTPUT");
    }

    public Outlet outlet(Closure<?> configureClosure) {
        Outlet _outlet = this.getOutlet();
        return (Outlet)ConfigureUtil.configure(configureClosure, (Object)_outlet);
    }

    public void outlet(Action<Outlet> action) {
        Outlet _outlet = this.getOutlet();
        action.execute((Object)_outlet);
    }

    public GeneratedAnnotationOptions generatedAnnotation(Closure<?> configureClosure) {
        return (GeneratedAnnotationOptions)ConfigureUtil.configure(configureClosure, (Object)this.generatedAnnotation);
    }

    public void generatedAnnotation(Action<GeneratedAnnotationOptions> action) {
        action.execute((Object)this.generatedAnnotation);
    }

    @Pure
    public boolean isSuppressWarningsAnnotation() {
        return this.suppressWarningsAnnotation;
    }

    public void setSuppressWarningsAnnotation(boolean suppressWarningsAnnotation) {
        this.suppressWarningsAnnotation = suppressWarningsAnnotation;
    }

    @Pure
    public String getJavaSourceLevel() {
        return this.javaSourceLevel;
    }

    public void setJavaSourceLevel(String javaSourceLevel) {
        this.javaSourceLevel = javaSourceLevel;
    }

    @Pure
    public GeneratedAnnotationOptions getGeneratedAnnotation() {
        return this.generatedAnnotation;
    }

    @Pure
    public NamedDomainObjectContainer<Outlet> getOutlets() {
        return this.outlets;
    }
}

