/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks;

import groovy.lang.Closure;
import java.util.Map;
import org.eclipse.xtend.lib.annotations.AccessorType;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Pair;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.Action;
import org.gradle.api.Named;
import org.gradle.api.Project;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Nested;
import org.gradle.util.ConfigureUtil;
import org.xtext.gradle.tasks.DebuggerConfig;
import org.xtext.gradle.tasks.GeneratorConfig;
import org.xtext.gradle.tasks.ValidatorConfig;

@Accessors
public class Language
implements Named {
    @Input
    private final String name;
    @Input
    private String qualifiedName;
    @Input
    private String fileExtension;
    @Input
    private String setup;
    @Nested
    private final GeneratorConfig generator;
    @Nested
    private final DebuggerConfig debugger = new DebuggerConfig();
    @Nested
    private final ValidatorConfig validator = new ValidatorConfig();
    @Input
    private Map<String, Object> preferences = CollectionLiterals.newLinkedHashMap((Pair[])new Pair[0]);
    @Accessors(value={AccessorType.NONE})
    private final Project project;

    public Language(String name, Project project) {
        GeneratorConfig _generatorConfig;
        this.name = name;
        this.project = project;
        this.generator = _generatorConfig = new GeneratorConfig(project, this);
    }

    public String getQualifiedName() {
        String _replace;
        String _elvis = null;
        _elvis = this.qualifiedName != null ? this.qualifiedName : (_replace = this.setup.replace("StandaloneSetup", ""));
        return _elvis;
    }

    public String getFileExtension() {
        String _elvis = null;
        _elvis = this.fileExtension != null ? this.fileExtension : this.name;
        return _elvis;
    }

    public GeneratorConfig generator(Closure<?> configureClosure) {
        return (GeneratorConfig)ConfigureUtil.configure(configureClosure, (Object)this.generator);
    }

    public void generator(Action<GeneratorConfig> action) {
        action.execute((Object)this.generator);
    }

    public DebuggerConfig debugger(Closure<?> configureClosure) {
        return (DebuggerConfig)ConfigureUtil.configure(configureClosure, (Object)this.debugger);
    }

    public void debugger(Action<DebuggerConfig> action) {
        action.execute((Object)this.debugger);
    }

    public ValidatorConfig validator(Closure<?> configureClosure) {
        return (ValidatorConfig)ConfigureUtil.configure(configureClosure, (Object)this.validator);
    }

    public void validator(Action<ValidatorConfig> action) {
        action.execute((Object)this.validator);
    }

    public void preferences(Map<String, String> preferences) {
        this.preferences.putAll(preferences);
    }

    @Pure
    public String getName() {
        return this.name;
    }

    public void setQualifiedName(String qualifiedName) {
        this.qualifiedName = qualifiedName;
    }

    public void setFileExtension(String fileExtension) {
        this.fileExtension = fileExtension;
    }

    @Pure
    public String getSetup() {
        return this.setup;
    }

    public void setSetup(String setup) {
        this.setup = setup;
    }

    @Pure
    public GeneratorConfig getGenerator() {
        return this.generator;
    }

    @Pure
    public DebuggerConfig getDebugger() {
        return this.debugger;
    }

    @Pure
    public ValidatorConfig getValidator() {
        return this.validator;
    }

    @Pure
    public Map<String, Object> getPreferences() {
        return this.preferences;
    }

    public void setPreferences(Map<String, Object> preferences) {
        this.preferences = preferences;
    }
}

