/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks;

import com.google.common.base.CharMatcher;
import com.google.common.base.Objects;
import java.io.File;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.core.runtime.IPath;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ObjectExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.lib.Pure;
import org.gradle.api.DefaultTask;
import org.gradle.api.JavaVersion;
import org.gradle.api.NamedDomainObjectContainer;
import org.gradle.api.Project;
import org.gradle.api.internal.TaskOutputsInternal;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.OutputFiles;
import org.gradle.api.tasks.TaskAction;
import org.xtext.gradle.protocol.GradleInstallDebugInfoRequest;
import org.xtext.gradle.protocol.IssueSeverity;
import org.xtext.gradle.tasks.DebuggerConfig;
import org.xtext.gradle.tasks.GeneratedAnnotationOptions;
import org.xtext.gradle.tasks.GeneratorConfig;
import org.xtext.gradle.tasks.Language;
import org.xtext.gradle.tasks.Outlet;
import org.xtext.gradle.tasks.ValidatorConfig;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.XtextSourceSetOutputs;
import org.xtext.gradle.tasks.internal.XtextEclipsePreferences;

public class XtextEclipseSettings
extends DefaultTask {
    @Internal
    @Accessors
    private Set<XtextSourceDirectorySet> sourceSets;
    @Internal
    @Accessors
    private Set<Language> languages;

    public XtextEclipseSettings() {
        TaskOutputsInternal _outputs = this.getOutputs();
        Spec _function = it -> false;
        _outputs.upToDateWhen(_function);
    }

    @OutputFiles
    public Iterable<File> getOutputFiles() {
        Functions.Function1 _function = language -> {
            File _xblockexpression = null;
            Project _project = this.getProject();
            File _projectDir = _project.getProjectDir();
            String _qualifiedName = language.getQualifiedName();
            XtextEclipsePreferences prefs = new XtextEclipsePreferences(_projectDir, _qualifiedName);
            IPath _location = prefs.getLocation();
            _xblockexpression = _location.toFile();
            return _xblockexpression;
        };
        return IterableExtensions.map(this.languages, (Functions.Function1)_function);
    }

    @TaskAction
    public void writeSettings() {
        Consumer<Language> _function = language -> {
            try {
                Project _project = this.getProject();
                File _projectDir = _project.getProjectDir();
                String _qualifiedName = language.getQualifiedName();
                XtextEclipsePreferences prefs = new XtextEclipsePreferences(_projectDir, _qualifiedName);
                prefs.load();
                this.makeProjectSpecific(prefs);
                this.addGeneratorPreferences(prefs, (Language)language);
                this.addValidatorPreferences(prefs, (Language)language);
                this.addAdditionalPreferences(prefs, (Language)language);
                prefs.save();
            }
            catch (Throwable _e) {
                throw Exceptions.sneakyThrow((Throwable)_e);
            }
        };
        this.languages.forEach(_function);
    }

    private void makeProjectSpecific(XtextEclipsePreferences prefs) {
        prefs.putBoolean("BuilderConfiguration.is_project_specific", true);
        prefs.putBoolean("ValidatorConfiguration.is_project_specific", true);
    }

    private GeneratorConfig addGeneratorPreferences(XtextEclipsePreferences prefs, Language language) {
        GeneratorConfig _generator = language.getGenerator();
        Procedures.Procedure1 _function = it -> {
            boolean _tripleNotEquals;
            boolean _isSuppressWarningsAnnotation = it.isSuppressWarningsAnnotation();
            prefs.putBoolean("generateSuppressWarnings", _isSuppressWarningsAnnotation);
            GeneratedAnnotationOptions _generatedAnnotation = it.getGeneratedAnnotation();
            boolean _isActive = _generatedAnnotation.isActive();
            prefs.putBoolean("generateGeneratedAnnotation", _isActive);
            GeneratedAnnotationOptions _generatedAnnotation_1 = it.getGeneratedAnnotation();
            boolean _isIncludeDate = _generatedAnnotation_1.isIncludeDate();
            prefs.putBoolean("includeDateInGenerated", _isIncludeDate);
            GeneratedAnnotationOptions _generatedAnnotation_2 = it.getGeneratedAnnotation();
            String _comment = _generatedAnnotation_2.getComment();
            boolean bl = _tripleNotEquals = _comment != null;
            if (_tripleNotEquals) {
                GeneratedAnnotationOptions _generatedAnnotation_3 = it.getGeneratedAnnotation();
                String _comment_1 = _generatedAnnotation_3.getComment();
                prefs.put("generatedAnnotationComment", _comment_1);
            }
            String _javaSourceLevel = it.getJavaSourceLevel();
            JavaVersion _version = JavaVersion.toVersion((Object)_javaSourceLevel);
            String _majorVersion = _version.getMajorVersion();
            String _plus = "Java" + _majorVersion;
            prefs.put("targetJavaVersion", _plus);
            prefs.putBoolean("useJavaCompilerCompliance", false);
            NamedDomainObjectContainer<Outlet> _outlets = it.getOutlets();
            Consumer<Outlet> _function_1 = outlet -> this.addOutletPreferences(prefs, language, (Outlet)outlet);
            _outlets.forEach(_function_1);
        };
        return (GeneratorConfig)ObjectExtensions.operator_doubleArrow((Object)_generator, (Procedures.Procedure1)_function);
    }

    private void addOutletPreferences(XtextEclipsePreferences prefs, Language language, Outlet outlet) {
        Consumer<XtextSourceDirectorySet> _function = it -> {
            Set<File> _srcDirs = it.getSrcDirs();
            Consumer<File> _function_1 = dir -> {
                Project _project = this.getProject();
                String _relativePath = _project.relativePath(dir);
                String _canonicalize = this.canonicalize(_relativePath);
                String _plus = "sourceFolder." + _canonicalize;
                String _plus_1 = _plus + ".directory";
                String _outletKey = this.getOutletKey(outlet, _plus_1);
                Project _project_1 = this.getProject();
                XtextSourceSetOutputs _output = it.getOutput();
                File _dir = _output.getDir(outlet);
                String _relativePath_1 = _project_1.relativePath((Object)_dir);
                String _canonicalize_1 = this.canonicalize(_relativePath_1);
                prefs.put(_outletKey, _canonicalize_1);
            };
            _srcDirs.forEach(_function_1);
        };
        this.sourceSets.forEach(_function);
        String _outletKey = this.getOutletKey(outlet, "hideLocalSyntheticVariables");
        DebuggerConfig _debugger = language.getDebugger();
        boolean _isHideSyntheticVariables = _debugger.isHideSyntheticVariables();
        prefs.putBoolean(_outletKey, _isHideSyntheticVariables);
        String _outletKey_1 = this.getOutletKey(outlet, "installDslAsPrimarySource");
        DebuggerConfig _debugger_1 = language.getDebugger();
        GradleInstallDebugInfoRequest.SourceInstaller _sourceInstaller = _debugger_1.getSourceInstaller();
        boolean _equals = Objects.equal((Object)_sourceInstaller, (Object)GradleInstallDebugInfoRequest.SourceInstaller.PRIMARY);
        prefs.putBoolean(_outletKey_1, _equals);
        String _outletKey_2 = this.getOutletKey(outlet, "userOutputPerSourceFolder");
        prefs.putBoolean(_outletKey_2, true);
    }

    private void addValidatorPreferences(XtextEclipsePreferences prefs, Language language) {
        ValidatorConfig _validator = language.getValidator();
        Map<String, IssueSeverity> _severities = _validator.getSeverities();
        Set<Map.Entry<String, IssueSeverity>> _entrySet = _severities.entrySet();
        Consumer<Map.Entry> _function = it -> {
            String _key = (String)it.getKey();
            IssueSeverity _value = (IssueSeverity)it.getValue();
            String _string = _value.toString();
            prefs.put(_key, _string);
        };
        _entrySet.forEach(_function);
    }

    private void addAdditionalPreferences(XtextEclipsePreferences prefs, Language language) {
        Map<String, Object> _preferences = language.getPreferences();
        Set<Map.Entry<String, Object>> _entrySet = _preferences.entrySet();
        Consumer<Map.Entry> _function = it -> {
            String _key = (String)it.getKey();
            Object _value = it.getValue();
            String _string = _value.toString();
            prefs.put(_key, _string);
        };
        _entrySet.forEach(_function);
    }

    private String getOutletKey(Outlet output, String preferenceName) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"outlet.");
        String _name = output.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)".");
        _builder.append((Object)preferenceName, "");
        return _builder.toString();
    }

    private String canonicalize(String path) {
        CharMatcher _anyOf = CharMatcher.anyOf((CharSequence)"/");
        String _replace = path.replace("\\", "/");
        return _anyOf.trimTrailingFrom((CharSequence)_replace);
    }

    @Pure
    public Set<XtextSourceDirectorySet> getSourceSets() {
        return this.sourceSets;
    }

    public void setSourceSets(Set<XtextSourceDirectorySet> sourceSets) {
        this.sourceSets = sourceSets;
    }

    @Pure
    public Set<Language> getLanguages() {
        return this.languages;
    }

    public void setLanguages(Set<Language> languages) {
        this.languages = languages;
    }
}

