/*
 * Decompiled with CFR 0.152.
 */
package org.xtext.gradle.tasks.internal;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.eclipse.xtend.lib.annotations.Accessors;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.Pure;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.file.ConfigurableFileCollection;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.util.PatternFilterable;
import org.gradle.api.tasks.util.PatternSet;
import org.gradle.util.ConfigureUtil;
import org.xtext.gradle.tasks.XtextExtension;
import org.xtext.gradle.tasks.XtextSourceDirectorySet;
import org.xtext.gradle.tasks.XtextSourceSetOutputs;
import org.xtext.gradle.tasks.internal.DefaultXtextSourceSetOutputs;

public class DefaultXtextSourceDirectorySet
implements XtextSourceDirectorySet {
    @Accessors
    private final String name;
    @Accessors
    private final XtextSourceSetOutputs output;
    @Accessors
    private final PatternSet filter = new PatternSet();
    private Project project;
    private List<Object> source = CollectionLiterals.newArrayList((Object[])new Object[0]);

    public DefaultXtextSourceDirectorySet(String name, Project project, XtextExtension xtext) {
        this.name = name;
        this.project = project;
        DefaultXtextSourceSetOutputs _defaultXtextSourceSetOutputs = new DefaultXtextSourceSetOutputs(project, xtext);
        this.output = _defaultXtextSourceSetOutputs;
    }

    @Override
    public XtextSourceDirectorySet srcDir(Object srcDir) {
        this.source.add(srcDir);
        return this;
    }

    @Override
    public XtextSourceDirectorySet srcDirs(Object ... srcDirs) {
        this.source.add(srcDirs);
        return this;
    }

    @Override
    public XtextSourceDirectorySet setSrcDirs(Iterable<?> srcDirs) {
        this.source.clear();
        Iterables.addAll(this.source, srcDirs);
        return this;
    }

    @Override
    public FileTree getFiles() {
        Set<File> _srcDirs = this.getSrcDirs();
        ConfigurableFileCollection _files = this.project.files(new Object[]{_srcDirs});
        FileTree _asFileTree = _files.getAsFileTree();
        return _asFileTree.matching((PatternFilterable)this.filter);
    }

    @Override
    public Set<File> getSrcDirs() {
        ConfigurableFileCollection _files = this.project.files(new Object[]{this.source});
        Set _files_1 = _files.getFiles();
        Functions.Function1 _function = it -> {
            FileCollection _dirs = this.output.getDirs();
            boolean _contains = _dirs.contains(it);
            return !_contains;
        };
        Iterable _filter = IterableExtensions.filter((Iterable)_files_1, (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)_filter);
    }

    @Override
    public PatternFilterable getFilter() {
        return this.filter;
    }

    public Set<String> getIncludes() {
        return this.filter.getIncludes();
    }

    public Set<String> getExcludes() {
        return this.filter.getExcludes();
    }

    public PatternFilterable setIncludes(Iterable<String> includes) {
        this.filter.setIncludes(includes);
        return this;
    }

    public PatternFilterable setExcludes(Iterable<String> excludes) {
        this.filter.setExcludes(excludes);
        return this;
    }

    public PatternFilterable include(String ... includes) {
        this.filter.include(includes);
        return this;
    }

    public PatternFilterable include(Iterable<String> includes) {
        this.filter.include(includes);
        return this;
    }

    public PatternFilterable include(Spec<FileTreeElement> includeSpec) {
        this.filter.include(includeSpec);
        return this;
    }

    public PatternFilterable include(Closure includeSpec) {
        this.filter.include(includeSpec);
        return this;
    }

    public PatternFilterable exclude(Iterable<String> excludes) {
        this.filter.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(String ... excludes) {
        this.filter.exclude(excludes);
        return this;
    }

    public PatternFilterable exclude(Spec<FileTreeElement> excludeSpec) {
        this.filter.exclude(excludeSpec);
        return this;
    }

    public PatternFilterable exclude(Closure excludeSpec) {
        this.filter.exclude(excludeSpec);
        return this;
    }

    @Override
    public void output(Closure<?> configureAction) {
        ConfigureUtil.configure(configureAction, (Object)this.output);
    }

    @Override
    public void output(Action<XtextSourceSetOutputs> action) {
        action.execute((Object)this.output);
    }

    @Override
    public String getGeneratorTaskName() {
        String _xifexpression = null;
        boolean _equals = Objects.equal((Object)this.name, (Object)"main");
        if (_equals) {
            _xifexpression = "generateXtext";
        } else {
            String _firstUpper = StringExtensions.toFirstUpper((String)this.name);
            String _plus = "generate" + _firstUpper;
            _xifexpression = _plus + "Xtext";
        }
        return _xifexpression;
    }

    public String toString() {
        return this.source.toString();
    }

    @Override
    @Pure
    public String getName() {
        return this.name;
    }

    @Override
    @Pure
    public XtextSourceSetOutputs getOutput() {
        return this.output;
    }
}

